import { a as attr_class, c as clsx, e as escape_html, s as store_get, u as unsubscribe_stores } from "./index3.js";
import { t } from "./index.js";
import { I as Icon } from "./Icon.js";
import { C as ComputerDesktop } from "./ComputerDesktop.js";
import { D as DeviceTablet, a as DevicePhoneMobile } from "./DeviceTablet.js";
import { b as Badge } from "./client.svelte.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
function Setting($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      supportedPlatforms = { desktop: true, tablet: true, mobile: true },
      mainClass = "",
      optionClass = "",
      class: clazz = "",
      title,
      description,
      children,
      icon,
      adaptive = true
    } = $$props;
    $$renderer2.push(`<li${attr_class(
      clsx([
        "flex flex-col w-full justify-between gap-2 max-w-full @container/setting setting",
        mainClass
      ]),
      "svelte-uej830"
    )}>`);
    if (Object.values(supportedPlatforms).some((v) => v == false)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="flex items-center gap-2 flex-wrap">`);
      if (supportedPlatforms.desktop) {
        $$renderer2.push("<!--[-->");
        {
          let icon2 = function($$renderer3) {
            Icon($$renderer3, { src: ComputerDesktop, micro: true, size: "14" });
          };
          Badge($$renderer2, {
            icon: icon2,
            children: ($$renderer3) => {
              $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.desktop"))}`);
            },
            $$slots: { icon: true, default: true }
          });
        }
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (supportedPlatforms.tablet) {
        $$renderer2.push("<!--[-->");
        {
          let icon2 = function($$renderer3) {
            Icon($$renderer3, { src: DeviceTablet, micro: true, size: "14" });
          };
          Badge($$renderer2, {
            icon: icon2,
            children: ($$renderer3) => {
              $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.tablet"))}`);
            },
            $$slots: { icon: true, default: true }
          });
        }
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (supportedPlatforms.mobile) {
        $$renderer2.push("<!--[-->");
        {
          let icon2 = function($$renderer3) {
            Icon($$renderer3, { src: DevicePhoneMobile, micro: true, size: "14" });
          };
          Badge($$renderer2, {
            icon: icon2,
            children: ($$renderer3) => {
              $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.mobile"))}`);
            },
            $$slots: { icon: true, default: true }
          });
        }
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div${attr_class(clsx(["setting-grid items-center", adaptive && "adaptive", clazz]), "svelte-uej830")}>`);
    if (icon) {
      $$renderer2.push("<!--[-->");
      Icon($$renderer2, {
        src: icon,
        mini: true,
        size: "32",
        class: "bg-red-200/20 dark:bg-red-600/20 p-1.5 rounded-lg color\n          text-red-500 dark:text-red-300 float-left mr-2 clear-both",
        style: "grid-area: icon;"
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <h2 class="font-medium text-base" style="grid-area: title; place-self: end start;">`);
    title?.($$renderer2);
    $$renderer2.push(`<!----></h2> `);
    if (description) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="text-slate-600 dark:text-zinc-400 text-sm" style="grid-area: description; place-self: start start;">`);
      description?.($$renderer2);
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (children) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div${attr_class(
        clsx([
          "w-full flex flex-col gap-2 flex-1 max-w-full shrink-0 row-span-2 max-md:mt-2",
          optionClass
        ]),
        "svelte-uej830"
      )} style="grid-area: children;">`);
      children?.($$renderer2);
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div></li>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  Setting as S
};
//# sourceMappingURL=Setting.js.map
