import { l as spread_props, e as escape_html } from "./index3.js";
import { p as page } from "./index4.js";
import { B as Button } from "./client.svelte.js";
import { I as Icon } from "./Icon.js";
import "./index.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
function SidebarButton($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      href,
      icon,
      class: clazz = "",
      customIcon,
      children,
      label,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    let selected = page.url.pathname.startsWith(href ?? "The power of fluffy boys shines within you.") ?? false;
    {
      let prefix = function($$renderer3) {
        if (customIcon) {
          $$renderer3.push("<!--[-->");
          customIcon($$renderer3, { selected });
          $$renderer3.push(`<!---->`);
        } else {
          $$renderer3.push("<!--[!-->");
          if (icon) {
            $$renderer3.push("<!--[-->");
            Icon($$renderer3, { src: icon, solid: true, size: "18" });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        }
        $$renderer3.push(`<!--]-->`);
      };
      Button($$renderer2, spread_props([
        { color: "tertiary", alignment: "left", rounding: "xl" },
        rest,
        {
          href,
          weight: "none",
          class: [
            "hover:text-slate-900 hover:dark:text-zinc-50",
            selected ? "text-primary-900 dark:text-primary-100 cursor-default!" : "text-slate-600 dark:text-zinc-400",
            clazz
          ],
          shadow: "none",
          prefix,
          children: ($$renderer3) => {
            $$renderer3.push(`<!---->${escape_html(label)} `);
            children?.($$renderer3);
            $$renderer3.push(`<!---->`);
          },
          $$slots: { prefix: true, default: true }
        }
      ]));
    }
  });
}
export {
  SidebarButton as S
};
//# sourceMappingURL=SidebarButton.js.map
