import "clsx";
import { p as profile, a as getClient, t as toast, e as errorMessage } from "./client.svelte.js";
import "./index.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
function Subscribe($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { community = void 0, children } = $$props;
    let subscribing = false;
    async function subscribe(id = community?.community.id, subscribed = community?.subscribed) {
      if (!profile.current?.jwt) return;
      if (!id || !subscribed) return;
      subscribing = true;
      try {
        const res = await getClient().followCommunity({ community_id: id, follow: subscribed == "NotSubscribed" });
        subscribing = false;
        return res;
      } catch (err) {
        toast({ content: errorMessage(err), type: "error" });
      }
      subscribing = false;
    }
    children?.($$renderer2, { subscribe, subscribing });
    $$renderer2.push(`<!---->`);
  });
}
export {
  Subscribe as S
};
//# sourceMappingURL=Subscribe.js.map
