import { a as attr_class, b as attr, f as bind_props, k as stringify } from "./index3.js";
import "./client.svelte.js";
function Switch($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      checked = void 0,
      labelClass = "",
      class: clazz = "",
      children,
      description
    } = $$props;
    $$renderer2.push(`<label${attr_class(`font-normal cursor-pointer flex flex-row items-center gap-4 group ${stringify(clazz)}`, "svelte-9q5cns")}><div${attr_class(`w-11 h-6 rounded-full relative z-[inherit] cursor-pointer flex flex-row transition-colors shadow-xs ${stringify(checked ? "bg-primary-900 dark:bg-primary-100" : "bg-slate-200 dark:bg-zinc-800")} p-0.5 shrink-0`)}><input${attr("checked", checked, true)} type="checkbox" class="peer appearance-none absolute top-0 left-0 w-full h-full cursor-pointer z-10"/> <div class="box-border w-5 h-full bg-white dark:peer-checked:bg-black rounded-full shadow-xs group-active:w-5.5 transition peer-checked:translate-x-5 peer-checked:group-active:translate-x-4.5 peer-checked:rtl:-translate-x-5 peer-checked:group-active:rtl:-translate-x-4 svelte-9q5cns"></div></div> <div${attr_class(`flex flex-col ${stringify(labelClass)}`, "svelte-9q5cns")}>`);
    children?.($$renderer2);
    $$renderer2.push(`<!----> `);
    if (description) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<span class="font-normal text-sm text-slate-700 dark:text-zinc-300">`);
      description?.($$renderer2);
      $$renderer2.push(`<!----></span>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div></label>`);
    bind_props($$props, { checked });
  });
}
export {
  Switch as S
};
//# sourceMappingURL=Switch.js.map
