import { p as props_id, d as ensure_array_like, b as attr, k as stringify, e as escape_html, f as bind_props } from "./index3.js";
import { T as TabButton } from "./TabButton.js";
function Switch($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const id = props_id($$renderer2);
    let {
      options,
      disabled = [],
      optionNames = [],
      selected = void 0,
      children,
      onselect
    } = $$props;
    let selectedIndex = 0;
    $$renderer2.push(`<fieldset class="flex items-center gap-1 w-max max-w-full z-0 relative overflow-auto"><!--[-->`);
    const each_array = ensure_array_like(
      /* you see id like this to be a super simple
      
      */
      options
    );
    for (let index = 0, $$length = each_array.length; index < $$length; index++) {
      let option = each_array[index];
      $$renderer2.push(`<label><input type="radio"${attr("checked", selectedIndex === index, true)}${attr("value", index)}${attr("name", id)}${attr("id", `${stringify(id)}-${stringify(option?.toString())}`)} class="hidden"/> `);
      TabButton($$renderer2, {
        selected: selectedIndex == index,
        disabled: disabled[index],
        element: "div",
        children: ($$renderer3) => {
          $$renderer3.push(`<!---->${escape_html(optionNames[index] || option)}`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></label>`);
    }
    $$renderer2.push(`<!--]--></fieldset> `);
    children?.($$renderer2, { selected });
    $$renderer2.push(`<!---->`);
    bind_props($$props, { selected });
  });
}
export {
  Switch as S
};
//# sourceMappingURL=Switch2.js.map
