import { i as element, m as attributes, c as clsx } from "./index3.js";
import "./client.svelte.js";
function TabButton($$renderer, $$props) {
  const sizes = { sm: "px-2.5 py-1", md: "py-1.5 px-3.5" };
  let {
    selected = false,
    onselect,
    disabled,
    children,
    href,
    size = "sm",
    element: element$1 = href ? "a" : "button",
    $$slots,
    $$events,
    ...rest
  } = $$props;
  element(
    $$renderer,
    element$1,
    () => {
      $$renderer.push(`${attributes(
        {
          class: clsx([
            sizes[size],
            "tab-button",
            selected ? "btn-primary" : "btn-secondary"
          ]),
          disabled,
          href,
          ...rest
        },
        "svelte-yp9nw4"
      )}`);
    },
    () => {
      children?.($$renderer);
      $$renderer.push(`<!---->`);
    }
  );
}
export {
  TabButton as T
};
//# sourceMappingURL=TabButton.js.map
