import { a as attr_class, c as clsx, d as ensure_array_like, b as attr, e as escape_html } from "./index3.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { S as SvelteURL } from "./client.svelte.js";
import { p as page } from "./index4.js";
import { T as TabButton } from "./TabButton.js";
function Tabs($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      routes,
      currentRoute = void 0,
      buildUrl = (_, href) => href,
      children,
      style = "header",
      margin = true
    } = $$props;
    let matchType = routes.map((i) => new URL(`https://example.com${i.href}`)?.search != "" ? "search" : "pathname");
    function isSelected(url, href, type) {
      const currentSearch = new Set(url.searchParams.values());
      const hrefSearch = new Set(href.searchParams.values());
      const usePathname = !routes.some((i) => new Set(new URL(`https://example.com${i.href}`).searchParams.values()).intersection(currentSearch).size > 0);
      const hasSearchParam = hrefSearch.intersection(currentSearch).size > 0;
      if (hasSearchParam && !usePathname) return hasSearchParam;
      else if ((url.search == "" || usePathname) && type == "pathname") return href.pathname == url.pathname;
    }
    $$renderer2.push(`<nav${attr_class(
      clsx([
        "tab-bar",
        style == "header" ? "bar-header" : "gap-2",
        margin && "my-2",
        margin && style == "subpage" && "mb-3"
      ]),
      "svelte-iv6r04"
    )}><!--[-->`);
    const each_array = ensure_array_like(routes);
    for (let index = 0, $$length = each_array.length; index < $$length; index++) {
      let route = each_array[index];
      const selected = isSelected(page.url, new SvelteURL(`${page.url.origin}${route.href}`), matchType[index]);
      if (style == "header") {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<a${attr("href", buildUrl(currentRoute, route.href))}${attr_class(clsx(["tab-item ", selected && "tab-selected"]), "svelte-iv6r04")}>${escape_html(route.name)}</a>`);
      } else {
        $$renderer2.push("<!--[!-->");
        TabButton($$renderer2, {
          href: buildUrl(currentRoute, route.href),
          selected,
          children: ($$renderer3) => {
            $$renderer3.push(`<!---->${escape_html(route.name)}`);
          },
          $$slots: { default: true }
        });
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--> `);
    children?.($$renderer2);
    $$renderer2.push(`<!----></nav>`);
  });
}
export {
  Tabs as T
};
//# sourceMappingURL=Tabs.js.map
