import { a as attr_class, k as stringify, m as attributes, c as clsx, e as escape_html, f as bind_props } from "./index3.js";
import "./client.svelte.js";
import { g as generateID } from "./helper.js";
import { L as Label } from "./Label.js";
import "./index.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
const sizeClass = { sm: "p-3", md: "p-4", lg: "p-5" };
function TextArea($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const borderClass = `
	border border-slate-200 dark:border-zinc-800
	`;
    let {
      label = void 0,
      value = void 0,
      placeholder = "",
      disabled = false,
      required = false,
      size = "md",
      id = generateID(),
      rows = 4,
      element = void 0,
      class: clazz = "",
      customLabel,
      suffix,
      children,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    $$renderer2.push(`<div${attr_class(`flex flex-col gap-1 ${stringify(clazz)}`)}>`);
    if (customLabel || label) {
      $$renderer2.push("<!--[-->");
      Label($$renderer2, {
        for: id,
        text: label,
        class: `peer-invalid:text-red-500 ${stringify(required ? "after:content-['*'] after:text-red-500 after:ml-1" : "")}`,
        children: ($$renderer3) => {
          customLabel?.($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div${attr_class(`rounded-xl flex flex-col items-center text-sm bg-white dark:bg-zinc-950 ${stringify(clazz)}`)}><textarea${attributes({
      id,
      placeholder,
      disabled,
      rows,
      ...rest,
      class: clsx([
        sizeClass[size],
        borderClass,
        `focus:border-slate-800 dark:focus:border-zinc-200 bg-white dark:bg-zinc-950
      focus:outline-hidden focus:ring-2 ring-slate-800/50 rounded-xl dark:ring-zinc-200/50
      transition-all text-sm w-full disabled:bg-slate-100
		disabled:cursor-not-allowed dark:disabled:bg-zinc-900 invalid:border-red-500!
		peer invalid:text-red-500 z-10`,
        suffix && "rounded-b-none border-b-0",
        clazz
      ])
    })}>`);
    const $$body = escape_html(value);
    if ($$body) {
      $$renderer2.push(`${$$body}`);
    }
    $$renderer2.push(`</textarea> `);
    if (suffix) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div${attr_class(`${stringify(borderClass)} ${stringify(sizeClass[size])} w-full border-t-0 rounded-xl rounded-t-none flex items-center`)}>`);
      suffix?.($$renderer2);
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div> `);
    children?.($$renderer2);
    $$renderer2.push(`<!----></div>`);
    bind_props($$props, { value, element });
  });
}
export {
  TextArea as T
};
//# sourceMappingURL=TextArea.js.map
