import { a as attr_class, c as clsx, m as attributes, f as bind_props, k as stringify } from "./index3.js";
import "./client.svelte.js";
import { g as generateID } from "./helper.js";
import { L as Label } from "./Label.js";
import "./index.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
const sizeClass = { sm: "px-3 py-1", md: "px-3.5 py-1.5", lg: "px-5 py-3" };
const shadowClass = { sm: "shadow-xs", none: "shadow-none" };
function TextInput($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const borderClass = `border border-slate-200 border-b-slate-300 dark:border-zinc-800`;
    let {
      label = void 0,
      value = void 0,
      placeholder = "",
      disabled = false,
      required = false,
      size = "md",
      id = generateID(),
      inlineAffixes = false,
      shadow = "sm",
      element = void 0,
      class: clazz = "",
      customLabel: passedCustomLabel,
      prefix,
      suffix,
      children,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    $$renderer2.push(`<div${attr_class(`flex flex-col gap-1 ${stringify(clazz)}`)}>`);
    if (passedCustomLabel || label) {
      $$renderer2.push("<!--[-->");
      Label($$renderer2, {
        for: id,
        text: label,
        class: [
          "peer-invalid:text-red-500 relative",
          required && "after:content-['*'] after:text-red-500 after:ml-1"
        ],
        children: ($$renderer3) => {
          passedCustomLabel?.($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div${attr_class(clsx([
      shadowClass[shadow],
      borderClass,
      `border focus-within:border-primary-900 dark:focus-within:border-primary-100 focus-within:ring-2
  ring-slate-300 dark:ring-zinc-700
  transition-colors
  rounded-xl flex flex-row items-center text-sm`,
      clazz
    ]))}>`);
    if (prefix) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div${attr_class(clsx([
        "rounded-xl rounded-r-none text-slate-600 dark:text-zinc-400",
        inlineAffixes && "bg-white dark:bg-zinc-900 pr-0 w-8",
        sizeClass[size]
      ]))}>`);
      prefix?.($$renderer2);
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <input${attributes(
      {
        type: "text",
        id,
        placeholder,
        disabled,
        value,
        required,
        ...rest,
        class: clsx([
          sizeClass[size],
          `bg-white dark:bg-zinc-900
		 focus:outline-hidden rounded-xl text-sm w-full disabled:bg-slate-100
		disabled:cursor-not-allowed dark:disabled:bg-zinc-800 invalid:border-red-500!
		peer invalid:text-red-500 z-10`,
          prefix && "rounded-l-none",
          prefix && inlineAffixes && "border-l-0",
          suffix && "rounded-r-none",
          suffix && inlineAffixes && "border-r-0",
          clazz
        ])
      },
      void 0,
      void 0,
      void 0,
      4
    )}/> `);
    if (suffix) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div${attr_class(clsx([
        "rounded-xl rounded-l-none text-slate-600 dark:text-zinc-400 h-full",
        inlineAffixes && "bg-white dark:bg-zinc-900 pl-0"
      ]))}>`);
      suffix?.($$renderer2);
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div> `);
    children?.($$renderer2);
    $$renderer2.push(`<!----></div>`);
    bind_props($$props, { value, element });
  });
}
export {
  TextInput as T
};
//# sourceMappingURL=TextInput.js.map
