import { f as bind_props, e as escape_html, s as store_get, u as unsubscribe_stores } from "./index3.js";
import { t } from "./index.js";
import { I as Icon } from "./Icon.js";
import { C as ComputerDesktop } from "./ComputerDesktop.js";
import { D as DeviceTablet, a as DevicePhoneMobile } from "./DeviceTablet.js";
import { b as Badge } from "./client.svelte.js";
import { S as Switch } from "./Switch.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
function ToggleSetting($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      title,
      description = void 0,
      checked = false,
      beta = false,
      supportedPlatforms = { desktop: true, tablet: true, mobile: true },
      icon
    } = $$props;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<li class="flex flex-col w-full justify-between gap-x-2 max-w-full setting @container/setting">`);
      if (Object.values(supportedPlatforms).some((v) => v == false) || beta) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex items-center gap-2 flex-wrap">`);
        if (beta) {
          $$renderer3.push("<!--[-->");
          Badge($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->Beta`);
            },
            $$slots: { default: true }
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        if (Object.values(supportedPlatforms).some((v) => v == false)) {
          $$renderer3.push("<!--[-->");
          if (supportedPlatforms.desktop) {
            $$renderer3.push("<!--[-->");
            {
              let icon2 = function($$renderer4) {
                Icon($$renderer4, { src: ComputerDesktop, micro: true, size: "14" });
              };
              Badge($$renderer3, {
                icon: icon2,
                children: ($$renderer4) => {
                  $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.desktop"))}`);
                },
                $$slots: { icon: true, default: true }
              });
            }
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          if (supportedPlatforms.tablet) {
            $$renderer3.push("<!--[-->");
            {
              let icon2 = function($$renderer4) {
                Icon($$renderer4, { src: DeviceTablet, micro: true, size: "14" });
              };
              Badge($$renderer3, {
                icon: icon2,
                children: ($$renderer4) => {
                  $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.tablet"))}`);
                },
                $$slots: { icon: true, default: true }
              });
            }
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          if (supportedPlatforms.mobile) {
            $$renderer3.push("<!--[-->");
            {
              let icon2 = function($$renderer4) {
                Icon($$renderer4, { src: DevicePhoneMobile, micro: true, size: "14" });
              };
              Badge($$renderer3, {
                icon: icon2,
                children: ($$renderer4) => {
                  $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.mobile"))}`);
                },
                $$slots: { icon: true, default: true }
              });
            }
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <div class="flex @md/setting:flex-row gap-2">`);
      if (icon) {
        $$renderer3.push("<!--[-->");
        Icon($$renderer3, {
          src: icon,
          size: "32",
          mini: true,
          class: "bg-red-200/20 dark:bg-red-600/20 p-1.5 self-center\n         rounded-lg color text-red-500 dark:text-red-300"
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      Switch($$renderer3, {
        class: "flex-row-reverse items-center w-full",
        labelClass: "flex-1 mr-auto",
        get checked() {
          return checked;
        },
        set checked($$value) {
          checked = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<h1 class="font-medium text-base">${escape_html(title)}</h1> `);
          if (description) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<p class="text-slate-600 dark:text-zinc-400 text-sm">${escape_html(description)}</p>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></div></li>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { checked });
  });
}
export {
  ToggleSetting as T
};
//# sourceMappingURL=ToggleSetting.js.map
