import { a as attr_class, b as attr, c as clsx, e as escape_html, k as stringify } from "./index3.js";
import { u as userLink, h as Avatar } from "./client.svelte.js";
import { L as LabelStat } from "./LabelStat.js";
function UserItem($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      user,
      view = "compact",
      showCounts = true,
      class: clazz = "flex flex-col gap-4 text-sm max-w-full relative",
      icon
    } = $$props;
    $$renderer2.push(`<div${attr_class(clsx(clazz))}><div${attr_class(`flex ${stringify(view == "cozy" ? "flex-col gap-2" : "flex-row")} items-center max-w-full w-full`)}><a${attr("href", userLink(user.person))} class="flex-1"><div${attr_class(`flex ${stringify(view == "cozy" ? "flex-col gap-2" : "flex-row")} gap-2 items-center`)}>`);
    if (icon) {
      $$renderer2.push("<!--[-->");
      icon($$renderer2);
      $$renderer2.push(`<!---->`);
    } else {
      $$renderer2.push("<!--[!-->");
      Avatar($$renderer2, { url: user.person.avatar, width: 32, alt: user.person.name });
    }
    $$renderer2.push(`<!--]--> <div class="flex flex-col"><div class="font-medium text-base">${escape_html(user.person.display_name ?? user.person.name)}</div> <div class="text-sm text-slate-600 dark:text-zinc-400">${escape_html(new URL(user.person.actor_id).hostname)}</div></div></div></a></div> `);
    if (showCounts) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="flex flex-row gap-3 items-center justify-center">`);
      if (user.counts.post_count) {
        $$renderer2.push("<!--[-->");
        LabelStat($$renderer2, {
          content: user.counts.post_count.toString(),
          formatted: true,
          label: "Posts"
        });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (user.counts.comment_count) {
        $$renderer2.push("<!--[-->");
        LabelStat($$renderer2, {
          content: user.counts.comment_count.toString(),
          formatted: true,
          label: "Comments"
        });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div>`);
  });
}
export {
  UserItem as U
};
//# sourceMappingURL=UserItem.js.map
