import { u as unsubscribe_stores, f as bind_props, s as store_get, g as await_block, e as escape_html, d as ensure_array_like, b as attr, k as stringify } from "./index3.js";
import { Q as isPostView, c as client, w as isCommentView, U as UserLink, B as Button, y as Spinner } from "./client.svelte.js";
import { t } from "./index.js";
import { I as Icon } from "./Icon.js";
import { A as ArrowDownCircle } from "./ArrowDownCircle.js";
import { C as ChevronLeft } from "./ChevronLeft.js";
import { C as ChevronRight } from "./ChevronRight.js";
import { N as Newspaper } from "./Newspaper.js";
import { M as Modal } from "./Modal.js";
const ArrowUpCircle = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M8 1a7 7 0 1 0 0 14A7 7 0 0 0 8 1Zm-.75 10.25a.75.75 0 0 0 1.5 0V6.56l1.22 1.22a.75.75 0 1 0 1.06-1.06l-2.5-2.5a.75.75 0 0 0-1.06 0l-2.5 2.5a.75.75 0 0 0 1.06 1.06l1.22-1.22v4.69Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm-.75-4.75a.75.75 0 0 0 1.5 0V8.66l1.95 2.1a.75.75 0 1 0 1.1-1.02l-3.25-3.5a.75.75 0 0 0-1.1 0L6.2 9.74a.75.75 0 1 0 1.1 1.02l1.95-2.1v4.59Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "m15 11.25-3-3m0 0-3 3m3-3v7.5M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25Zm.53 5.47a.75.75 0 0 0-1.06 0l-3 3a.75.75 0 1 0 1.06 1.06l1.72-1.72v5.69a.75.75 0 0 0 1.5 0v-5.69l1.72 1.72a.75.75 0 1 0 1.06-1.06l-3-3Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
function ViewVotesModal($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { open = void 0, item = void 0 } = $$props;
    let page = 1;
    async function loadVotes(page2) {
      if (!item) return [];
      if (isPostView(item)) return await client().listPostLikes({ post_id: item.post.id, limit: 50, page: page2 }).then((i) => i.post_likes);
      if (isCommentView(item)) return await client().listCommentLikes({ comment_id: item.comment.id, limit: 50, page: page2 }).then((i) => i.comment_likes);
      return [];
    }
    let votes = loadVotes(page);
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Modal($$renderer3, {
        title: store_get($$store_subs ??= {}, "$t", t)("moderation.votes"),
        get open() {
          return open;
        },
        set open($$value) {
          open = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex flex-col gap-1">`);
          await_block(
            $$renderer4,
            votes,
            () => {
              $$renderer4.push(`<div class="self-center justify-self-center h-48 grid place-items-center">`);
              Spinner($$renderer4, { width: 24 });
              $$renderer4.push(`<!----></div>`);
            },
            (votes2) => {
              $$renderer4.push(`<table class="w-full border-collapse overflow-y-auto table-fixed"><thead><tr class="border divide-x divide-slate-200 dark:divide-zinc-800 border-slate-200 dark:border-zinc-800 *:px-4 *:py-2"><th style="width: 6%;"></th><th style="width: 60%;" class="text-left">${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.applications.user"))}</th><th style="width: 5%;"></th></tr></thead><tbody class="divide-y divide-slate-200 dark:divide-zinc-800"><!--[-->`);
              const each_array = ensure_array_like(votes2);
              for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                let vote = each_array[$$index];
                $$renderer4.push(`<tr><td class="py-1 px-1 w-full">`);
                Icon($$renderer4, {
                  src: vote.score == 1 ? ArrowUpCircle : ArrowDownCircle,
                  mini: true,
                  size: "20",
                  class: vote.score == 1 ? "text-blue-400" : "text-red-400",
                  "aria-label": vote.score == 1 ? store_get($$store_subs ??= {}, "$t", t)("routes.profile.upvoted") : store_get($$store_subs ??= {}, "$t", t)("routes.profile.downvoted")
                });
                $$renderer4.push(`<!----></td><td class="text-sm w-full overflow-hidden">`);
                UserLink($$renderer4, {
                  user: { ...vote.creator, banned: vote.creator_banned_from_community }
                });
                $$renderer4.push(`<!----></td><td class="text-sm w-full text-right"><a${attr("href", `/modlog?user=${stringify(vote.creator.id)}`)} data-sveltekit-preload-data="tap" class="text-green-400 hover:underline flex flex-row items-center gap-1 font-medium text-xs"${attr("aria-label", store_get($$store_subs ??= {}, "$t", t)("moderation.modlog.user"))}>`);
                Icon($$renderer4, { src: Newspaper, size: "18", micro: true });
                $$renderer4.push(`<!----></a></td></tr>`);
              }
              $$renderer4.push(`<!--]--></tbody></table> `);
              if (!(votes2.length < 50 && page == 1)) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<div class="flex flex-row justify-center items-center gap-2">`);
                Button($$renderer4, {
                  onclick: () => page--,
                  color: "ghost",
                  "aria-label": store_get($$store_subs ??= {}, "$t", t)("common.back"),
                  rounding: "pill",
                  size: "square-md",
                  disabled: page == 1,
                  children: ($$renderer5) => {
                    Icon($$renderer5, { src: ChevronLeft, size: "20", mini: true });
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----> ${escape_html(page)} `);
                Button($$renderer4, {
                  onclick: () => page++,
                  color: "ghost",
                  "aria-label": store_get($$store_subs ??= {}, "$t", t)("common.next"),
                  rounding: "pill",
                  size: "square-md",
                  disabled: votes2.length < 50,
                  children: ($$renderer5) => {
                    Icon($$renderer5, { src: ChevronRight, size: "20", mini: true });
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----></div>`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]-->`);
            }
          );
          $$renderer4.push(`<!--]--></div>`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { open, item });
  });
}
export {
  ViewVotesModal as default
};
//# sourceMappingURL=ViewVotesModal.js.map
