import { d as ensure_array_like, f as bind_props, e as escape_html, s as store_get, u as unsubscribe_stores, b as attr, a as attr_class, c as clsx } from "./index3.js";
import { s as settings } from "./settings.svelte.js";
import { P as Placeholder } from "./Placeholder.js";
import { B as Button, o as Plus, z as SvelteSet } from "./client.svelte.js";
import { t } from "./index.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { P as Post } from "./PostActions.js";
import "@sveltejs/kit";
import "lemmy-js-client";
import "openapi-fetch";
import "@dicebear/core";
import "@dicebear/initials";
import { b as browser } from "./index5.js";
import { o as onDestroy } from "./index-server.js";
import { A as ArrowTopRightOnSquare } from "./DocumentText.js";
import { V as VirtualList } from "./VirtualList.js";
const ArchiveBox = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M3 2a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1H3Z"
      },
      {
        "fill-rule": "evenodd",
        "d": "M3 6h10v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V6Zm3 2.75A.75.75 0 0 1 6.75 8h2.5a.75.75 0 0 1 0 1.5h-2.5A.75.75 0 0 1 6 8.75Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M2 3a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1H2Z"
      },
      {
        "fill-rule": "evenodd",
        "d": "M2 7.5h16l-.811 7.71a2 2 0 0 1-1.99 1.79H4.802a2 2 0 0 1-1.99-1.79L2 7.5ZM7 11a1 1 0 0 1 1-1h4a1 1 0 1 1 0 2H8a1 1 0 0 1-1-1Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "m20.25 7.5-.625 10.632a2.25 2.25 0 0 1-2.247 2.118H6.622a2.25 2.25 0 0 1-2.247-2.118L3.75 7.5M10 11.25h4M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M3.375 3C2.339 3 1.5 3.84 1.5 4.875v.75c0 1.036.84 1.875 1.875 1.875h17.25c1.035 0 1.875-.84 1.875-1.875v-.75C22.5 3.839 21.66 3 20.625 3H3.375Z"
      },
      {
        "fill-rule": "evenodd",
        "d": "m3.087 9 .54 9.176A3 3 0 0 0 6.62 21h10.757a3 3 0 0 0 2.995-2.824L20.913 9H3.087Zm6.163 3.75A.75.75 0 0 1 10 12h4a.75.75 0 0 1 0 1.5h-4a.75.75 0 0 1-.75-.75Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const ArrowRight = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2 8a.75.75 0 0 1 .75-.75h8.69L8.22 4.03a.75.75 0 0 1 1.06-1.06l4.5 4.5a.75.75 0 0 1 0 1.06l-4.5 4.5a.75.75 0 0 1-1.06-1.06l3.22-3.22H2.75A.75.75 0 0 1 2 8Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M3 10a.75.75 0 0 1 .75-.75h10.638L10.23 5.29a.75.75 0 1 1 1.04-1.08l5.5 5.25a.75.75 0 0 1 0 1.08l-5.5 5.25a.75.75 0 1 1-1.04-1.08l4.158-3.96H3.75A.75.75 0 0 1 3 10Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M13.5 4.5 21 12m0 0-7.5 7.5M21 12H3"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M12.97 3.97a.75.75 0 0 1 1.06 0l7.5 7.5a.75.75 0 0 1 0 1.06l-7.5 7.5a.75.75 0 1 1-1.06-1.06l6.22-6.22H3a.75.75 0 0 1 0-1.5h16.19l-6.22-6.22a.75.75 0 0 1 0-1.06Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
function PostFeed($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { posts = void 0, community = false, children } = $$props;
    $$renderer2.push(`<ul class="flex flex-col list-none divide-y divide-slate-200 dark:divide-zinc-800">`);
    if (posts?.length == 0) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="h-full grid place-items-center">`);
      Placeholder($$renderer2, {
        icon: ArchiveBox,
        title: "No posts",
        description: "There are no posts that match this filter.",
        children: ($$renderer3) => {
          Button($$renderer3, {
            href: "/communities",
            icon: Plus,
            children: ($$renderer4) => {
              $$renderer4.push(`<span>Follow some communities</span>`);
            },
            $$slots: { default: true }
          });
        }
      });
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<!--[-->`);
      const each_array = ensure_array_like(posts);
      for (let index = 0, $$length = each_array.length; index < $$length; index++) {
        let post = each_array[index];
        $$renderer2.push(`<li class="relative post-container">`);
        Post($$renderer2, {
          hideCommunity: community,
          view: (post.post.featured_community || post.post.featured_local) && settings.posts.compactFeatured ? "compact" : settings.view,
          post,
          class: "transition-all duration-250",
          onhide: () => {
            posts = posts.toSpliced(index, 1);
          }
        });
        $$renderer2.push(`<!----></li>`);
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--> `);
    children?.($$renderer2);
    $$renderer2.push(`<!----></ul>`);
    bind_props($$props, { posts });
  });
}
function VirtualFeed($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      posts = void 0,
      params = void 0,
      virtualList = void 0,
      lastSeen = 0,
      community = false,
      children
    } = $$props;
    let listEl = void 0;
    const abortLoad = new AbortController();
    new SvelteSet(posts.map((post) => post.post.id));
    let initialOffset = listEl?.offsetTop;
    onDestroy(() => {
      abortLoad?.abort();
    });
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<ul class="flex flex-col list-none"><!---->`);
      {
        if (posts?.length == 0) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="h-full grid place-items-center my-8">`);
          Placeholder($$renderer3, {
            icon: ArchiveBox,
            title: store_get($$store_subs ??= {}, "$t", t)("routes.frontpage.empty.title"),
            description: store_get($$store_subs ??= {}, "$t", t)("routes.frontpage.empty.description"),
            children: ($$renderer4) => {
              Button($$renderer4, {
                href: "/communities",
                rounding: "pill",
                color: "primary",
                icon: ArrowTopRightOnSquare,
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.communities"))}`);
                },
                $$slots: { default: true }
              });
            }
          });
          $$renderer3.push(`<!----></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
          {
            let item = function($$renderer4, row) {
              $$renderer4.push(`<li${attr("data-index", row)}${attr_class(clsx(["relative post-container", row < 7 && ""]))}>`);
              Post($$renderer4, {
                hideCommunity: community,
                view: (posts[row]?.post.featured_community || posts[row]?.post.featured_local) && settings.posts.compactFeatured ? "compact" : settings.view,
                onhide: () => {
                  posts = posts.toSpliced(row, 1);
                },
                class: "px-3 sm:px-6 hover:bg-slate-100/30 hover:dark:bg-zinc-900/30 transition-colors",
                get post() {
                  return posts[row];
                },
                set post($$value) {
                  posts[row] = $$value;
                  $$settled = false;
                }
              });
              $$renderer4.push(`<!----></li>`);
            };
            VirtualList($$renderer3, {
              id: "feed",
              class: "divide-y -mx-3 sm:-mx-6 divide-slate-100 dark:divide-zinc-900",
              items: posts,
              initialOffset,
              overscan: 3,
              estimatedHeight: settings.view == "cozy" ? 500 : 150,
              get restore() {
                return virtualList;
              },
              set restore($$value) {
                virtualList = $$value;
                $$settled = false;
              },
              item,
              $$slots: { item: true }
            });
          }
        }
        $$renderer3.push(`<!--]-->`);
      }
      $$renderer3.push(`<!----> `);
      if (settings.infiniteScroll && browser) ;
      else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      children?.($$renderer3);
      $$renderer3.push(`<!----></ul>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { posts, params, virtualList, lastSeen });
  });
}
export {
  ArrowRight as A,
  PostFeed as P,
  VirtualFeed as V
};
//# sourceMappingURL=VirtualFeed.js.map
