import { m as attributes, j as attr_style, k as stringify, d as ensure_array_like, b as attr, f as bind_props, e as escape_html } from "./index3.js";
import { E as Expandable } from "./client.svelte.js";
import "./index.js";
import { o as onDestroy } from "./index-server.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { d as debounce } from "./time.js";
import { c as createSubscriber, o as on } from "./events.js";
import "clsx";
import { s as settings } from "./settings.svelte.js";
class ReactiveValue {
  #fn;
  #subscribe;
  /**
   *
   * @param {() => T} fn
   * @param {(update: () => void) => void} onsubscribe
   */
  constructor(fn, onsubscribe) {
    this.#fn = fn;
    this.#subscribe = createSubscriber(onsubscribe);
  }
  get current() {
    this.#subscribe();
    return this.#fn();
  }
}
const innerHeight = new ReactiveValue(
  () => void 0,
  (update) => on(window, "resize", update)
);
function VirtualList($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      items,
      estimatedHeight = 100,
      overscan = 6,
      item: itemSnippet,
      initialOffset = 0,
      restore = void 0,
      debounceResize = 100,
      useWindow = true,
      height = 0,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    function scrollToIndex(index, useWindow2 = false) {
      const targetPx = cumulativeItemHeights[index] - (initialOffset || 0);
      if (targetPx < (innerHeight.current ?? 0)) return;
      scrollY = targetPx;
    }
    onDestroy(() => {
      restore = { itemHeights };
    });
    let itemHeights = [...restore?.itemHeights ?? Array(items.length).fill(null)];
    let cumulativeItemHeights = (() => {
      let cumulation = new Array(itemHeights.length);
      let sum = 0;
      for (let i = 0; i < itemHeights.length; i++) {
        const height2 = itemHeights[i] || estimatedHeight;
        sum += height2;
        cumulation[i] = sum;
      }
      return cumulation;
    })();
    let scrollY = 0;
    let viewportHeight = 0;
    let visibleItems = [];
    function updateVisibleItems() {
      return [];
    }
    const debouncedUpdate = debounce(
      (entries) => {
        for (const entry of entries) {
          const indexAttr = entry.target.getAttribute("data-index");
          if (indexAttr === null) continue;
          const index = Number(indexAttr);
          if (isNaN(index)) continue;
          const newHeight = entry.contentRect.height;
          if (itemHeights[index] !== newHeight) {
            itemHeights[index] = newHeight;
            visibleItems = updateVisibleItems();
          }
        }
      },
      debounceResize
    );
    const observer = new ResizeObserver((entries) => {
      debouncedUpdate(entries);
    });
    onDestroy(() => {
      observer.disconnect();
    });
    $$renderer2.push(`<div${attributes(
      {
        style: `position: relative; height: ${stringify(height || cumulativeItemHeights[visibleItems?.[visibleItems.length - 1]?.index])}px;`,
        ...rest,
        id: "feed"
      },
      "svelte-vneox3"
    )}><div${attr_style(`height: ${stringify(cumulativeItemHeights[visibleItems?.[0]?.index - 1] || 0)}px; border: 0 !important;`)}></div> <!--[-->`);
    const each_array = ensure_array_like(visibleItems);
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let item = each_array[$$index];
      $$renderer2.push(`<div${attr("data-index", item.index)} class="post-container fix-divide group/virtual svelte-vneox3">`);
      itemSnippet($$renderer2, item.index);
      $$renderer2.push(`<!----></div>`);
    }
    $$renderer2.push(`<!--]--></div> `);
    if (settings.debugInfo) {
      $$renderer2.push("<!--[-->");
      {
        let title = function($$renderer3) {
          $$renderer3.push(`<!---->Debug`);
        };
        Expandable($$renderer2, {
          title,
          children: ($$renderer3) => {
            $$renderer3.push(`<pre>
      Virtual list debug info

      List items: ${escape_html(items.length)}
      Rendering items: ${escape_html(visibleItems?.length)} (${escape_html(visibleItems?.[0]?.index)} - ${escape_html(visibleItems?.[visibleItems?.length - 1]?.index)})
      Viewport height: ${escape_html(viewportHeight)}
      Current scroll position: ${escape_html(scrollY)}
      Container height: ${escape_html(cumulativeItemHeights[visibleItems?.[visibleItems?.length - 1]?.index])}
      Overscan: ${escape_html(overscan)}
      Guess item height: ${escape_html(estimatedHeight)}
      Bumpscosity: ${escape_html(Math.floor(Math.random() * 5e3))}
      Restore data: ${escape_html(JSON.stringify(restore))}
    </pre>`);
          },
          $$slots: { title: true, default: true }
        });
      }
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, { restore, scrollToIndex });
  });
}
export {
  VirtualList as V
};
//# sourceMappingURL=VirtualList.js.map
