import { u as unsubscribe_stores, s as store_get, e as escape_html, a as attr_class, k as stringify, d as ensure_array_like, x as store_set, c as clsx, b as attr, g as await_block, y as store_mutate, l as spread_props, j as attr_style, h as head } from "./index3.js";
import { p as page } from "./index4.js";
import { B as Button, M as Material, t as toast, ab as toastColors, y as Spinner, i as Markdown, ac as toasts, L as LINKED_INSTANCE_URL, p as profile, s as site, h as Avatar, ad as Logo, F as DEFAULT_CLIENT_TYPE, b as Badge, g as goto, E as Expandable, m as communityLink } from "./client.svelte.js";
import { t } from "./index.js";
import { s as settings } from "./settings.svelte.js";
import { t as theme, r as rgbToHex, i as inDarkColorScheme, g as getDefaultColors } from "./theme.svelte.js";
import { I as InstanceCard } from "./InstanceCard.js";
import { m as modals } from "./moderation.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { S as Share } from "./Share.js";
import { X as XMark } from "./XMark.js";
import { I as Icon } from "./Icon.js";
import { M as Modal } from "./Modal.js";
import { s as shownModal } from "./modal2.js";
import "clsx";
import { C as Check } from "./Check.js";
import { C as CheckCircle } from "./CheckCircle.js";
import { E as ExclamationTriangle } from "./ExclamationTriangle.js";
import { I as InformationCircle } from "./InformationCircle.js";
import "openapi-fetch";
import "@dicebear/core";
import "@dicebear/initials";
import { B as Bars3 } from "./Bars3.js";
import { G as GlobeAlt } from "./GlobeAlt.js";
import { M as MagnifyingGlass } from "./MagnifyingGlass.js";
import { P as PencilSquare } from "./PencilSquare.js";
import { S as ServerStack } from "./ServerStack.js";
import { S as ShieldCheck } from "./ShieldCheck.js";
import { M as Menu, a as MenuButton } from "./MenuButton.js";
import { T as TextLoader } from "./TextLoader.js";
import { p as public_env } from "./shared-server.js";
import { C as ChevronUpDown, S as Select, O as Option } from "./Select.js";
import { Q as QuestionMarkCircle } from "./QuestionMarkCircle.js";
import { A as ArrowLeftOnRectangle } from "./ArrowLeftOnRectangle.js";
import { B as Bookmark } from "./Bookmark.js";
import { C as Cog6Tooth } from "./Cog6Tooth.js";
import { C as ComputerDesktop } from "./ComputerDesktop.js";
import { I as Identification } from "./Identification.js";
import { I as Inbox } from "./Inbox.js";
import { S as Sun } from "./Sun.js";
import { U as UserCircle } from "./UserCircle.js";
import { I as ItemList } from "./ItemList.js";
import { E as EndPlaceholder } from "./EndPlaceholder.js";
import { S as SidebarButton } from "./SidebarButton.js";
import nProgress from "nprogress";
const ExclamationCircle = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14ZM8 4a.75.75 0 0 1 .75.75v3a.75.75 0 0 1-1.5 0v-3A.75.75 0 0 1 8 4Zm0 8a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0Zm-8-5a.75.75 0 0 1 .75.75v4.5a.75.75 0 0 1-1.5 0v-4.5A.75.75 0 0 1 10 5Zm0 10a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M12 9v3.75m9-.75a9 9 0 1 1-18 0 9 9 0 0 1 18 0Zm-9 3.75h.008v.008H12v-.008Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12ZM12 8.25a.75.75 0 0 1 .75.75v3.75a.75.75 0 0 1-1.5 0V9a.75.75 0 0 1 .75-.75Zm0 8.25a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const Forward = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M2.53 3.956A1 1 0 0 0 1 4.804v6.392a1 1 0 0 0 1.53.848l5.113-3.196c.16-.1.279-.233.357-.383v2.73a1 1 0 0 0 1.53.849l5.113-3.196a1 1 0 0 0 0-1.696L9.53 3.956A1 1 0 0 0 8 4.804v2.731a.992.992 0 0 0-.357-.383L2.53 3.956Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M3.288 4.818A1.5 1.5 0 0 0 1 6.095v7.81a1.5 1.5 0 0 0 2.288 1.276l6.323-3.905c.155-.096.285-.213.389-.344v2.973a1.5 1.5 0 0 0 2.288 1.276l6.323-3.905a1.5 1.5 0 0 0 0-2.552l-6.323-3.906A1.5 1.5 0 0 0 10 6.095v2.972a1.506 1.506 0 0 0-.389-.343L3.288 4.818Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M3 8.689c0-.864.933-1.406 1.683-.977l7.108 4.061a1.125 1.125 0 0 1 0 1.954l-7.108 4.061A1.125 1.125 0 0 1 3 16.811V8.69ZM12.75 8.689c0-.864.933-1.406 1.683-.977l7.108 4.061a1.125 1.125 0 0 1 0 1.954l-7.108 4.061a1.125 1.125 0 0 1-1.683-.977V8.69Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M5.055 7.06C3.805 6.347 2.25 7.25 2.25 8.69v8.122c0 1.44 1.555 2.343 2.805 1.628L12 14.471v2.34c0 1.44 1.555 2.343 2.805 1.628l7.108-4.061c1.26-.72 1.26-2.536 0-3.256l-7.108-4.061C13.555 6.346 12 7.249 12 8.689v2.34L5.055 7.061Z"
      }
    ]
  }
};
const Home = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M8.543 2.232a.75.75 0 0 0-1.085 0l-5.25 5.5A.75.75 0 0 0 2.75 9H4v4a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1v-1a1 1 0 1 1 2 0v1a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1V9h1.25a.75.75 0 0 0 .543-1.268l-5.25-5.5Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M9.293 2.293a1 1 0 0 1 1.414 0l7 7A1 1 0 0 1 17 11h-1v6a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1v-3a1 1 0 0 0-1-1H9a1 1 0 0 0-1 1v3a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-6H3a1 1 0 0 1-.707-1.707l7-7Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "m2.25 12 8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M11.47 3.841a.75.75 0 0 1 1.06 0l8.69 8.69a.75.75 0 1 0 1.06-1.061l-8.689-8.69a2.25 2.25 0 0 0-3.182 0l-8.69 8.69a.75.75 0 1 0 1.061 1.06l8.69-8.689Z"
      },
      {
        "d": "m12 5.432 8.159 8.159c.03.03.06.058.091.086v6.198c0 1.035-.84 1.875-1.875 1.875H15a.75.75 0 0 1-.75-.75v-4.5a.75.75 0 0 0-.75-.75h-3a.75.75 0 0 0-.75.75V21a.75.75 0 0 1-.75.75H5.625a1.875 1.875 0 0 1-1.875-1.875v-6.198a2.29 2.29 0 0 0 .091-.086L12 5.432Z"
      }
    ]
  }
};
const Moon = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M14.438 10.148c.19-.425-.321-.787-.748-.601A5.5 5.5 0 0 1 6.453 2.31c.186-.427-.176-.938-.6-.748a6.501 6.501 0 1 0 8.585 8.586Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M7.455 2.004a.75.75 0 0 1 .26.77 7 7 0 0 0 9.958 7.967.75.75 0 0 1 1.067.853A8.5 8.5 0 1 1 6.647 1.921a.75.75 0 0 1 .808.083Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M21.752 15.002A9.72 9.72 0 0 1 18 15.75c-5.385 0-9.75-4.365-9.75-9.75 0-1.33.266-2.597.748-3.752A9.753 9.753 0 0 0 3 11.25C3 16.635 7.365 21 12.75 21a9.753 9.753 0 0 0 9.002-5.998Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M9.528 1.718a.75.75 0 0 1 .162.819A8.97 8.97 0 0 0 9 6a9 9 0 0 0 9 9 8.97 8.97 0 0 0 3.463-.69.75.75 0 0 1 .981.98 10.503 10.503 0 0 1-9.694 6.46c-5.799 0-10.5-4.7-10.5-10.5 0-4.368 2.667-8.112 6.46-9.694a.75.75 0 0 1 .818.162Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const Swatch = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2 3a1 1 0 0 1 1-1h3a1 1 0 0 1 1 1v8.5a2.5 2.5 0 0 1-5 0V3Zm3.25 8.5a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Z",
        "clip-rule": "evenodd"
      },
      {
        "d": "m8.5 11.035 3.778-3.778a1 1 0 0 0 0-1.414l-2.122-2.121a1 1 0 0 0-1.414 0l-.242.242v7.07ZM7.656 14H13a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1h-.344l-5 5Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M3.5 2A1.5 1.5 0 0 0 2 3.5V15a3 3 0 1 0 6 0V3.5A1.5 1.5 0 0 0 6.5 2h-3Zm11.753 6.99L9.5 14.743V6.257l1.51-1.51a1.5 1.5 0 0 1 2.122 0l2.121 2.121a1.5 1.5 0 0 1 0 2.122ZM8.364 18H16.5a1.5 1.5 0 0 0 1.5-1.5v-3a1.5 1.5 0 0 0-1.5-1.5h-2.136l-6 6ZM5 16a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M4.098 19.902a3.75 3.75 0 0 0 5.304 0l6.401-6.402M6.75 21A3.75 3.75 0 0 1 3 17.25V4.125C3 3.504 3.504 3 4.125 3h5.25c.621 0 1.125.504 1.125 1.125v4.072M6.75 21a3.75 3.75 0 0 0 3.75-3.75V8.197M6.75 21h13.125c.621 0 1.125-.504 1.125-1.125v-5.25c0-.621-.504-1.125-1.125-1.125h-4.072M10.5 8.197l2.88-2.88c.438-.439 1.15-.439 1.59 0l3.712 3.713c.44.44.44 1.152 0 1.59l-2.879 2.88M6.75 17.25h.008v.008H6.75v-.008Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2.25 4.125c0-1.036.84-1.875 1.875-1.875h5.25c1.036 0 1.875.84 1.875 1.875V17.25a4.5 4.5 0 1 1-9 0V4.125Zm4.5 14.25a1.125 1.125 0 1 0 0-2.25 1.125 1.125 0 0 0 0 2.25Z",
        "clip-rule": "evenodd"
      },
      {
        "d": "M10.719 21.75h9.156c1.036 0 1.875-.84 1.875-1.875v-5.25c0-1.036-.84-1.875-1.875-1.875h-.14l-8.742 8.743c-.09.089-.18.175-.274.257ZM12.738 17.625l6.474-6.474a1.875 1.875 0 0 0 0-2.651L15.5 4.787a1.875 1.875 0 0 0-2.651 0l-.1.099V17.25c0 .126-.003.251-.01.375Z"
      }
    ]
  }
};
const UserGroup = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M8 8a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5ZM3.156 11.763c.16-.629.44-1.21.813-1.72a2.5 2.5 0 0 0-2.725 1.377c-.136.287.102.58.418.58h1.449c.01-.077.025-.156.045-.237ZM12.847 11.763c.02.08.036.16.046.237h1.446c.316 0 .554-.293.417-.579a2.5 2.5 0 0 0-2.722-1.378c.374.51.653 1.09.813 1.72ZM14 7.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0ZM3.5 9a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3ZM5 13c-.552 0-1.013-.455-.876-.99a4.002 4.002 0 0 1 7.753 0c.136.535-.324.99-.877.99H5Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M10 9a3 3 0 1 0 0-6 3 3 0 0 0 0 6ZM6 8a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM1.49 15.326a.78.78 0 0 1-.358-.442 3 3 0 0 1 4.308-3.516 6.484 6.484 0 0 0-1.905 3.959c-.023.222-.014.442.025.654a4.97 4.97 0 0 1-2.07-.655ZM16.44 15.98a4.97 4.97 0 0 0 2.07-.654.78.78 0 0 0 .357-.442 3 3 0 0 0-4.308-3.517 6.484 6.484 0 0 1 1.907 3.96 2.32 2.32 0 0 1-.026.654ZM18 8a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM5.304 16.19a.844.844 0 0 1-.277-.71 5 5 0 0 1 9.947 0 .843.843 0 0 1-.277.71A6.975 6.975 0 0 1 10 18a6.974 6.974 0 0 1-4.696-1.81Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M18 18.72a9.094 9.094 0 0 0 3.741-.479 3 3 0 0 0-4.682-2.72m.94 3.198.001.031c0 .225-.012.447-.037.666A11.944 11.944 0 0 1 12 21c-2.17 0-4.207-.576-5.963-1.584A6.062 6.062 0 0 1 6 18.719m12 0a5.971 5.971 0 0 0-.941-3.197m0 0A5.995 5.995 0 0 0 12 12.75a5.995 5.995 0 0 0-5.058 2.772m0 0a3 3 0 0 0-4.681 2.72 8.986 8.986 0 0 0 3.74.477m.94-3.197a5.971 5.971 0 0 0-.94 3.197M15 6.75a3 3 0 1 1-6 0 3 3 0 0 1 6 0Zm6 3a2.25 2.25 0 1 1-4.5 0 2.25 2.25 0 0 1 4.5 0Zm-13.5 0a2.25 2.25 0 1 1-4.5 0 2.25 2.25 0 0 1 4.5 0Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M8.25 6.75a3.75 3.75 0 1 1 7.5 0 3.75 3.75 0 0 1-7.5 0ZM15.75 9.75a3 3 0 1 1 6 0 3 3 0 0 1-6 0ZM2.25 9.75a3 3 0 1 1 6 0 3 3 0 0 1-6 0ZM6.31 15.117A6.745 6.745 0 0 1 12 12a6.745 6.745 0 0 1 6.709 7.498.75.75 0 0 1-.372.568A12.696 12.696 0 0 1 12 21.75c-2.305 0-4.47-.612-6.337-1.684a.75.75 0 0 1-.372-.568 6.787 6.787 0 0 1 1.019-4.38Z",
        "clip-rule": "evenodd"
      },
      {
        "d": "M5.082 14.254a8.287 8.287 0 0 0-1.308 5.135 9.687 9.687 0 0 1-1.764-.44l-.115-.04a.563.563 0 0 1-.373-.487l-.01-.121a3.75 3.75 0 0 1 3.57-4.047ZM20.226 19.389a8.287 8.287 0 0 0-1.308-5.135 3.75 3.75 0 0 1 3.57 4.047l-.01.121a.563.563 0 0 1-.373.486l-.115.04c-.567.2-1.156.349-1.764.441Z"
      }
    ]
  }
};
function ModalContainer($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (store_get($$store_subs ??= {}, "$shownModal", shownModal)) {
        $$renderer3.push("<!--[-->");
        Modal($$renderer3, {
          title: store_get($$store_subs ??= {}, "$shownModal", shownModal).title,
          dismissable: store_get($$store_subs ??= {}, "$shownModal", shownModal).dismissable,
          ondismissed: () => shownModal.set(void 0),
          get open() {
            return store_get($$store_subs ??= {}, "$shownModal", shownModal);
          },
          set open($$value) {
            store_set(shownModal, $$value);
            $$settled = false;
          },
          children: ($$renderer4) => {
            if (store_get($$store_subs ??= {}, "$shownModal", shownModal).snippet) {
              $$renderer4.push("<!--[-->");
              store_get($$store_subs ??= {}, "$shownModal", shownModal).snippet?.($$renderer4);
              $$renderer4.push(`<!---->`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]--> `);
            if (store_get($$store_subs ??= {}, "$shownModal", shownModal).body) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<p>${escape_html(store_get($$store_subs ??= {}, "$shownModal", shownModal).body)}</p>`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]--> `);
            if (store_get($$store_subs ??= {}, "$shownModal", shownModal).actions) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div${attr_class(`flex items-center gap-2 ${stringify(store_get($$store_subs ??= {}, "$shownModal", shownModal).actions.length >= 3 ? "flex-col" : "flex-row")}`)}><!--[-->`);
              const each_array = ensure_array_like(store_get($$store_subs ??= {}, "$shownModal", shownModal).actions);
              for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                let action = each_array[$$index];
                Button($$renderer4, {
                  size: "lg",
                  class: "flex-1 w-full",
                  onclick: action.action,
                  color: action.type,
                  children: ($$renderer5) => {
                    if (action.icon) {
                      $$renderer5.push("<!--[-->");
                      Icon($$renderer5, { src: action.icon, mini: true, size: "16" });
                    } else {
                      $$renderer5.push("<!--[!-->");
                    }
                    $$renderer5.push(`<!--]--> ${escape_html(action.content)}`);
                  },
                  $$slots: { default: true }
                });
              }
              $$renderer4.push(`<!--]--></div>`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function InvertedCorner($$renderer, $$props) {
  let { class: clazz } = $$props;
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 24 24" aria-hidden="true"${attr_class(clsx(clazz))}><path d="M0 0h64v64H0V0z M0 24a24 24 0 0 1 24-24v24H0z" fill="currentColor" fill-rule="evenodd"></path></svg>`);
}
function Shell($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { children, navbar, sidebar, main, suffix } = $$props;
    children?.($$renderer2);
    $$renderer2.push(`<!----> <div class="min-h-screen flex flex-col"><div${attr_class(clsx(["shell-navbar-holder", false]), "svelte-1boiwdb")} aria-hidden="true"><div class="md:hidden flex justify-between" dir="ltr">`);
    InvertedCorner($$renderer2, { class: "w-8 h-8 text-slate-50 dark:text-zinc-950 rotate-270" });
    $$renderer2.push(`<!----> `);
    InvertedCorner($$renderer2, { class: "w-8 h-8 text-slate-50 dark:text-zinc-950 rotate-180" });
    $$renderer2.push(`<!----></div> `);
    navbar?.($$renderer2, { class: ["shell-navbar"] });
    $$renderer2.push(`<!----></div> <div${attr_class(clsx(["shell-content flex-1", settings.newWidth && "limit-width"]), "svelte-1boiwdb")}>`);
    sidebar?.($$renderer2, { class: `shell-aside shell-sidebar` });
    $$renderer2.push(`<!----> `);
    main?.($$renderer2, { class: `shell-main` });
    $$renderer2.push(`<!----> `);
    suffix?.($$renderer2, { class: `shell-aside shell-suffix` });
    $$renderer2.push(`<!----></div></div>`);
  });
}
function ExpandableImage($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { alt = "" } = $$props;
    if (page.state.openImage || false) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="fixed top-0 left-0 w-screen h-svh overflow-auto bg-white/50 dark:bg-black/50 flex flex-col z-100 backdrop-blur-xs"><img${attr("width", 800)}${attr("height", 800)}${attr("src", page.state.openImage)}${attr_class(clsx([
        "max-w-full mx-auto my-auto overscroll-contain bg-white dark:bg-zinc-900"
      ]))}${attr("alt", alt)}/> <div class="sticky z-10 bottom-4 left-1/2 -translate-x-1/2 w-max">`);
      Material($$renderer2, {
        class: "gap-1 p-0.5 px-1 flex flex-row items-center",
        rounding: "full",
        padding: "none",
        color: "uniform",
        onclick: (e) => e.stopPropagation(),
        children: ($$renderer3) => {
          Button($$renderer3, {
            onclick: () => {
              navigator.clipboard.writeText(page.state?.openImage ?? "");
              toast({
                content: store_get($$store_subs ??= {}, "$t", t)("toast.copied")
              });
            },
            color: "tertiary",
            size: "square-lg",
            rounding: "pill",
            "aria-label": store_get($$store_subs ??= {}, "$t", t)("post.actions.more.share"),
            icon: Share
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            onclick: () => history.back(),
            color: "tertiary",
            size: "square-lg",
            rounding: "pill",
            "aria-label": store_get($$store_subs ??= {}, "$t", t)("common.back"),
            icon: XMark
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function Toast($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { toast: toast2 } = $$props;
    $$renderer2.push(`<div${attr_class(clsx([
      toastColors[toast2.type],
      "relative rounded-2xl overflow-hidden flex flex-row items-center gap-1 px-2 py-2 backdrop-blur-3xl",
      "bg-white dark:bg-zinc-925 shadow-lg",
      toast2.long ? "w-full max-w-lg" : "w-80"
    ]))}>`);
    if (toast2.loading) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="relative m-2 ml-4 shrink-0">`);
      Spinner($$renderer2, { width: 20 });
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
      Icon($$renderer2, {
        size: "28",
        mini: true,
        class: ["relative self-center shrink-0 p-1 rounded-lg"],
        src: toast2.type == "info" ? InformationCircle : toast2.type == "success" ? CheckCircle : toast2.type == "warning" ? ExclamationTriangle : toast2.type == "error" ? ExclamationCircle : ExclamationCircle
      });
    }
    $$renderer2.push(`<!--]--> <div class="flex flex-col break-words max-w-full text-inherit">`);
    if (toast2.title) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<h1 class="text-base font-semibold">${escape_html(toast2.title)}</h1>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    Markdown($$renderer2, {
      source: toast2.content,
      class: toast2.long ? "text-[15px]" : "text-sm font-medium"
    });
    $$renderer2.push(`<!----></div> <div class="absolute top-0 right-0 flex items-center gap-1 m-1">`);
    if (toast2.action) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<button class="rounded-lg w-max transition-colors hover:bg-slate-100 dark:hover:bg-zinc-800 p-1 cursor-pointer">`);
      Icon($$renderer2, { src: Check, size: "20", micro: true });
      $$renderer2.push(`<!----></button>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <button class="rounded-lg w-max transition-colors hover:bg-slate-100 dark:hover:bg-zinc-800 p-1 cursor-pointer text-slate-600 dark:text-zinc-400">`);
    Icon($$renderer2, { src: XMark, size: "16", micro: true });
    $$renderer2.push(`<!----></button></div></div>`);
  });
}
function ToastContainer($$renderer) {
  var $$store_subs;
  $$renderer.push(`<div class="fixed right-0 bottom-0 flex flex-col items-end justify-end z-200 p-4 group overflow-hidden h-screen min-w-96 pointer-events-none gap-4"><!--[-->`);
  const each_array = ensure_array_like(store_get($$store_subs ??= {}, "$toasts", toasts));
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let toast2 = each_array[$$index];
    $$renderer.push(`<div class="pointer-events-auto transition-all duration-300">`);
    Toast($$renderer, { toast: toast2 });
    $$renderer.push(`<!----></div>`);
  }
  $$renderer.push(`<!--]--></div>`);
  if ($$store_subs) unsubscribe_stores($$store_subs);
}
function Moderation($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (store_get($$store_subs ??= {}, "$modals", modals).reporting.open) {
        $$renderer3.push("<!--[-->");
        await_block($$renderer3, import("./ReportModal.js"), () => {
        }, ({ default: ReportModal }) => {
          ReportModal($$renderer3, {
            get open() {
              return store_get($$store_subs ??= {}, "$modals", modals).reporting.open;
            },
            set open($$value) {
              store_mutate($$store_subs ??= {}, "$modals", modals, store_get($$store_subs ??= {}, "$modals", modals).reporting.open = $$value);
              $$settled = false;
            },
            get item() {
              return store_get($$store_subs ??= {}, "$modals", modals).reporting.item;
            },
            set item($$value) {
              store_mutate($$store_subs ??= {}, "$modals", modals, store_get($$store_subs ??= {}, "$modals", modals).reporting.item = $$value);
              $$settled = false;
            }
          });
        });
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (store_get($$store_subs ??= {}, "$modals", modals).removing.open) {
        $$renderer3.push("<!--[-->");
        await_block($$renderer3, import("./RemoveModal.js"), () => {
        }, ({ default: RemoveModal }) => {
          RemoveModal($$renderer3, {
            item: store_get($$store_subs ??= {}, "$modals", modals).removing.item,
            purge: store_get($$store_subs ??= {}, "$modals", modals).removing.purge,
            get open() {
              return store_get($$store_subs ??= {}, "$modals", modals).removing.open;
            },
            set open($$value) {
              store_mutate($$store_subs ??= {}, "$modals", modals, store_get($$store_subs ??= {}, "$modals", modals).removing.open = $$value);
              $$settled = false;
            }
          });
        });
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (store_get($$store_subs ??= {}, "$modals", modals).banning.open) {
        $$renderer3.push("<!--[-->");
        await_block($$renderer3, import("./BanModal.js"), () => {
        }, ({ default: BanModal }) => {
          BanModal($$renderer3, {
            banned: store_get($$store_subs ??= {}, "$modals", modals).banning.banned,
            user: store_get($$store_subs ??= {}, "$modals", modals).banning.user,
            community: store_get($$store_subs ??= {}, "$modals", modals).banning.community,
            get open() {
              return store_get($$store_subs ??= {}, "$modals", modals).banning.open;
            },
            set open($$value) {
              store_mutate($$store_subs ??= {}, "$modals", modals, store_get($$store_subs ??= {}, "$modals", modals).banning.open = $$value);
              $$settled = false;
            }
          });
        });
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (store_get($$store_subs ??= {}, "$modals", modals).votes.open) {
        $$renderer3.push("<!--[-->");
        await_block($$renderer3, import("./ViewVotesModal.js"), () => {
        }, ({ default: VotesModal }) => {
          VotesModal($$renderer3, {
            item: store_get($$store_subs ??= {}, "$modals", modals).votes.item,
            get open() {
              return store_get($$store_subs ??= {}, "$modals", modals).votes.open;
            },
            set open($$value) {
              store_mutate($$store_subs ??= {}, "$modals", modals, store_get($$store_subs ??= {}, "$modals", modals).votes.open = $$value);
              $$settled = false;
            }
          });
        });
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
let chords = { commands: false };
function CommandsHost($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (chords.commands) {
        $$renderer3.push("<!--[-->");
        Modal($$renderer3, {
          title: null,
          class: "p-0! gap-0!",
          get open() {
            return chords.commands;
          },
          set open($$value) {
            chords.commands = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            await_block(
              $$renderer4,
              import("./Commands.js"),
              () => {
                $$renderer4.push(`<div class="h-128 flex flex-col gap-2 items-center justify-center">`);
                TextLoader($$renderer4, {
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.commands.downloading"))}`);
                  }
                });
                $$renderer4.push(`<!----></div>`);
              },
              ({ default: Commands }) => {
                $$renderer4.push(`<!---->`);
                Commands($$renderer4, {
                  get open() {
                    return chords.commands;
                  },
                  set open($$value) {
                    chords.commands = $$value;
                    $$settled = false;
                  }
                });
                $$renderer4.push(`<!---->`);
              }
            );
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function NavButton($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      label,
      icon,
      href,
      adaptive = true,
      isSelectedFilter = (path) => href != void 0 && path == href,
      class: clazz = "",
      customIcon,
      children,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    let isSelected = isSelectedFilter(page.url.pathname);
    {
      let prefix = function($$renderer3) {
        $$renderer3.push(`<div class="prefix">`);
        if (customIcon) {
          $$renderer3.push("<!--[-->");
          customIcon?.($$renderer3, { size: 16, isSelected });
          $$renderer3.push(`<!---->`);
        } else {
          $$renderer3.push("<!--[!-->");
          if (icon) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="hidden md:block">`);
            Icon($$renderer3, { src: icon, size: "16", micro: true });
            $$renderer3.push(`<!----></div> <div class="block md:hidden">`);
            Icon($$renderer3, { src: icon, size: "20", mini: true });
            $$renderer3.push(`<!----></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        }
        $$renderer3.push(`<!--]--></div>`);
      };
      Button($$renderer2, spread_props([
        rest,
        {
          color: "none",
          rounding: "none",
          class: [
            "nav-btn",
            adaptive && "nav-btn-dynamic",
            isSelected && "nav-btn-selected",
            clazz
          ],
          shadow: "none",
          size: "custom",
          href,
          title: label,
          "aria-selected": isSelected,
          prefix,
          children: ($$renderer3) => {
            $$renderer3.push(`<span${attr_class(`hidden ${stringify(adaptive ? "md:block" : "")}`)}>${escape_html(label)}</span> `);
            children?.($$renderer3);
            $$renderer3.push(`<!---->`);
          },
          $$slots: { prefix: true, default: true }
        }
      ]));
    }
  });
}
function Navbar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { style = "", class: clazz = "" } = $$props;
    CommandsHost($$renderer2);
    $$renderer2.push(`<!----> <nav${attr_class(clsx(["navbar @container", clazz]), "svelte-hvaosf")}${attr_style(style)} data-sveltekit-preload-data="">`);
    {
      let customIcon = function($$renderer3) {
        if (LINKED_INSTANCE_URL) {
          $$renderer3.push("<!--[-->");
          if (site.data) {
            $$renderer3.push("<!--[-->");
            Avatar($$renderer3, {
              alt: site.data.site_view.site.name,
              url: site.data.site_view.site.icon,
              width: 32,
              circle: false
            });
          } else {
            $$renderer3.push("<!--[!-->");
            Spinner($$renderer3, { width: 32 });
          }
          $$renderer3.push(`<!--]-->`);
        } else {
          $$renderer3.push("<!--[!-->");
          $$renderer3.push(`<div class="hidden md:block text-primary-900! dark:text-primary-100!">`);
          Logo($$renderer3, { width: 32 });
          $$renderer3.push(`<!----></div> <div${attr_class(clsx(["block md:hidden text-inherit!"]))}><div class="prefix">`);
          Icon($$renderer3, { src: Home, size: "20", mini: true });
          $$renderer3.push(`<!----></div></div>`);
        }
        $$renderer3.push(`<!--]-->`);
      };
      NavButton($$renderer2, {
        oncontextmenu: (e) => {
          e.preventDefault();
          chords.commands = true;
          return true;
        },
        icon: Home,
        href: "/",
        label: store_get($$store_subs ??= {}, "$t", t)("nav.home"),
        class: [
          "logo border-0 md:w-10! md:h-10 md:px-0! -order-1",
          !LINKED_INSTANCE_URL ? "md:rounded-full!" : "rounded-none!"
        ],
        adaptive: false,
        customIcon,
        $$slots: { customIcon: true }
      });
    }
    $$renderer2.push(`<!----> <div class="hidden md:block md:flex-1"></div> <div class="sr-only md:not-sr-only md:contents">`);
    if (profile.isAdmin) {
      $$renderer2.push("<!--[-->");
      NavButton($$renderer2, {
        href: "/admin",
        label: store_get($$store_subs ??= {}, "$t", t)("nav.admin"),
        icon: ServerStack,
        class: "relative order-0",
        isSelectedFilter: (path) => path.startsWith("/admin")
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (profile.isMod()) {
      $$renderer2.push("<!--[-->");
      NavButton($$renderer2, {
        href: "/moderation",
        label: store_get($$store_subs ??= {}, "$t", t)("nav.moderation"),
        class: "relative order-0",
        icon: ShieldCheck
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div> `);
    NavButton($$renderer2, {
      href: "/explore/communities",
      label: store_get($$store_subs ??= {}, "$t", t)("routes.explore.title"),
      icon: GlobeAlt,
      isSelectedFilter: (path) => path.startsWith("/explore"),
      class: "order-1"
    });
    $$renderer2.push(`<!----> `);
    NavButton($$renderer2, {
      href: "/search",
      label: store_get($$store_subs ??= {}, "$t", t)("nav.search"),
      icon: MagnifyingGlass,
      class: "order-3 md:order-2"
    });
    $$renderer2.push(`<!----> `);
    NavButton($$renderer2, {
      label: store_get($$store_subs ??= {}, "$t", t)("nav.create.label"),
      href: "/create",
      isSelectedFilter: (path) => path.startsWith("/create"),
      icon: PencilSquare,
      class: "order-2 md:order-3 nav-btn-sm-primary"
    });
    $$renderer2.push(`<!----> `);
    {
      let target = function($$renderer3, attachment) {
        $$renderer3.push(`<button${attr_class(
          clsx([
            "w-10 h-10 rounded-full",
            "transition-all relative grid place-items-center",
            " group cursor-pointer order-4"
          ]),
          "svelte-hvaosf"
        )}${attr("title", store_get($$store_subs ??= {}, "$t", t)("profile.profile"))}>`);
        if (profile.current?.user) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div${attr_class(clsx([
            "h-full aspect-square object-cover rounded-full grid place-items-center",
            "border-slate-200 dark:border-zinc-700 hover:bg-slate-200 dark:hover:bg-zinc-700 bg-slate-50 dark:bg-zinc-900"
          ]))}>`);
          Avatar($$renderer3, {
            url: profile.current.user.local_user_view.person.avatar,
            width: 36,
            alt: profile.current.user.local_user_view.person.name,
            class: "group-hover:scale-90 transition-transform group-active:scale-85"
          });
          $$renderer3.push(`<!----></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
          $$renderer3.push(`<div class="w-full h-full grid place-items-center">`);
          Icon($$renderer3, { src: Bars3, micro: true, size: "18" });
          $$renderer3.push(`<!----></div>`);
        }
        $$renderer3.push(`<!--]--> `);
        if (Math.max(...Object.values(profile.inbox.notifications)) > 0) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="w-2 h-2 absolute top-0.5 right-0.5 bg-red-500 rounded-full"></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></button>`);
      }, children = function($$renderer3, open) {
        if (open) {
          $$renderer3.push("<!--[-->");
          await_block(
            $$renderer3,
            import("./Profile.js"),
            () => {
              $$renderer3.push(`<div class="p-8 w-full h-full grid place-items-center">`);
              Spinner($$renderer3, { width: 20 });
              $$renderer3.push(`<!----></div>`);
            },
            ({ default: Profile }) => {
              $$renderer3.push(`<!---->`);
              Profile($$renderer3, {});
              $$renderer3.push(`<!---->`);
            }
          );
          $$renderer3.push(`<!--]-->`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      };
      Menu($$renderer2, {
        placement: "bottom",
        target,
        children,
        $$slots: { target: true, default: true }
      });
    }
    $$renderer2.push(`<!----></nav>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function ProfileSelection($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { profiles, selectable = true } = $$props;
    function switchTo(id) {
      profile.meta.profile = id;
      goto(page.url, {});
    }
    {
      let target = function($$renderer3, passedAttachment) {
        {
          let prefix = function($$renderer4) {
            Avatar($$renderer4, {
              url: profile.current.avatar,
              alt: profile.current.username,
              width: 24
            });
          }, suffix = function($$renderer4) {
            if (selectable) {
              $$renderer4.push("<!--[-->");
              Icon($$renderer4, {
                src: ChevronUpDown,
                size: "16",
                micro: true,
                class: "block justify-self-end"
              });
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]-->`);
          };
          Button($$renderer3, {
            color: "tertiary",
            alignment: "left",
            size: "md",
            rounding: "xl",
            class: "flex flex-row gap-2! items-center",
            "aria-label": store_get($$store_subs ??= {}, "$t", t)("aria.sidebar.accounts"),
            prefix,
            suffix,
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="flex-1"><div class="font-medium">${escape_html(profile.current.username)}</div> `);
              if (!LINKED_INSTANCE_URL) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<div class="text-xs text-slate-500 dark:text-zinc-500"><span class="capitalize">${escape_html(profile.current.client?.name ?? DEFAULT_CLIENT_TYPE.name)}</span> • ${escape_html(profile.current.instance)}</div>`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--></div>`);
            },
            $$slots: { prefix: true, suffix: true, default: true }
          });
        }
      };
      Menu($$renderer2, {
        placement: "bottom",
        target,
        children: ($$renderer3) => {
          $$renderer3.push(`<!--[-->`);
          const each_array = ensure_array_like(profiles);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let p = each_array[$$index];
            const selected = profile.meta.profile == p.id;
            {
              let prefix = function($$renderer4) {
                Avatar($$renderer4, { url: p.avatar, alt: p.username, width: 24 });
              };
              MenuButton($$renderer3, {
                onclick: () => switchTo(p.id),
                class: [selected && "bg-slate-100! dark:bg-zinc-800!", "gap-2!"],
                prefix,
                children: ($$renderer4) => {
                  $$renderer4.push(`<div><div class="font-medium text-sm">${escape_html(p.username)}</div> `);
                  if (!LINKED_INSTANCE_URL) {
                    $$renderer4.push("<!--[-->");
                    $$renderer4.push(`<div class="text-xs text-slate-500 dark:text-zinc-500"><span class="capitalize">${escape_html(p.client?.name ?? DEFAULT_CLIENT_TYPE.name)}</span> • ${escape_html(p.instance)}</div>`);
                  } else {
                    $$renderer4.push("<!--[!-->");
                  }
                  $$renderer4.push(`<!--]--></div> <div class="flex-1"></div> `);
                  if (!p.jwt) {
                    $$renderer4.push("<!--[-->");
                    Badge($$renderer4, {
                      color: "gray-subtle",
                      class: "p-1!",
                      children: ($$renderer5) => {
                        Icon($$renderer5, { src: QuestionMarkCircle, size: "16", micro: true });
                      },
                      $$slots: { default: true }
                    });
                  } else {
                    $$renderer4.push("<!--[!-->");
                  }
                  $$renderer4.push(`<!--]--> `);
                  if (selected) {
                    $$renderer4.push("<!--[-->");
                    Icon($$renderer4, {
                      src: CheckCircle,
                      class: "text-primary-900 dark:text-primary-100",
                      size: "16",
                      micro: true
                    });
                  } else {
                    $$renderer4.push("<!--[!-->");
                  }
                  $$renderer4.push(`<!--]-->`);
                },
                $$slots: { prefix: true, default: true }
              });
            }
          }
          $$renderer3.push(`<!--]--> `);
          MenuButton($$renderer3, {
            href: "/accounts",
            icon: UserGroup,
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.accounts"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { target: true, default: true }
      });
    }
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function Sidebar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { style = "", class: clazz = "" } = $$props;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<nav${attr("aria-label", store_get($$store_subs ??= {}, "$t", t)("aria.sidebar.title"))}${attr_class(clsx(["flex flex-col overflow-auto gap-1", clazz]))}${attr_style(style)}>`);
      ProfileSelection($$renderer3, {
        selectable: !(LINKED_INSTANCE_URL && !profile.current.jwt && profile.meta.profiles.length == 1),
        profiles: profile.meta.profiles
      });
      $$renderer3.push(`<!----> `);
      EndPlaceholder($$renderer3, {
        margin: "sm",
        size: "xs",
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("profile.profile"))}`);
        }
      });
      $$renderer3.push(`<!----> `);
      if (profile.current?.jwt) {
        $$renderer3.push("<!--[-->");
        const notifications = profile.inbox.notifications;
        SidebarButton($$renderer3, {
          icon: UserCircle,
          href: "/profile",
          label: store_get($$store_subs ??= {}, "$t", t)("profile.profile")
        });
        $$renderer3.push(`<!----> `);
        SidebarButton($$renderer3, {
          icon: Inbox,
          href: "/inbox",
          label: store_get($$store_subs ??= {}, "$t", t)("profile.inbox"),
          children: ($$renderer4) => {
            if (notifications.inbox > 0) {
              $$renderer4.push("<!--[-->");
              Badge($$renderer4, {
                class: "min-w-5 h-5 p-0! px-0.5 grid place-items-center ml-auto",
                color: "red-subtle",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(notifications.inbox > 99 ? "∞" : notifications.inbox)}`);
                },
                $$slots: { default: true }
              });
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        SidebarButton($$renderer3, {
          icon: Bookmark,
          href: "/saved",
          label: store_get($$store_subs ??= {}, "$t", t)("profile.saved")
        });
        $$renderer3.push(`<!---->`);
      } else {
        $$renderer3.push("<!--[!-->");
        SidebarButton($$renderer3, {
          href: "/login",
          label: store_get($$store_subs ??= {}, "$t", t)("account.login"),
          icon: ArrowLeftOnRectangle
        });
        $$renderer3.push(`<!----> `);
        SidebarButton($$renderer3, {
          href: "/signup",
          label: store_get($$store_subs ??= {}, "$t", t)("account.signup"),
          icon: Identification
        });
        $$renderer3.push(`<!----> `);
        SidebarButton($$renderer3, {
          href: "/accounts",
          label: store_get($$store_subs ??= {}, "$t", t)("account.accounts"),
          icon: UserGroup
        });
        $$renderer3.push(`<!---->`);
      }
      $$renderer3.push(`<!--]--> `);
      EndPlaceholder($$renderer3, {
        margin: "sm",
        size: "xs",
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.app"))}`);
        }
      });
      $$renderer3.push(`<!----> `);
      SidebarButton($$renderer3, {
        href: "/settings",
        label: store_get($$store_subs ??= {}, "$t", t)("nav.menu.settings"),
        icon: Cog6Tooth
      });
      $$renderer3.push(`<!----> `);
      {
        let target = function($$renderer4, attachment) {
          SidebarButton($$renderer4, {
            label: store_get($$store_subs ??= {}, "$t", t)("nav.menu.colorscheme.label"),
            icon: theme.colorScheme == "system" ? ComputerDesktop : theme.colorScheme == "light" ? Sun : Moon,
            class: "w-full relative",
            children: ($$renderer5) => {
              Option($$renderer5, {
                value: "system",
                class: "hidden",
                icon: ComputerDesktop,
                children: ($$renderer6) => {
                  $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.colorscheme.system"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer5.push(`<!----> `);
              Option($$renderer5, {
                value: "light",
                class: "hidden",
                icon: Sun,
                children: ($$renderer6) => {
                  $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.colorscheme.light"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer5.push(`<!----> `);
              Option($$renderer5, {
                value: "dark",
                class: "hidden",
                icon: Moon,
                children: ($$renderer6) => {
                  $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.colorscheme.dark"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer5.push(`<!----> `);
              Icon($$renderer5, {
                micro: true,
                size: "16",
                src: ChevronUpDown,
                class: "ml-auto"
              });
              $$renderer5.push(`<!---->`);
            },
            $$slots: { default: true }
          });
        };
        Select($$renderer3, {
          size: "sm",
          get value() {
            return theme.colorScheme;
          },
          set value($$value) {
            theme.colorScheme = $$value;
            $$settled = false;
          },
          target,
          $$slots: { target: true }
        });
      }
      $$renderer3.push(`<!----> `);
      SidebarButton($$renderer3, {
        href: "/theme",
        label: store_get($$store_subs ??= {}, "$t", t)("nav.menu.theme"),
        icon: Swatch
      });
      $$renderer3.push(`<!----> `);
      if (profile.current?.user) {
        $$renderer3.push("<!--[-->");
        EndPlaceholder($$renderer3, {
          margin: "sm",
          size: "xs",
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.communities"))}`);
          }
        });
        $$renderer3.push(`<!----> <div class="space-y-3">`);
        if (profile.current?.user.moderates.length > 0) {
          $$renderer3.push("<!--[-->");
          {
            let title = function($$renderer4) {
              $$renderer4.push(`<span class="px-2 py-1 w-full">`);
              {
                let action = function($$renderer5) {
                  $$renderer5.push(`<span class="dark:text-white text-black">${escape_html(profile.current.user?.moderates.length)}</span>`);
                };
                EndPlaceholder($$renderer4, {
                  border: false,
                  action,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.profile.moderates"))}`);
                  }
                });
              }
              $$renderer4.push(`<!----></span>`);
            };
            Expandable($$renderer3, {
              class: "px-1.5",
              get open() {
                return settings.expand.moderates;
              },
              set open($$value) {
                settings.expand.moderates = $$value;
                $$settled = false;
              },
              title,
              children: ($$renderer4) => {
                ItemList($$renderer4, {
                  items: profile.current.user.moderates.map((i) => ({
                    id: i.community.id,
                    name: i.community.title,
                    url: communityLink(i.community),
                    avatar: i.community.icon,
                    instance: new URL(i.community.actor_id).hostname
                  }))
                });
              },
              $$slots: { title: true, default: true }
            });
          }
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        {
          let title = function($$renderer4) {
            $$renderer4.push(`<span class="px-2 py-1 w-full">`);
            {
              let action = function($$renderer5) {
                $$renderer5.push(`<span class="dark:text-white text-black">${escape_html(profile.current.user?.follows.length)}</span>`);
              };
              EndPlaceholder($$renderer4, {
                border: false,
                action,
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("profile.subscribed"))}`);
                }
              });
            }
            $$renderer4.push(`<!----></span>`);
          };
          Expandable($$renderer3, {
            class: "px-1.5",
            get open() {
              return settings.expand.communities;
            },
            set open($$value) {
              settings.expand.communities = $$value;
              $$settled = false;
            },
            title,
            children: ($$renderer4) => {
              ItemList($$renderer4, {
                items: profile.current.user.follows.map((i) => ({
                  id: i.community.id,
                  name: i.community.title,
                  url: communityLink(i.community),
                  avatar: i.community.icon,
                  instance: new URL(i.community.actor_id).hostname
                }))
              });
            },
            $$slots: { title: true, default: true }
          });
        }
        $$renderer3.push(`<!----></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <div class="flex-1 h-full mt-auto"></div> <footer class="flex gap-6 flex-col xl:flex-row text-sm text-slate-600 dark:text-zinc-300 flex-wrap"><div class="flex items-center gap-2">`);
      Logo($$renderer3, { width: 16 });
      $$renderer3.push(`<!----> <span class="font-medium">${escape_html("2.2.2")}</span></div> `);
      if (public_env.PUBLIC_XYLIGHT_MODE?.toLowerCase() == "true") {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<a class="text-blue-600 dark:text-blue-400" href="https://github.com/xyphyn/photon">${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.source"))}</a> <a class="text-blue-600 dark:text-blue-400" href="https://buymeacoffee.com/xylight">${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.donate"))}</a>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></footer></nav>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function _layout($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { children } = $$props;
    nProgress.configure({
      minimum: 0.4,
      trickleSpeed: 200,
      easing: "ease-out",
      speed: 300,
      showSpinner: false
    });
    head($$renderer2, ($$renderer3) => {
      if (site.data?.site_view) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<meta name="theme-color"${attr("content", rgbToHex(theme.colorScheme && inDarkColorScheme() ? theme.current.colors.zinc?.[925] ?? getDefaultColors().zinc[925] : theme.current.colors.slate?.[25] ?? getDefaultColors().slate[25]))}/> `);
        if (LINKED_INSTANCE_URL) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<link rel="icon"${attr("href", site.data?.site_view?.site.icon)}/> <meta name="description"${attr("content", site.data?.site_view?.site.description)}/>`);
        } else {
          $$renderer3.push("<!--[!-->");
          $$renderer3.push(`<meta name="description" content="A sleek client for Lemmy"/>`);
        }
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    });
    Button($$renderer2, {
      class: "fixed -top-16 focus:top-0 left-0 m-4 z-300 transition-all",
      href: "#main",
      icon: Forward,
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->Skip Navigation`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    {
      let sidebar = function($$renderer3, { style: s, class: c }) {
        Sidebar($$renderer3, { class: [c, "p-3 sm:p-6 w-full"], style: s });
      }, main = function($$renderer3, { style: s, class: c }) {
        $$renderer3.push(`<main${attr_class(`px-3 pt-3 sm:px-6 sm:pt-6 min-w-0 w-full flex flex-col h-full relative ${stringify(c)}`)}${attr_style(s)} id="main">`);
        children?.($$renderer3);
        $$renderer3.push(`<!----></main>`);
      }, navbar = function($$renderer3, { style: s, class: c }) {
        Navbar($$renderer3, { class: c, style: s });
      }, suffix = function($$renderer3, { class: c }) {
        $$renderer3.push(`<!---->`);
        {
          if (page.data.slots?.sidebar?.component) {
            $$renderer3.push("<!--[-->");
            const SvelteComponent = page.data.slots.sidebar.component;
            $$renderer3.push(`<!---->`);
            SvelteComponent($$renderer3, spread_props([page.data.slots.sidebar.props, { class: [c, "p-3 sm:p-6"] }]));
            $$renderer3.push(`<!---->`);
          } else {
            $$renderer3.push("<!--[!-->");
            if (site.data?.site_view) {
              $$renderer3.push("<!--[-->");
              InstanceCard($$renderer3, {
                site: site.data.site_view,
                taglines: site.data.taglines,
                admins: site.data.admins,
                version: site.data.version,
                class: [c, "p-3 sm:p-6"]
              });
            } else {
              $$renderer3.push("<!--[!-->");
              $$renderer3.push(`<div class="h-64 w-full grid place-items-center">`);
              Spinner($$renderer3, { width: 32 });
              $$renderer3.push(`<!----></div>`);
            }
            $$renderer3.push(`<!--]-->`);
          }
          $$renderer3.push(`<!--]-->`);
        }
        $$renderer3.push(`<!---->`);
      };
      Shell($$renderer2, {
        sidebar,
        main,
        navbar,
        suffix,
        children: ($$renderer3) => {
          Moderation($$renderer3);
          $$renderer3.push(`<!----> `);
          ToastContainer($$renderer3);
          $$renderer3.push(`<!----> `);
          ExpandableImage($$renderer3, {});
          $$renderer3.push(`<!----> `);
          ModalContainer($$renderer3);
          $$renderer3.push(`<!---->`);
        }
      });
    }
    $$renderer2.push(`<!---->`);
  });
}
export {
  Home as H,
  Moon as M,
  Swatch as S,
  UserGroup as U,
  _layout as _,
  chords as c
};
//# sourceMappingURL=_layout.js.map
