import "clsx";
import { i as element, m as attributes, c as clsx, p as props_id, b as attr, f as bind_props, a as attr_class, l as spread_props, d as ensure_array_like, e as escape_html, s as store_get, u as unsubscribe_stores, o as getContext, k as stringify, j as attr_style, q as derived, r as setContext } from "./index3.js";
import { p as public_env } from "./shared-server.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import { w as writable } from "./index2.js";
import "@sveltejs/kit/internal/server";
import { n as noop } from "./utils2.js";
import { t } from "./index.js";
import { error } from "@sveltejs/kit";
import { LemmyHttp } from "lemmy-js-client";
import createClient from "openapi-fetch";
import { marked } from "marked";
import { I as Icon } from "./Icon.js";
import { s as settings } from "./settings.svelte.js";
import { createAvatar } from "@dicebear/core";
import * as initials from "@dicebear/initials";
import { p as photonify, l as linkify, s as subSupscriptExtension } from "./plugins.js";
function html(value) {
  var html2 = String(value ?? "");
  var open = "<!---->";
  return open + html2 + "<!---->";
}
function create_updated_store() {
  const { set, subscribe } = writable(false);
  {
    return {
      subscribe,
      // eslint-disable-next-line @typescript-eslint/require-await
      check: async () => false
    };
  }
}
const is_legacy = noop.toString().includes("$$") || /function \w+\(\) \{\}/.test(noop.toString());
if (is_legacy) {
  ({
    data: {},
    form: null,
    error: null,
    params: {},
    route: { id: null },
    state: {},
    status: -1,
    url: new URL("https://example.com")
  });
}
const stores = {
  updated: /* @__PURE__ */ create_updated_store()
};
function goto(url, opts = {}) {
  {
    throw new Error("Cannot call goto(...) on the server");
  }
}
function invalidate(resource) {
  {
    throw new Error("Cannot call invalidate(...) on the server");
  }
}
({
  check: stores.updated.check
});
const DEFAULT_CLIENT_TYPE = public_env.PUBLIC_INSTANCE_TYPE == "piefedalpha" ? {
  name: "piefed",
  baseUrl: "/api/alpha"
} : {
  name: "lemmy",
  baseUrl: "/api/v3"
};
const publishedToDate = (published) => published.endsWith("Z") ? new Date(published) : /* @__PURE__ */ new Date(`${published}Z`);
const ArrowDownTray = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M8.75 2.75a.75.75 0 0 0-1.5 0v5.69L5.03 6.22a.75.75 0 0 0-1.06 1.06l3.5 3.5a.75.75 0 0 0 1.06 0l3.5-3.5a.75.75 0 0 0-1.06-1.06L8.75 8.44V2.75Z"
      },
      {
        "d": "M3.5 9.75a.75.75 0 0 0-1.5 0v1.5A2.75 2.75 0 0 0 4.75 14h6.5A2.75 2.75 0 0 0 14 11.25v-1.5a.75.75 0 0 0-1.5 0v1.5c0 .69-.56 1.25-1.25 1.25h-6.5c-.69 0-1.25-.56-1.25-1.25v-1.5Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M10.75 2.75a.75.75 0 0 0-1.5 0v8.614L6.295 8.235a.75.75 0 1 0-1.09 1.03l4.25 4.5a.75.75 0 0 0 1.09 0l4.25-4.5a.75.75 0 0 0-1.09-1.03l-2.955 3.129V2.75Z"
      },
      {
        "d": "M3.5 12.75a.75.75 0 0 0-1.5 0v2.5A2.75 2.75 0 0 0 4.75 18h10.5A2.75 2.75 0 0 0 18 15.25v-2.5a.75.75 0 0 0-1.5 0v2.5c0 .69-.56 1.25-1.25 1.25H4.75c-.69 0-1.25-.56-1.25-1.25v-2.5Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5M16.5 12 12 16.5m0 0L7.5 12m4.5 4.5V3"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M12 2.25a.75.75 0 0 1 .75.75v11.69l3.22-3.22a.75.75 0 1 1 1.06 1.06l-4.5 4.5a.75.75 0 0 1-1.06 0l-4.5-4.5a.75.75 0 1 1 1.06-1.06l3.22 3.22V3a.75.75 0 0 1 .75-.75Zm-9 13.5a.75.75 0 0 1 .75.75v2.25a1.5 1.5 0 0 0 1.5 1.5h13.5a1.5 1.5 0 0 0 1.5-1.5V16.5a.75.75 0 0 1 1.5 0v2.25a3 3 0 0 1-3 3H5.25a3 3 0 0 1-3-3V16.5a.75.75 0 0 1 .75-.75Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const ClipboardDocument = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M11.986 3H12a2 2 0 0 1 2 2v6a2 2 0 0 1-1.5 1.937v-2.523a2.5 2.5 0 0 0-.732-1.768L8.354 5.232A2.5 2.5 0 0 0 6.586 4.5H4.063A2 2 0 0 1 6 3h.014A2.25 2.25 0 0 1 8.25 1h1.5a2.25 2.25 0 0 1 2.236 2ZM10.5 4v-.75a.75.75 0 0 0-.75-.75h-1.5a.75.75 0 0 0-.75.75V4h3Z",
        "clip-rule": "evenodd"
      },
      {
        "d": "M3 6a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h7a1 1 0 0 0 1-1v-3.586a1 1 0 0 0-.293-.707L7.293 6.293A1 1 0 0 0 6.586 6H3Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M15.988 3.012A2.25 2.25 0 0 1 18 5.25v6.5A2.25 2.25 0 0 1 15.75 14H13.5v-3.379a3 3 0 0 0-.879-2.121l-3.12-3.121a3 3 0 0 0-1.402-.791 2.252 2.252 0 0 1 1.913-1.576A2.25 2.25 0 0 1 12.25 1h1.5a2.25 2.25 0 0 1 2.238 2.012ZM11.5 3.25a.75.75 0 0 1 .75-.75h1.5a.75.75 0 0 1 .75.75v.25h-3v-.25Z",
        "clip-rule": "evenodd"
      },
      {
        "d": "M3.5 6A1.5 1.5 0 0 0 2 7.5v9A1.5 1.5 0 0 0 3.5 18h7a1.5 1.5 0 0 0 1.5-1.5v-5.879a1.5 1.5 0 0 0-.44-1.06L8.44 6.439A1.5 1.5 0 0 0 7.378 6H3.5Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M8.25 7.5V6.108c0-1.135.845-2.098 1.976-2.192.373-.03.748-.057 1.123-.08M15.75 18H18a2.25 2.25 0 0 0 2.25-2.25V6.108c0-1.135-.845-2.098-1.976-2.192a48.424 48.424 0 0 0-1.123-.08M15.75 18.75v-1.875a3.375 3.375 0 0 0-3.375-3.375h-1.5a1.125 1.125 0 0 1-1.125-1.125v-1.5A3.375 3.375 0 0 0 6.375 7.5H5.25m11.9-3.664A2.251 2.251 0 0 0 15 2.25h-1.5a2.251 2.251 0 0 0-2.15 1.586m5.8 0c.065.21.1.433.1.664v.75h-6V4.5c0-.231.035-.454.1-.664M6.75 7.5H4.875c-.621 0-1.125.504-1.125 1.125v12c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125V16.5a9 9 0 0 0-9-9Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M17.663 3.118c.225.015.45.032.673.05C19.876 3.298 21 4.604 21 6.109v9.642a3 3 0 0 1-3 3V16.5c0-5.922-4.576-10.775-10.384-11.217.324-1.132 1.3-2.01 2.548-2.114.224-.019.448-.036.673-.051A3 3 0 0 1 13.5 1.5H15a3 3 0 0 1 2.663 1.618ZM12 4.5A1.5 1.5 0 0 1 13.5 3H15a1.5 1.5 0 0 1 1.5 1.5H12Z",
        "clip-rule": "evenodd"
      },
      {
        "d": "M3 8.625c0-1.036.84-1.875 1.875-1.875h.375A3.75 3.75 0 0 1 9 10.5v1.875c0 1.036.84 1.875 1.875 1.875h1.875A3.75 3.75 0 0 1 16.5 18v2.625c0 1.035-.84 1.875-1.875 1.875h-9.75A1.875 1.875 0 0 1 3 20.625v-12Z"
      },
      {
        "d": "M10.5 10.5a5.23 5.23 0 0 0-1.279-3.434 9.768 9.768 0 0 1 6.963 6.963 5.23 5.23 0 0 0-3.434-1.279h-1.875a.375.375 0 0 1-.375-.375V10.5Z"
      }
    ]
  }
};
const Language = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M11 5a.75.75 0 0 1 .688.452l3.25 7.5a.75.75 0 1 1-1.376.596L12.89 12H9.109l-.67 1.548a.75.75 0 1 1-1.377-.596l3.25-7.5A.75.75 0 0 1 11 5Zm-1.24 5.5h2.48L11 7.636 9.76 10.5ZM5 1a.75.75 0 0 1 .75.75v1.261a25.27 25.27 0 0 1 2.598.211.75.75 0 1 1-.2 1.487c-.22-.03-.44-.056-.662-.08A12.939 12.939 0 0 1 5.92 8.058c.237.304.488.595.752.873a.75.75 0 0 1-1.086 1.035A13.075 13.075 0 0 1 5 9.307a13.068 13.068 0 0 1-2.841 2.546.75.75 0 0 1-.827-1.252A11.566 11.566 0 0 0 4.08 8.057a12.991 12.991 0 0 1-.554-.938.75.75 0 1 1 1.323-.707c.049.09.099.181.15.271.388-.68.708-1.405.952-2.164a23.941 23.941 0 0 0-4.1.19.75.75 0 0 1-.2-1.487c.853-.114 1.72-.185 2.598-.211V1.75A.75.75 0 0 1 5 1Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M7.75 2.75a.75.75 0 0 0-1.5 0v1.258a32.987 32.987 0 0 0-3.599.278.75.75 0 1 0 .198 1.487A31.545 31.545 0 0 1 8.7 5.545 19.381 19.381 0 0 1 7 9.56a19.418 19.418 0 0 1-1.002-2.05.75.75 0 0 0-1.384.577 20.935 20.935 0 0 0 1.492 2.91 19.613 19.613 0 0 1-3.828 4.154.75.75 0 1 0 .945 1.164A21.116 21.116 0 0 0 7 12.331c.095.132.192.262.29.391a.75.75 0 0 0 1.194-.91c-.204-.266-.4-.538-.59-.815a20.888 20.888 0 0 0 2.333-5.332c.31.031.618.068.924.108a.75.75 0 0 0 .198-1.487 32.832 32.832 0 0 0-3.599-.278V2.75Z"
      },
      {
        "fill-rule": "evenodd",
        "d": "M13 8a.75.75 0 0 1 .671.415l4.25 8.5a.75.75 0 1 1-1.342.67L15.787 16h-5.573l-.793 1.585a.75.75 0 1 1-1.342-.67l4.25-8.5A.75.75 0 0 1 13 8Zm2.037 6.5L13 10.427 10.964 14.5h4.073Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "m10.5 21 5.25-11.25L21 21m-9-3h7.5M3 5.621a48.474 48.474 0 0 1 6-.371m0 0c1.12 0 2.233.038 3.334.114M9 5.25V3m3.334 2.364C11.176 10.658 7.69 15.08 3 17.502m9.334-12.138c.896.061 1.785.147 2.666.257m-4.589 8.495a18.023 18.023 0 0 1-3.827-5.802"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M9 2.25a.75.75 0 0 1 .75.75v1.506a49.384 49.384 0 0 1 5.343.371.75.75 0 1 1-.186 1.489c-.66-.083-1.323-.151-1.99-.206a18.67 18.67 0 0 1-2.97 6.323c.318.384.65.753 1 1.107a.75.75 0 0 1-1.07 1.052A18.902 18.902 0 0 1 9 13.687a18.823 18.823 0 0 1-5.656 4.482.75.75 0 0 1-.688-1.333 17.323 17.323 0 0 0 5.396-4.353A18.72 18.72 0 0 1 5.89 8.598a.75.75 0 0 1 1.388-.568A17.21 17.21 0 0 0 9 11.224a17.168 17.168 0 0 0 2.391-5.165 48.04 48.04 0 0 0-8.298.307.75.75 0 0 1-.186-1.489 49.159 49.159 0 0 1 5.343-.371V3A.75.75 0 0 1 9 2.25ZM15.75 9a.75.75 0 0 1 .68.433l5.25 11.25a.75.75 0 1 1-1.36.634l-1.198-2.567h-6.744l-1.198 2.567a.75.75 0 0 1-1.36-.634l5.25-11.25A.75.75 0 0 1 15.75 9Zm-2.672 8.25h5.344l-2.672-5.726-2.672 5.726Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const Minus = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M3.75 7.25a.75.75 0 0 0 0 1.5h8.5a.75.75 0 0 0 0-1.5h-8.5Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M4 10a.75.75 0 0 1 .75-.75h10.5a.75.75 0 0 1 0 1.5H4.75A.75.75 0 0 1 4 10Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M5 12h14"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M4.25 12a.75.75 0 0 1 .75-.75h14a.75.75 0 0 1 0 1.5H5a.75.75 0 0 1-.75-.75Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const NoSymbol = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M3.05 3.05a7 7 0 1 1 9.9 9.9 7 7 0 0 1-9.9-9.9Zm1.627.566 7.707 7.707a5.501 5.501 0 0 0-7.707-7.707Zm6.646 8.768L3.616 4.677a5.501 5.501 0 0 0 7.707 7.707Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "m5.965 4.904 9.131 9.131a6.5 6.5 0 0 0-9.131-9.131Zm8.07 10.192L4.904 5.965a6.5 6.5 0 0 0 9.131 9.131ZM4.343 4.343a8 8 0 1 1 11.314 11.314A8 8 0 0 1 4.343 4.343Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M18.364 18.364A9 9 0 0 0 5.636 5.636m12.728 12.728A9 9 0 0 1 5.636 5.636m12.728 12.728L5.636 5.636"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "m6.72 5.66 11.62 11.62A8.25 8.25 0 0 0 6.72 5.66Zm10.56 12.68L5.66 6.72a8.25 8.25 0 0 0 11.62 11.62ZM5.105 5.106c3.807-3.808 9.98-3.808 13.788 0 3.808 3.807 3.808 9.98 0 13.788-3.807 3.808-9.98 3.808-13.788 0-3.808-3.807-3.808-9.98 0-13.788Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const Play = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M3 3.732a1.5 1.5 0 0 1 2.305-1.265l6.706 4.267a1.5 1.5 0 0 1 0 2.531l-6.706 4.268A1.5 1.5 0 0 1 3 12.267V3.732Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M6.3 2.84A1.5 1.5 0 0 0 4 4.11v11.78a1.5 1.5 0 0 0 2.3 1.27l9.344-5.891a1.5 1.5 0 0 0 0-2.538L6.3 2.841Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M5.25 5.653c0-.856.917-1.398 1.667-.986l11.54 6.347a1.125 1.125 0 0 1 0 1.972l-11.54 6.347a1.125 1.125 0 0 1-1.667-.986V5.653Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M4.5 5.653c0-1.427 1.529-2.33 2.779-1.643l11.54 6.347c1.295.712 1.295 2.573 0 3.286L7.28 19.99c-1.25.687-2.779-.217-2.779-1.643V5.653Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const Plus = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M8.75 3.75a.75.75 0 0 0-1.5 0v3.5h-3.5a.75.75 0 0 0 0 1.5h3.5v3.5a.75.75 0 0 0 1.5 0v-3.5h3.5a.75.75 0 0 0 0-1.5h-3.5v-3.5Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M10.75 4.75a.75.75 0 0 0-1.5 0v4.5h-4.5a.75.75 0 0 0 0 1.5h4.5v4.5a.75.75 0 0 0 1.5 0v-4.5h4.5a.75.75 0 0 0 0-1.5h-4.5v-4.5Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M12 4.5v15m7.5-7.5h-15"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const PuzzlePiece = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M9 3.889c0-.273.188-.502.417-.65.355-.229.583-.587.583-.989C10 1.56 9.328 1 8.5 1S7 1.56 7 2.25c0 .41.237.774.603 1.002.22.137.397.355.397.613 0 .331-.275.596-.605.579-.744-.04-1.482-.1-2.214-.18a.75.75 0 0 0-.83.81c.067.764.111 1.535.133 2.312A.6.6 0 0 1 3.882 8c-.268 0-.495-.185-.64-.412C3.015 7.231 2.655 7 2.25 7 1.56 7 1 7.672 1 8.5S1.56 10 2.25 10c.404 0 .764-.23.993-.588.144-.227.37-.412.64-.412a.6.6 0 0 1 .601.614 39.338 39.338 0 0 1-.231 3.3.75.75 0 0 0 .661.829c.826.093 1.66.161 2.5.204A.56.56 0 0 0 8 13.386c0-.271-.187-.499-.415-.645C7.23 12.512 7 12.153 7 11.75c0-.69.672-1.25 1.5-1.25s1.5.56 1.5 1.25c0 .403-.23.762-.585.99-.228.147-.415.375-.415.646v.11c0 .278.223.504.5.504 1.196 0 2.381-.052 3.552-.154a.75.75 0 0 0 .68-.661c.135-1.177.22-2.37.253-3.574a.597.597 0 0 0-.6-.611c-.27 0-.498.187-.644.415-.229.356-.588.585-.991.585-.69 0-1.25-.672-1.25-1.5S11.06 7 11.75 7c.403 0 .762.23.99.585.147.228.375.415.646.415a.597.597 0 0 0 .599-.61 40.914 40.914 0 0 0-.132-2.365.75.75 0 0 0-.815-.684A39.51 39.51 0 0 1 9.5 4.5a.501.501 0 0 1-.5-.503v-.108Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M12 4.467c0-.405.262-.75.559-1.027.276-.257.441-.584.441-.94 0-.828-.895-1.5-2-1.5s-2 .672-2 1.5c0 .362.171.694.456.953.29.265.544.6.544.994a.968.968 0 0 1-1.024.974 39.655 39.655 0 0 1-3.014-.306.75.75 0 0 0-.847.847c.14.993.242 1.999.306 3.014A.968.968 0 0 1 4.447 10c-.393 0-.729-.253-.994-.544C3.194 9.17 2.862 9 2.5 9 1.672 9 1 9.895 1 11s.672 2 1.5 2c.356 0 .683-.165.94-.441.276-.297.622-.559 1.027-.559a.997.997 0 0 1 1.004 1.03 39.747 39.747 0 0 1-.319 3.734.75.75 0 0 0 .64.842c1.05.146 2.111.252 3.184.318A.97.97 0 0 0 10 16.948c0-.394-.254-.73-.545-.995C9.171 15.693 9 15.362 9 15c0-.828.895-1.5 2-1.5s2 .672 2 1.5c0 .356-.165.683-.441.94-.297.276-.559.622-.559 1.027a.998.998 0 0 0 1.03 1.005c1.337-.05 2.659-.162 3.961-.337a.75.75 0 0 0 .644-.644c.175-1.302.288-2.624.337-3.961A.998.998 0 0 0 16.967 12c-.405 0-.75.262-1.027.559-.257.276-.584.441-.94.441-.828 0-1.5-.895-1.5-2s.672-2 1.5-2c.362 0 .694.17.953.455.265.291.601.545.995.545a.97.97 0 0 0 .976-1.024 41.159 41.159 0 0 0-.318-3.184.75.75 0 0 0-.842-.64c-1.228.164-2.473.271-3.734.319A.997.997 0 0 1 12 4.467Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M14.25 6.087c0-.355.186-.676.401-.959.221-.29.349-.634.349-1.003 0-1.036-1.007-1.875-2.25-1.875s-2.25.84-2.25 1.875c0 .369.128.713.349 1.003.215.283.401.604.401.959v0a.64.64 0 0 1-.657.643 48.39 48.39 0 0 1-4.163-.3c.186 1.613.293 3.25.315 4.907a.656.656 0 0 1-.658.663v0c-.355 0-.676-.186-.959-.401a1.647 1.647 0 0 0-1.003-.349c-1.036 0-1.875 1.007-1.875 2.25s.84 2.25 1.875 2.25c.369 0 .713-.128 1.003-.349.283-.215.604-.401.959-.401v0c.31 0 .555.26.532.57a48.039 48.039 0 0 1-.642 5.056c1.518.19 3.058.309 4.616.354a.64.64 0 0 0 .657-.643v0c0-.355-.186-.676-.401-.959a1.647 1.647 0 0 1-.349-1.003c0-1.035 1.008-1.875 2.25-1.875 1.243 0 2.25.84 2.25 1.875 0 .369-.128.713-.349 1.003-.215.283-.4.604-.4.959v0c0 .333.277.599.61.58a48.1 48.1 0 0 0 5.427-.63 48.05 48.05 0 0 0 .582-4.717.532.532 0 0 0-.533-.57v0c-.355 0-.676.186-.959.401-.29.221-.634.349-1.003.349-1.035 0-1.875-1.007-1.875-2.25s.84-2.25 1.875-2.25c.37 0 .713.128 1.003.349.283.215.604.401.96.401v0a.656.656 0 0 0 .658-.663 48.422 48.422 0 0 0-.37-5.36c-1.886.342-3.81.574-5.766.689a.578.578 0 0 1-.61-.58v0Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M11.25 5.337c0-.355-.186-.676-.401-.959a1.647 1.647 0 0 1-.349-1.003c0-1.036 1.007-1.875 2.25-1.875S15 2.34 15 3.375c0 .369-.128.713-.349 1.003-.215.283-.401.604-.401.959 0 .332.278.598.61.578 1.91-.114 3.79-.342 5.632-.676a.75.75 0 0 1 .878.645 49.17 49.17 0 0 1 .376 5.452.657.657 0 0 1-.66.664c-.354 0-.675-.186-.958-.401a1.647 1.647 0 0 0-1.003-.349c-1.035 0-1.875 1.007-1.875 2.25s.84 2.25 1.875 2.25c.369 0 .713-.128 1.003-.349.283-.215.604-.401.959-.401.31 0 .557.262.534.571a48.774 48.774 0 0 1-.595 4.845.75.75 0 0 1-.61.61c-1.82.317-3.673.533-5.555.642a.58.58 0 0 1-.611-.581c0-.355.186-.676.401-.959.221-.29.349-.634.349-1.003 0-1.035-1.007-1.875-2.25-1.875s-2.25.84-2.25 1.875c0 .369.128.713.349 1.003.215.283.401.604.401.959a.641.641 0 0 1-.658.643 49.118 49.118 0 0 1-4.708-.36.75.75 0 0 1-.645-.878c.293-1.614.504-3.257.629-4.924A.53.53 0 0 0 5.337 15c-.355 0-.676.186-.959.401-.29.221-.634.349-1.003.349-1.036 0-1.875-1.007-1.875-2.25s.84-2.25 1.875-2.25c.369 0 .713.128 1.003.349.283.215.604.401.959.401a.656.656 0 0 0 .659-.663 47.703 47.703 0 0 0-.31-4.82.75.75 0 0 1 .83-.832c1.343.155 2.703.254 4.077.294a.64.64 0 0 0 .657-.642Z"
      }
    ]
  }
};
const VideoCamera = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M3 4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h5a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H3ZM15 4.75a.75.75 0 0 0-1.28-.53l-2 2a.75.75 0 0 0-.22.53v2.5c0 .199.079.39.22.53l2 2a.75.75 0 0 0 1.28-.53v-6.5Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M3.25 4A2.25 2.25 0 0 0 1 6.25v7.5A2.25 2.25 0 0 0 3.25 16h7.5A2.25 2.25 0 0 0 13 13.75v-7.5A2.25 2.25 0 0 0 10.75 4h-7.5ZM19 4.75a.75.75 0 0 0-1.28-.53l-3 3a.75.75 0 0 0-.22.53v4.5c0 .199.079.39.22.53l3 3a.75.75 0 0 0 1.28-.53V4.75Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "m15.75 10.5 4.72-4.72a.75.75 0 0 1 1.28.53v11.38a.75.75 0 0 1-1.28.53l-4.72-4.72M4.5 18.75h9a2.25 2.25 0 0 0 2.25-2.25v-9a2.25 2.25 0 0 0-2.25-2.25h-9A2.25 2.25 0 0 0 2.25 7.5v9a2.25 2.25 0 0 0 2.25 2.25Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M4.5 4.5a3 3 0 0 0-3 3v9a3 3 0 0 0 3 3h8.25a3 3 0 0 0 3-3v-9a3 3 0 0 0-3-3H4.5ZM19.94 18.75l-2.69-2.69V7.94l2.69-2.69c.944-.945 2.56-.276 2.56 1.06v11.38c0 1.336-1.616 2.005-2.56 1.06Z"
      }
    ]
  }
};
const buttonAlignment = {
  left: "justify-start text-left origin-left",
  center: "justify-center",
  right: "justify-end text-right origin-right"
};
const buttonColor = {
  primary: "btn-primary",
  secondary: "btn-secondary",
  tertiary: "btn-tertiary",
  danger: "btn-danger",
  ghost: "btn-ghost",
  "danger-subtle": "text-red-500 hover:bg-red-500 hover:text-inherit!",
  "success-subtle": "text-green-500 hover:bg-green-500 hover:text-inherit!",
  "warning-subtle": "text-yellow-500 hover:bg-yellow-500 hover:text-inherit!",
  "blue-subtle": `text-blue-500 hover:bg-blue-500 hover:text-inherit!`,
  none: ""
};
const buttonShadow = { sm: "shadow-xs", none: "shadow-none" };
const buttonSize = {
  xs: "btn-xs",
  sm: "btn-sm",
  md: "btn-md",
  lg: "btn-lg",
  xl: "btn-xl",
  "square-sm": "btn-square-sm",
  "square-md": "btn-square-md",
  "square-lg": "btn-square-lg",
  "square-xl": "btn-square-xl",
  custom: ""
};
const buttonRounding = {
  pill: "rounded-full",
  "2xl": "rounded-2xl",
  xl: "rounded-xl",
  lg: "rounded-lg",
  md: "rounded-md",
  inherit: "rounded-[inherit]",
  none: ""
};
const buttonWeight = { md: "font-medium", none: "" };
const buttonGap = { xl: "gap-3", lg: "gap-2", md: "gap-1.5", none: "" };
function Button($$renderer, $$props) {
  let {
    loading = false,
    submit = false,
    type = "button",
    color = "secondary",
    size = "md",
    rounding = size == "lg" || size == "square-lg" ? "2xl" : "xl",
    alignment = "center",
    shadow = color == "primary" || color == "secondary" ? "sm" : "none",
    gap = "md",
    disabled,
    loaderWidth = void 0,
    href = void 0,
    class: clazz = "",
    prefix,
    children,
    suffix,
    icon,
    weight = "md",
    $$slots,
    $$events,
    ...rest
  } = $$props;
  element(
    $$renderer,
    href ? "a" : "button",
    () => {
      $$renderer.push(`${attributes({
        role: href ? "link" : "button",
        href,
        ...rest,
        tabindex: disabled ? -1 : void 0,
        class: clsx([
          type == "button" && "btn",
          buttonSize[size],
          buttonRounding[rounding],
          buttonShadow[shadow],
          buttonColor[color],
          buttonAlignment[alignment],
          buttonWeight[weight],
          buttonGap[gap],
          (disabled || loading) && "btn-disabled",
          alignment == "center" ? "origin-center" : alignment == "left" ? "origin-left" : "origin-right",
          clazz
        ]),
        type: submit ? "submit" : "button"
      })}`);
    },
    () => {
      if (loading) {
        $$renderer.push("<!--[-->");
        Spinner($$renderer, { width: loaderWidth ?? 16 });
      } else {
        $$renderer.push("<!--[!-->");
        if (prefix) {
          $$renderer.push("<!--[-->");
          prefix?.($$renderer);
          $$renderer.push(`<!---->`);
        } else {
          $$renderer.push("<!--[!-->");
          if (icon) {
            $$renderer.push("<!--[-->");
            Icon($$renderer, {
              src: icon,
              size: "16",
              mini: true,
              class: [color == "secondary" && "text-slate-600 dark:text-zinc-400"]
            });
          } else {
            $$renderer.push("<!--[!-->");
          }
          $$renderer.push(`<!--]-->`);
        }
        $$renderer.push(`<!--]-->`);
      }
      $$renderer.push(`<!--]--> `);
      children?.($$renderer);
      $$renderer.push(`<!----> `);
      suffix?.($$renderer);
      $$renderer.push(`<!---->`);
    }
  );
}
function Spinner($$renderer, $$props) {
  let { width = 16, $$slots, $$events, ...rest } = $$props;
  $$renderer.push(`<svg${attributes(
    {
      ...rest,
      width,
      height: width,
      stroke: "currentColor",
      fill: "none",
      "stroke-width": "2",
      viewBox: "0 0 24 24",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      class: "animate-spin",
      xmlns: "http://www.w3.org/2000/svg",
      "aria-live": "polite",
      role: "status"
    },
    "svelte-2a5185",
    void 0,
    void 0,
    3
  )}><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg>`);
}
function Material($$renderer, $$props) {
  const elevationClass = {
    flat: "",
    low: "shadow-2xs",
    medium: "shadow-xs",
    high: "shadow-md",
    xhigh: "shadow-lg",
    max: "shadow-xl"
  };
  const paddingClass = {
    none: "",
    xs: "p-1.5",
    sm: "p-2",
    md: "p-4",
    lg: "p-5",
    xl: "p-6"
  };
  const roundedClass = {
    none: "",
    sm: "rounded-xs",
    md: "rounded-md",
    lg: "rounded-lg",
    xl: "rounded-xl",
    "2xl": "rounded-2xl",
    "3xl": "rounded-3xl",
    full: "rounded-full"
  };
  const colorClass = {
    default: "material-default",
    distinct: "material-distinct",
    transparent: "material-transparent",
    uniform: "material-uniform",
    info: "material-info",
    warning: "material-warning",
    success: "material-success",
    error: "material-error",
    none: ""
  };
  let {
    elevation = "low",
    padding = "md",
    rounding = "xl",
    color = "uniform",
    element: element$1 = "div",
    icon,
    class: clazz = "",
    children,
    $$slots,
    $$events,
    ...rest
  } = $$props;
  element(
    $$renderer,
    element$1,
    () => {
      $$renderer.push(`${attributes({
        ...rest,
        class: clsx([
          elevationClass[elevation],
          paddingClass[padding],
          roundedClass[rounding],
          colorClass[color],
          "text-sm",
          clazz
        ])
      })}`);
    },
    () => {
      if (icon) {
        $$renderer.push("<!--[-->");
        Icon($$renderer, {
          src: icon,
          size: "20",
          mini: true,
          class: "inline-block rounded-lg clear-both float-left mr-2"
        });
      } else {
        $$renderer.push("<!--[!-->");
      }
      $$renderer.push(`<!--]--> `);
      children?.($$renderer);
      $$renderer.push(`<!---->`);
    }
  );
}
function Disclosure($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const id = props_id($$renderer2);
    let {
      open = false,
      class: clazz = "",
      summary,
      extended,
      children,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    $$renderer2.push(`<div${attributes({ ...rest, class: clsx(["w-full relative", clazz]) }, "svelte-12tvw3t")}><label${attr("for", id)} class="w-full">`);
    summary?.($$renderer2, { open });
    $$renderer2.push(`<!----></label> `);
    extended?.($$renderer2);
    $$renderer2.push(`<!----> <input${attr("id", id)} class="appearance-none absolute w-full h-full inset-0 pointer-events-none svelte-12tvw3t" type="checkbox"${attr("checked", open, true)}/> <div class="expand svelte-12tvw3t"${attr("inert", !open, true)}>`);
    children?.($$renderer2, { open });
    $$renderer2.push(`<!----></div></div>`);
    bind_props($$props, { open });
  });
}
function Expandable($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      open = false,
      icon = true,
      class: clazz = "",
      title,
      extended,
      content,
      children
    } = $$props;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      {
        let summary = function($$renderer4) {
          $$renderer4.push(`<div${attr_class(clsx([
            "font-medium w-full text-left flex flex-row items-center justify-between hover:text-primary-900",
            "dark:hover:text-primary-100 transition-colors z-0 group relative cursor-pointer"
          ]))}><div class="flex flex-row gap-1 items-center w-full">`);
          title?.($$renderer4, open);
          $$renderer4.push(`<!----></div> `);
          if (icon) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<div${attr_class(clsx([
              "ml-auto",
              !open && "rotate-90",
              "transition-transform duration-300 ease-out"
            ]))}>`);
            Icon($$renderer4, { src: open ? Minus : Plus, size: "15", micro: true, class: [] });
            $$renderer4.push(`<!----></div>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--> <div class="inset-0 -z-10 opacity-0 absolute bg-slate-200/50 dark:bg-zinc-900/50 rounded-full group-hover:opacity-100 group-hover:-inset-1 group-hover:-inset-x-2 transition-all"></div></div>`);
        };
        Disclosure($$renderer3, {
          extended,
          class: ["gap-2", clazz],
          get open() {
            return open;
          },
          set open($$value) {
            open = $$value;
            $$settled = false;
          },
          summary,
          children: ($$renderer4) => {
            if (content) {
              $$renderer4.push("<!--[-->");
              content($$renderer4);
              $$renderer4.push(`<!---->`);
            } else {
              $$renderer4.push("<!--[!-->");
              $$renderer4.push(`<div class="text-slate-900 dark:text-zinc-100 *:mt-2">`);
              children?.($$renderer4);
              $$renderer4.push(`<!----></div>`);
            }
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { summary: true, default: true }
        });
      }
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    bind_props($$props, { open });
  });
}
function MdTree($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      type,
      tokens = [],
      renderers: renderers2,
      raw,
      text,
      header,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    if (header) {
      type = "tablecell";
    }
    if (type) {
      $$renderer2.push("<!--[-->");
      if (renderers2[type]) {
        $$renderer2.push("<!--[-->");
        const Renderer = renderers2[type];
        $$renderer2.push(`<!---->`);
        Renderer($$renderer2, spread_props([
          rest,
          {
            raw,
            text,
            children: ($$renderer3) => {
              $$renderer3.push(`<!--[-->`);
              const each_array = ensure_array_like(tokens);
              for (let $$index_4 = 0, $$length = each_array.length; $$index_4 < $$length; $$index_4++) {
                let token = each_array[$$index_4];
                if (type != "list" && type != "table") {
                  $$renderer3.push("<!--[-->");
                  if (token.tokens && token.tokens.length > 0) {
                    $$renderer3.push("<!--[-->");
                    MdTree($$renderer3, spread_props([{ tokens: token.tokens, renderers: renderers2 }, rest]));
                  } else {
                    $$renderer3.push("<!--[!-->");
                    if (token.text) {
                      $$renderer3.push("<!--[-->");
                      $$renderer3.push(`${escape_html(token.text)}`);
                    } else {
                      $$renderer3.push("<!--[!-->");
                      if (text) {
                        $$renderer3.push("<!--[-->");
                        $$renderer3.push(`${escape_html(text)}`);
                      } else {
                        $$renderer3.push("<!--[!-->");
                      }
                      $$renderer3.push(`<!--]-->`);
                    }
                    $$renderer3.push(`<!--]-->`);
                  }
                  $$renderer3.push(`<!--]-->`);
                } else {
                  $$renderer3.push("<!--[!-->");
                  if (type == "list" && token.items) {
                    $$renderer3.push("<!--[-->");
                    $$renderer3.push(`<!--[-->`);
                    const each_array_1 = ensure_array_like(token.items);
                    for (let $$index = 0, $$length2 = each_array_1.length; $$index < $$length2; $$index++) {
                      let item = each_array_1[$$index];
                      MdTree($$renderer3, spread_props([{ type: "list_item", renderers: renderers2, tokens: [item] }, rest]));
                    }
                    $$renderer3.push(`<!--]-->`);
                  } else {
                    $$renderer3.push("<!--[!-->");
                    if (type == "table") {
                      $$renderer3.push("<!--[-->");
                      const THead = renderers2["tablehead"];
                      const TBody = renderers2["tablebody"];
                      const TRow = renderers2["tablerow"];
                      if (token.header) {
                        $$renderer3.push("<!--[-->");
                        $$renderer3.push(`<!---->`);
                        THead($$renderer3, {
                          children: ($$renderer4) => {
                            $$renderer4.push(`<!---->`);
                            TRow($$renderer4, {
                              children: ($$renderer5) => {
                                $$renderer5.push(`<!--[-->`);
                                const each_array_2 = ensure_array_like(token.header);
                                for (let index = 0, $$length2 = each_array_2.length; index < $$length2; index++) {
                                  let heading = each_array_2[index];
                                  MdTree($$renderer5, spread_props([
                                    rest,
                                    {
                                      type: "tablecell",
                                      renderers: renderers2,
                                      tokens: heading.tokens,
                                      align: token.align[index]
                                    }
                                  ]));
                                }
                                $$renderer5.push(`<!--]-->`);
                              },
                              $$slots: { default: true }
                            });
                            $$renderer4.push(`<!---->`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer3.push(`<!---->`);
                      } else {
                        $$renderer3.push("<!--[!-->");
                      }
                      $$renderer3.push(`<!--]--> `);
                      if (token.rows) {
                        $$renderer3.push("<!--[-->");
                        $$renderer3.push(`<!---->`);
                        TBody($$renderer3, {
                          children: ($$renderer4) => {
                            $$renderer4.push(`<!--[-->`);
                            const each_array_3 = ensure_array_like(token.rows);
                            for (let $$index_3 = 0, $$length2 = each_array_3.length; $$index_3 < $$length2; $$index_3++) {
                              let row = each_array_3[$$index_3];
                              $$renderer4.push(`<!---->`);
                              TRow($$renderer4, {
                                children: ($$renderer5) => {
                                  $$renderer5.push(`<!--[-->`);
                                  const each_array_4 = ensure_array_like(row);
                                  for (let index = 0, $$length3 = each_array_4.length; index < $$length3; index++) {
                                    let cell = each_array_4[index];
                                    MdTree($$renderer5, spread_props([
                                      rest,
                                      {
                                        type: "tablecell",
                                        renderers: renderers2,
                                        tokens: cell.tokens,
                                        align: token.align[index]
                                      }
                                    ]));
                                  }
                                  $$renderer5.push(`<!--]-->`);
                                },
                                $$slots: { default: true }
                              });
                              $$renderer4.push(`<!---->`);
                            }
                            $$renderer4.push(`<!--]-->`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer3.push(`<!---->`);
                      } else {
                        $$renderer3.push("<!--[!-->");
                      }
                      $$renderer3.push(`<!--]-->`);
                    } else {
                      $$renderer3.push("<!--[!-->");
                    }
                    $$renderer3.push(`<!--]-->`);
                  }
                  $$renderer3.push(`<!--]-->`);
                }
                $$renderer3.push(`<!--]-->`);
              }
              $$renderer3.push(`<!--]-->`);
            },
            $$slots: { default: true }
          }
        ]));
        $$renderer2.push(`<!---->`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<!--[-->`);
      const each_array_5 = ensure_array_like(tokens);
      for (let $$index_5 = 0, $$length = each_array_5.length; $$index_5 < $$length; $$index_5++) {
        let token = each_array_5[$$index_5];
        MdTree($$renderer2, spread_props([
          rest,
          token,
          {
            tokens: [token],
            type: token.type,
            renderers: renderers2,
            raw: token.raw,
            text: token.text
          }
        ]));
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]-->`);
  });
}
function MdCode($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { raw } = $$props;
    function parseCodeblock(src) {
      const match = /^```(.*)/gi.exec(src);
      if (match?.[1]) {
        return {
          code: src.replace(/^```(.*)/gi, "").replaceAll("```", ""),
          lang: match?.[1]
        };
      } else {
        return { code: src.replaceAll("```", "") };
      }
    }
    let codeblock = parseCodeblock(raw);
    Material($$renderer2, {
      padding: "none",
      rounding: "2xl",
      class: "flex flex-col rounded-xl\n  divide-y divide-slate-200 dark:divide-zinc-800 overflow-hidden",
      children: ($$renderer3) => {
        $$renderer3.push(`<div class="w-full bg-slate-25 dark:bg-zinc-925 h-9 flex items-center justify-between p-2"><pre class="code-baseline text-xs"> ${escape_html(codeblock.lang)}</pre> `);
        Button($$renderer3, {
          size: "square-sm",
          color: "tertiary",
          onclick: () => {
            navigator?.clipboard?.writeText(codeblock.code);
            toast({
              content: store_get($$store_subs ??= {}, "$t", t)("toast.copied")
            });
          },
          children: ($$renderer4) => {
            Icon($$renderer4, {
              src: ClipboardDocument,
              size: "16",
              micro: true,
              class: "text-slate-600 dark:text-zinc-400"
            });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></div> <pre class="code-baseline w-full overflow-x-auto text-xs bg-white dark:bg-zinc-950 px-4">
    ${escape_html(codeblock.code)}
  </pre>`);
      },
      $$slots: { default: true }
    });
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function MdHeading($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const options = getContext("options");
    let { depth = 0, raw = void 0, children } = $$props;
    if (depth === 1) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<h1${attr_class(clsx([options.inline && "inline"]), "svelte-azg7mb")}>`);
      children?.($$renderer2);
      $$renderer2.push(`<!----></h1>`);
    } else {
      $$renderer2.push("<!--[!-->");
      if (depth === 2) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<h2${attr_class(clsx([options.inline && "inline"]), "svelte-azg7mb")}>`);
        children?.($$renderer2);
        $$renderer2.push(`<!----></h2>`);
      } else {
        $$renderer2.push("<!--[!-->");
        if (depth === 3) {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`<h3${attr_class(clsx([options.inline && "inline"]), "svelte-azg7mb")}>`);
          children?.($$renderer2);
          $$renderer2.push(`<!----></h3>`);
        } else {
          $$renderer2.push("<!--[!-->");
          if (depth === 4) {
            $$renderer2.push("<!--[-->");
            $$renderer2.push(`<h4${attr_class(clsx([options.inline && "inline"]), "svelte-azg7mb")}>`);
            children?.($$renderer2);
            $$renderer2.push(`<!----></h4>`);
          } else {
            $$renderer2.push("<!--[!-->");
            if (depth === 5) {
              $$renderer2.push("<!--[-->");
              $$renderer2.push(`<h5${attr_class(clsx([options.inline && "inline"]), "svelte-azg7mb")}>`);
              children?.($$renderer2);
              $$renderer2.push(`<!----></h5>`);
            } else {
              $$renderer2.push("<!--[!-->");
              if (depth === 6) {
                $$renderer2.push("<!--[-->");
                $$renderer2.push(`<h6${attr_class(clsx([options.inline && "inline"]), "svelte-azg7mb")}>`);
                children?.($$renderer2);
                $$renderer2.push(`<!----></h6>`);
              } else {
                $$renderer2.push("<!--[!-->");
                $$renderer2.push(`${escape_html(raw)}`);
              }
              $$renderer2.push(`<!--]-->`);
            }
            $$renderer2.push(`<!--]-->`);
          }
          $$renderer2.push(`<!--]-->`);
        }
        $$renderer2.push(`<!--]-->`);
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]-->`);
  });
}
function MdHr($$renderer) {
  $$renderer.push(`<hr class="border-slate-200 dark:border-zinc-800"/>`);
}
function MdHtml($$renderer, $$props) {
  let { text } = $$props;
  $$renderer.push(`<p>${escape_html(text)}</p>`);
}
const SvelteSet = globalThis.Set;
const SvelteMap = globalThis.Map;
const SvelteURL = globalThis.URL;
const SvelteURLSearchParams = globalThis.URLSearchParams;
const findClosestNumber = (numbers, target) => numbers.reduce((prev, curr) => curr >= target && (prev < target || curr < prev) ? curr : prev);
const searchParam = (url, key, value, ...deleteKeys) => {
  url.searchParams.set(key, value);
  deleteKeys.forEach((k) => url.searchParams.delete(k));
  goto(url, {});
};
const fullCommunityName = (name, actorId) => `${name}@${new SvelteURL(actorId).hostname}`;
const placeholders = {
  get: (type) => {
    switch (type) {
      case "post":
        return Math.random() < 0.01 ? "A C E C* B* G D E E F G F E D C E" : t.get("placeholders.title");
      case "body":
        return t.get("placeholders.body");
      case "comment":
        return t.get("placeholders.comments");
      case "url":
        return "https://example.com";
    }
  }
};
function moveItem(array, currentIndex, newIndex) {
  if (currentIndex < 0 || currentIndex >= array.length || newIndex < 0 || newIndex >= array.length) {
    throw new Error("Invalid index");
  }
  const newArray = [...array];
  const [item] = newArray.splice(currentIndex, 1);
  newArray.splice(newIndex, 0, item);
  return newArray;
}
const DOMAIN_REGEX_FORMS = "(http(s)?://)?((?!-)[A-Za-z0-9]{1,63}.)+[A-Za-z]{2,63}(:[0-9]{0,5})?";
const instanceToURL = (input) => input.startsWith("http://") || input.startsWith("https://") ? input : `https://${input}`;
function canParseUrl(url) {
  try {
    new SvelteURL(url);
    return true;
  } catch {
    return false;
  }
}
function escapeHtml(input) {
  return input.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&#39;");
}
const awaitIfServer = async (promise) => ({ data: await promise });
class ReactiveState {
  value;
  constructor(initialValue) {
    this.value = initialValue;
  }
}
const isImage = (url) => {
  try {
    if (!url) return false;
    return /\.(jpeg|jpg|gif|png|svg|bmp|webp|avif)/i.test(url);
  } catch {
    return false;
  }
};
const isVideo = (url) => {
  try {
    if (!url) return false;
    return /\.(mp4|mov|webm|mkv|avi)/i.test(url);
  } catch {
    return false;
  }
};
const communityLink = (community, prefix = "") => `${prefix}/c/${fullCommunityName(community.name, community.actor_id)}`;
const userLink = (person, prefix = "") => `${prefix}/u/${person.name}@${new SvelteURL(person.actor_id).hostname}`;
function recursiveEqual(a, b) {
  if (a === b) return true;
  if (typeof a !== "object" || typeof b !== "object") return false;
  if (a == null || b == null) {
    if (a == null && b == null) return true;
    else return false;
  }
  const keysA = Object.keys(a);
  const keysB = Object.keys(b);
  if (keysA.length != keysB.length) return false;
  for (const key of keysA) {
    const valA = a[key];
    const valB = b[key];
    if (typeof valA == "object" && typeof valB == "object") {
      const result = recursiveEqual(valA, valB);
      if (!result) return false;
    } else {
      if (valA != valB) return false;
    }
  }
  return true;
}
const bestImageURL = (post, thumbnail = true, width = 1024, format = "webp") => {
  if (post.thumbnail_url && (thumbnail || !post.url))
    return optimizeImageURL(post.thumbnail_url, width, format);
  else if (post.url) return optimizeImageURL(post.url, width, format);
  return post.url ?? "";
};
const optimizeImageURL = (urlStr, width = 1024, format = "webp") => {
  try {
    let url;
    try {
      url = new URL(urlStr);
    } catch {
      return urlStr;
    }
    if (format) url.searchParams.set("format", format);
    if (width > 0 && !url.searchParams.has("thumbnail")) {
      url.searchParams.set(
        "thumbnail",
        findClosestNumber(
          [128, 196, 256, 512, 728, 1024, 1536],
          width
        ).toString()
      );
    }
    return url.toString();
  } catch (e) {
    console.error(e);
    return urlStr;
  }
};
const YOUTUBE_REGEX = /^(?:https?:\/\/)?(?:www\.|m\.)?(?:youtu\.be\/|youtube\.com\/(?:embed\/|shorts\/|live\/|v\/|watch\?v=|watch\?.+&v=))((\w|-){11})(?:\S+)?$/;
const isYoutubeLink = (url) => {
  if (!url) return null;
  return url?.match?.(YOUTUBE_REGEX);
};
function postLink(post) {
  return `/post/${encodeURIComponent(profile.current.instance)}/${post.id}`;
}
function mediaType(post) {
  if (!post) return "none";
  const isPost = typeof post != "string";
  const url = isPost ? post.url : post;
  if (isPost) {
    if (post.poll) return "poll";
    if (post.event) return "event";
  }
  if (!url) return "none";
  try {
    new URL(url);
  } catch {
    return "none";
  }
  if (isImage(url)) return "image";
  if (isVideo(url)) return "iframe";
  if (isYoutubeLink(url)) return "iframe";
  if (canParseUrl(url)) return "embed";
  return "none";
}
function iframeType(url) {
  if (isVideo(url)) return "video";
  if (isYoutubeLink(url)) return "youtube";
  return "none";
}
async function hidePost(id, hide, jwt) {
  await client({ auth: jwt }).hidePost({
    hide,
    post_ids: [id]
  });
  return hide;
}
function Avatar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const sizes = [16, 24, 32, 48, 64, 96, 128, 256, 512];
    const optimizeUrl = (url2, res2) => {
      if (url2 === void 0) return;
      try {
        const urlObj = new URL(url2);
        urlObj.searchParams.append("format", "webp");
        if (res2 > -1) {
          urlObj.searchParams.append("thumbnail", findClosestNumber(sizes, res2).toString());
        }
        return urlObj.toString();
      } catch {
        return void 0;
      }
    };
    let {
      url,
      alt = "",
      title = "",
      circle = true,
      width,
      res = void 0,
      style = "",
      class: clazz = "",
      $$slots,
      $$events,
      ...rest
    } = $$props;
    let optimizedURLs = [1.5, 3].map((n) => optimizeUrl(url, (res || width) * n));
    if (url && optimizedURLs[0] != void 0) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<img${attributes({
        ...rest,
        loading: "lazy",
        srcset: `${stringify(optimizedURLs[0])} 1x, ${stringify(optimizedURLs[1])} 2x`,
        src: optimizedURLs[0],
        alt: "",
        width,
        title,
        class: clsx([
          "aspect-square object-cover overflow-hidden shrink-0",
          circle === true ? "rounded-full" : circle === false ? "rounded-lg" : "",
          clazz
        ]),
        style: `width: ${stringify(width)}px; height: ${stringify(width)}px; ${stringify(style)}`
      })} onload="this.__e=event" onerror="this.__e=event"/>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<div${attr_style(`width: ${stringify(width)}px; height: ${stringify(width)}px;`)}${attr_class(clsx([
        "aspect-square object-cover overflow-hidden shrink-0",
        circle === true ? "rounded-full" : circle === false ? "rounded-lg" : "",
        clazz
      ]))}>${html(createAvatar(initials, {
        seed: alt,
        backgroundType: ["gradientLinear"],
        fontWeight: 800,
        randomizeIds: true,
        chars: 1,
        scale: 125,
        textColor: ["fff", "000"],
        backgroundColor: [
          "7B68EE",
          "FF6347",
          "20B2AA",
          "DDA0DD",
          "F0E68C",
          "FF1493",
          "4682B4",
          "32CD32",
          "FFB6C1",
          "8B4513",
          "00CED1",
          "9370DB",
          "FFA500",
          "2E8B57",
          "DC143C",
          "BA55D3",
          "708090",
          "ADFF2F",
          "CD853F",
          "48D1CC"
        ]
      }).toString())}</div>`);
    }
    $$renderer2.push(`<!--]-->`);
  });
}
function Logo($$renderer, $$props) {
  let { width = 48 } = $$props;
  $$renderer.push(`<svg${attr("width", width)}${attr("height", width)} viewBox="0 0 100 100" fill="currentColor" xmlns="http://www.w3.org/2000/svg" class="inline hover:fill-slate-700 dark:hover:fill-zinc-300 transition-colors"><path id="hexagon" d="M45.5 10.8868C48.594 9.10042 52.406 9.10042 55.5 10.8868L82.3061 26.3632C85.4001 28.1496 87.3061 31.4508 87.3061 35.0235V65.9765C87.3061 69.5492 85.4001 72.8504 82.3061 74.6368L55.5 90.1132C52.406 91.8996 48.594 91.8996 45.5 90.1132L18.6939 74.6368C15.5999 72.8504 13.6939 69.5492 13.6939 65.9765V35.0235C13.6939 31.4508 15.5999 28.1496 18.6939 26.3632L45.5 10.8868Z"></path></svg>`);
}
function parseBadge() {
  try {
    if (public_env.PUBLIC_BADGES) {
      return JSON.parse(public_env.PUBLIC_BADGES);
    } else {
      return {};
    }
  } catch {
    return {};
  }
}
const badges = parseBadge();
const getEnvBadge = (actor_id) => {
  if (badges.photon && badges.photon?.includes?.(actor_id)) {
    return {
      classes: "bg-linear-to-r bg-clip-text text-transparent from-pink-500 to-fuchsia-500 dark:from-pink-400 dark:to-purple-400",
      icon: "photon"
    };
  }
  if (badges.translator && badges.translator?.includes?.(actor_id)) {
    return {
      classes: "bg-linear-to-r bg-clip-text text-transparent from-sky-500 to-blue-700 dark:from-blue-300 dark:to-indigo-500",
      icon: Language,
      iconClass: "text-blue-500 dark:text-blue-400"
    };
  }
  return false;
};
function UserLink($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      user,
      avatar = false,
      avatarSize = 24,
      badges: badges2 = true,
      inComment = false,
      showInstance = settings.showInstances.user || settings.showInstances.comments && inComment,
      displayName = settings.displayNames,
      instanceClass = "",
      class: clazz = "",
      children,
      extraBadges
    } = $$props;
    let envBadge = getEnvBadge(user.actor_id);
    $$renderer2.push(`<a${attr_class(`items-center inline-flex flex-row gap-1 hover:underline max-w-full min-w-0 ${stringify(clazz)}`, "svelte-13oojt1")}${attr("href", `/u/${stringify(user.name)}@${stringify(new URL(user.actor_id).hostname)}`)} data-sveltekit-preload-data="tap">`);
    children?.($$renderer2);
    $$renderer2.push(`<!----> `);
    if (avatar) {
      $$renderer2.push("<!--[-->");
      Avatar($$renderer2, {
        url: user.avatar,
        alt: user.name,
        width: avatarSize,
        class: "shrink-0"
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <span${attr_class("flex gap-0 items-center shrink max-w-full min-w-0", void 0, { "ml-0.5": avatar })}><span${attr_class(`username-text ${stringify(envBadge && envBadge.classes)}`, "svelte-13oojt1", { "font-medium": showInstance })}>${escape_html(displayName ? user.display_name || user.name : user.name)}</span> `);
    if (showInstance) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<span${attr_class(`text-slate-500 dark:text-zinc-500 font-normal instance-text shrink ${stringify(instanceClass ?? "")}`, "svelte-13oojt1")}>@${escape_html(new URL(user.actor_id).hostname)}</span>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></span> `);
    if (badges2) {
      $$renderer2.push("<!--[-->");
      if (user.banned) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="text-red-500" title="Banned">`);
        Icon($$renderer2, { src: NoSymbol, mini: true, size: "12" });
        $$renderer2.push(`<!----></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (user.bot_account) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="text-blue-500 font-bold" title="Bot">BOT</div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (envBadge) {
        $$renderer2.push("<!--[-->");
        if (envBadge.icon == "photon") {
          $$renderer2.push("<!--[-->");
          Logo($$renderer2, { width: 16 });
        } else {
          $$renderer2.push("<!--[!-->");
          Icon($$renderer2, {
            src: envBadge.icon,
            micro: true,
            size: "16",
            class: envBadge.iconClass ?? envBadge.classes
          });
        }
        $$renderer2.push(`<!--]-->`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (user.flair) {
        $$renderer2.push("<!--[-->");
        Badge($$renderer2, {
          color: "blue-subtle",
          class: "px-1.5! py-0.5! whitespace-nowrap",
          children: ($$renderer3) => {
            $$renderer3.push(`<!---->${escape_html(user.flair)}`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (user.note) {
        $$renderer2.push("<!--[-->");
        Badge($$renderer2, {
          color: "gray-subtle",
          class: "px-1.5! py-0.5! whitespace-nowrap",
          children: ($$renderer3) => {
            $$renderer3.push(`<!---->${escape_html(user.note)}`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      extraBadges?.($$renderer2);
      $$renderer2.push(`<!---->`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></a>`);
  });
}
function errorMessage(error2, instance2) {
  try {
    if (typeof error2 == "string") {
      try {
        error2 = JSON.parse(error2);
      } catch {
      }
    }
    if (error2?.body?.message) {
      error2 = JSON.parse(error2?.body?.message);
      if (typeof error2?.message == "string") {
        error2 = error2.message;
      }
    }
    if (error2?.message) {
      error2 = error2?.message;
    }
    if (error2?.error && typeof error2?.error === "string") {
      error2 = error2.error;
    }
    if (!error2) throw error2;
    return t.get(`error.${error2}`);
  } catch {
    return error2;
  }
}
function getItemPublished(item) {
  if ("post_report" in item) return item.post_report.published;
  if ("comment_report" in item) return item.comment_report.published;
  if ("private_message_report" in item)
    return item.private_message_report.published;
  if ("private_message" in item) return item.private_message.published;
  if ("comment" in item) return item.comment.published;
  else if ("post" in item) return item.post.published;
  if ("person" in item) return item.person.published;
  if ("community" in item) return item.community.published;
  return "";
}
const isPostView = (item) => "post" in item && !("comment" in item);
const isCommentView = (item) => "comment" in item;
const isComment = (item) => "content" in item;
const isCommunityView = (item) => "community" in item;
const isUser = (item) => "person" in item;
function resumableStore(limit = 10) {
  const { subscribe, set, update } = writable([]);
  return {
    subscribe,
    set,
    update,
    add: (item) => {
      update((resumables2) => {
        if (resumables2.find((i) => JSON.stringify(i) == JSON.stringify(item)))
          return resumables2;
        resumables2.unshift(item);
        if (resumables2.length > limit) resumables2.pop();
        return resumables2;
      });
    }
  };
}
resumableStore();
function Blobs($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { seed } = $$props;
    function randomoklch(seed2, count) {
      function hashString(str) {
        let hash = 0;
        for (let i = 0; i < str.length; i++) {
          const char = str.charCodeAt(i);
          hash = (hash << 5) - hash + char;
          hash = hash & hash;
        }
        return Math.abs(hash);
      }
      function seededRandom(seedStr, index) {
        const combined = hashString(seedStr + "|" + index.toString());
        let x = Math.sin(combined) * 1e4;
        return x - Math.floor(x);
      }
      const colors2 = [];
      const baseHue = hashString(seed2) % 12 * 60;
      for (let i = 0; i < count; i++) {
        const r1 = seededRandom(seed2, i * 5);
        const r2 = seededRandom(seed2, i * 5 + 1);
        const r3 = seededRandom(seed2, i * 5 + 2);
        const lightness = 0.45 + r1 * 0.4;
        const chroma = 0.08 + r2 * 0.12;
        const hueVariation = (r3 - 0.5) * 80;
        const hue = (baseHue + hueVariation + 360) % 360;
        const oklchColor = `oklch(${lightness.toFixed(3)} ${chroma.toFixed(3)} ${hue.toFixed(1)})`;
        colors2.push({ str: oklchColor, pos: r1 * 1e3 });
      }
      return colors2;
    }
    let colors = randomoklch(seed, 12);
    const uniqueId = seed.replace(/[^a-zA-Z0-9]/g, "_");
    $$renderer2.push(`<svg width="120%" height="120%" viewBox="0 -100 1171 241" fill="none"><defs><filter${attr("id", `noiseFilter_${stringify(uniqueId)}`)} x="0%" y="0%" width="100%" height="100%"><feTurbulence baseFrequency="0.9" numOctaves="3" seed="5" stitchTiles="stitch"></feTurbulence></filter><filter${attr("id", `mainBlur_${stringify(uniqueId)}`)} x="-20%" y="-50%" width="140%" height="200%"><feGaussianBlur stdDeviation="45" result="blur"></feGaussianBlur><feBlend mode="normal" in="blur" in2="BackgroundImageFix"></feBlend></filter><radialGradient${attr("id", `grad1_${stringify(uniqueId)}`)} cx="50%" cy="30%" r="60%"><stop offset="0%"${attr("stop-color", colors[0].str)}></stop><stop offset="40%"${attr("stop-color", colors[1].str)}></stop><stop offset="100%"${attr("stop-color", colors[2].str)}></stop></radialGradient><radialGradient${attr("id", `grad2_${stringify(uniqueId)}`)} cx="30%" cy="70%" r="70%"><stop offset="0%"${attr("stop-color", colors[3].str)}></stop><stop offset="30%"${attr("stop-color", colors[4].str)}></stop><stop offset="100%"${attr("stop-color", colors[5].str)}></stop></radialGradient><linearGradient${attr("id", `grad3_${stringify(uniqueId)}`)} x1="0%" y1="0%" x2="100%" y2="100%"><stop offset="0%"${attr("stop-color", colors[6].str)}></stop><stop offset="50%"${attr("stop-color", colors[7].str)}></stop><stop offset="100%"${attr("stop-color", colors[8].str)}></stop></linearGradient></defs><g${attr("filter", `url(#mainBlur_${stringify(uniqueId)})`)}><ellipse${attr("cx", colors[5].pos)} cy="-30" rx="300" ry="120"${attr("fill", `url(#grad1_${stringify(uniqueId)})`)} opacity="0.8"></ellipse><circle${attr("cx", colors[6].pos)} cy="-20" r="180"${attr("fill", `url(#grad2_${stringify(uniqueId)})`)} opacity="0.7"></circle><ellipse${attr("cx", colors[7].pos)} cy="10" rx="250" ry="100"${attr("fill", `url(#grad3_${stringify(uniqueId)})`)} opacity="0.6"></ellipse><circle${attr("cx", colors[8].pos)} cy="30" r="120"${attr("fill", colors[9].str)} opacity="0.5"></circle><ellipse${attr("cx", colors[9].pos)} cy="20" rx="150" ry="80"${attr("fill", colors[10].str)} opacity="0.4"></ellipse></g><rect width="100%" height="100%" fill="white" opacity="0.03"${attr("filter", `url(#noiseFilter_${stringify(uniqueId)})`)}></rect></svg>`);
  });
}
function toPersonView(personView) {
  return {
    counts: personView.counts,
    is_admin: personView.is_admin,
    person: toPerson(personView.person)
  };
}
function toPerson(person) {
  return {
    ...person,
    id: person.id,
    name: person.user_name,
    bot_account: person.bot
  };
}
function toLocalSite(site2) {
  if (site2) return {};
  return {};
}
function toCommunityView(communityView) {
  return {
    ...communityView,
    community: toCommunity(communityView.community),
    banned_from_community: false,
    counts: {
      comments: communityView.counts.post_reply_count,
      posts: communityView.counts.post_count,
      subscribers: communityView.counts.total_subscriptions_count,
      published: communityView.community.published,
      community_id: communityView.community.id,
      subscribers_local: communityView.counts.subscriptions_count,
      users_active_day: communityView.counts.active_daily ?? -1,
      users_active_half_year: communityView.counts.active_6monthly ?? -1,
      users_active_month: communityView.counts.active_monthly ?? -1,
      users_active_week: communityView.counts.active_weekly ?? -1
    }
  };
}
function toCommunity(community) {
  return {
    ...community,
    posting_restricted_to_mods: false,
    visibility: "Public"
  };
}
function toMyUser(myUser) {
  return {
    ...myUser,
    community_blocks: myUser.community_blocks.map((i) => ({
      community: toCommunity(i.community),
      person: toPerson(i.person)
    })),
    local_user_view: {
      ...myUser.local_user_view,
      // @ts-expect-error TODO make piefed sort types not explode
      local_user: {
        ...myUser.local_user_view.local_user,
        id: myUser.local_user_view.person.id,
        person_id: myUser.local_user_view.person.id,
        totp_2fa_enabled: false,
        default_listing_type: "All"
      },
      person: toPerson(myUser.local_user_view.person)
    },
    follows: myUser.follows.map((i) => ({
      follower: toPerson(i.follower),
      community: toCommunity(i.community)
    })),
    moderates: myUser.moderates.map((i) => ({
      community: toCommunity(i.community),
      moderator: toPerson(i.moderator)
    })),
    instance_blocks: myUser.instance_blocks.map((i) => ({
      instance: i.instance,
      person: toPerson(i.person)
    })),
    person_blocks: myUser.person_blocks.map((i) => ({
      person: toPerson(i.person),
      target: toPerson(i.target)
    })),
    discussion_languages: myUser.discussion_languages.map((i) => i.id)
  };
}
function toPostView(postView) {
  return {
    ...postView,
    creator: toPerson(postView.creator),
    creator_blocked: false,
    post: toPost(postView.post),
    community: toCommunity(postView.community)
  };
}
function toPost(post) {
  return {
    ...post,
    creator_id: -1,
    name: post.title,
    featured_community: post.sticky,
    featured_local: false
  };
}
function toCommentView(commentView) {
  return {
    ...commentView,
    comment: toComment(commentView.comment),
    creator: toPerson(commentView.creator),
    post: toPost(commentView.post),
    community: toCommunity(commentView.community),
    subscribed: commentView.subscribed
  };
}
function toComment(comment) {
  return {
    ...comment,
    content: comment.body,
    creator_id: -1,
    distinguished: comment.distinguished ?? false
  };
}
function toCommentReplyView(commentReplyView) {
  return {
    ...commentReplyView,
    banned_from_community: false,
    creator_banned_from_community: false,
    comment: toComment(commentReplyView.comment),
    creator: toPerson(commentReplyView.creator),
    post: toPost(commentReplyView.post),
    community: toCommunity(commentReplyView.community),
    recipient: toPerson(commentReplyView.recipient)
  };
}
function toPrivateMessageView(privateMessageView) {
  return {
    ...privateMessageView,
    creator: toPerson(privateMessageView.creator),
    recipient: toPerson(privateMessageView.recipient)
  };
}
function toPersonMentionView(personMentionView) {
  return {
    ...personMentionView,
    person_mention: personMentionView.comment_reply,
    creator_banned_from_community: false,
    banned_from_community: false,
    comment: toComment(personMentionView.comment),
    community: toCommunity(personMentionView.community),
    post: toPost(personMentionView.post),
    creator: toPerson(personMentionView.creator),
    recipient: toPerson(personMentionView.recipient)
  };
}
function toTopicView(topicView) {
  return {
    ...topicView,
    communities: topicView.communities?.map(toCommunity),
    children: topicView.children.map(toTopicView)
  };
}
function toFeedView(feedView) {
  return {
    ...feedView,
    communities: feedView.communities?.map(toCommunity),
    children: feedView.children.map(toFeedView)
  };
}
function fromGetPosts$1(getPosts) {
  return {
    ...getPosts,
    sort: toSortType(getPosts.sort),
    page: Number(getPosts.page_cursor)
  };
}
function fromGetComments(getComments) {
  return {
    ...getComments,
    sort: toCommentSortType(getComments.sort)
  };
}
function fromGetPost(getPost) {
  return getPost;
}
function fromGetReplies(getReplies) {
  return {
    ...getReplies,
    sort: toCommentSortType(getReplies.sort)
  };
}
function fromSearch(search) {
  return {
    ...search,
    sort: toSortType(search.sort)
  };
}
function fromCreatePost(createPost) {
  return {
    ...createPost,
    title: createPost.name
  };
}
function fromListCommunities(listCommunities) {
  return {
    ...listCommunities,
    sort: toCommunitiesSortType(listCommunities.sort)
  };
}
function fromCreateComment(createComment) {
  return {
    ...createComment,
    body: createComment.content
  };
}
function toSortType(sortType) {
  if (sortType == "Old" || sortType == "MostComments" || sortType == "Controversial" || sortType == "NewComments")
    sortType = "New";
  return sortType;
}
function toCommentSortType(commentSortType) {
  if (commentSortType == "Controversial") commentSortType = void 0;
  return commentSortType;
}
function toCommunitiesSortType(sortType) {
  if (sortType == "Hot" || sortType == "New" || sortType == void 0)
    return sortType;
  else return "Top";
}
class PiefedClient {
  type = { name: "piefed", baseUrl: "/api/alpha" };
  static constants = { password: { minLength: 6, maxLength: 128 } };
  #client;
  constructor(baseUrl, args) {
    this.#client = createClient({
      baseUrl,
      // @ts-expect-error i dont feel like fixing this right now
      fetch: args.fetchFunction,
      headers: args.headers
    });
  }
  async getSite() {
    const response = (await this.#client.GET("/api/alpha/site", {})).data;
    return {
      admins: response.admins.map(toPersonView),
      site_view: {
        counts: {
          comments: -1,
          communities: -1,
          posts: -1,
          site_id: -1,
          users: response.site.user_count ?? -1,
          users_active_day: -1,
          users_active_half_year: -1,
          users_active_month: -1,
          users_active_week: -1
        },
        local_site: toLocalSite(response.site),
        site: response.site
      },
      all_languages: response.site.all_languages ?? [],
      blocked_urls: [],
      custom_emojis: [],
      discussion_languages: [],
      taglines: [],
      version: response.version,
      my_user: response.my_user ? toMyUser(response.my_user) : void 0
    };
  }
  async createPost(params) {
    const response = (await this.#client.POST("/api/alpha/post", {
      body: fromCreatePost(params)
    })).data;
    return {
      post_view: toPostView(response.post_view)
    };
  }
  async getPost(params) {
    const response = (await this.#client.GET("/api/alpha/post", {
      params: { query: fromGetPost(params) }
    })).data;
    return {
      community_view: toCommunityView(response.community_view),
      cross_posts: response.cross_posts.map(toPostView),
      moderators: response.moderators.map((i) => ({
        community: toCommunity(i.community),
        moderator: toPerson(i.moderator)
      })),
      post_view: toPostView(response.post_view)
    };
  }
  async editPost(params) {
    const response = (await this.#client.PUT("/api/alpha/post", { body: params })).data;
    return {
      post_view: toPostView(response.post_view)
    };
  }
  async deletePost(params) {
    const response = (await this.#client.POST("/api/alpha/post/delete", { body: params })).data;
    return {
      post_view: toPostView(response.post_view)
    };
  }
  async removePost(params) {
    const response = (await this.#client.POST("/api/alpha/post/remove", { body: params })).data;
    return {
      post_view: toPostView(response.post_view)
    };
  }
  async getPosts(params) {
    const response = (await this.#client.GET("/api/alpha/post/list", {
      params: { query: fromGetPosts$1(params) }
    })).data;
    return {
      ...response,
      posts: response.posts.map(toPostView),
      next_page: (Number(params.page_cursor ?? 1) + 1).toString()
    };
  }
  async likePost(params) {
    const response = (await this.#client.POST("/api/alpha/post/like", {
      body: { ...params }
    })).data;
    return {
      post_view: toPostView(response.post_view)
    };
  }
  async generateTotpSecret() {
    throw new Error("unsupported");
  }
  async listLogins() {
    throw new Error("unsupported");
  }
  async listAllMedia() {
    throw new Error("unsupported");
  }
  async updateTotp() {
    throw new Error("unsupported");
  }
  async getModlog() {
    throw new Error("unsupported");
  }
  async search(params) {
    const response = (await this.#client.GET("/api/alpha/search", {
      params: {
        query: fromSearch(params)
      }
    })).data;
    return {
      comments: [],
      communities: response.communities.map(toCommunityView),
      posts: response.posts.map(toPostView),
      users: response.users.map(toPersonView),
      type_: response.type_
    };
  }
  async resolveObject(params) {
    const response = (await this.#client.GET("/api/alpha/resolve_object", {
      params: { query: params }
    })).data;
    return {
      comment: response.comment ? toCommentView(response.comment) : void 0,
      community: response.community ? toCommunityView(response.community) : void 0,
      post: response.post ? toPostView(response.post) : void 0,
      person: response.person ? toPersonView(response.person) : void 0
    };
  }
  async createCommunity(params) {
    const response = (await this.#client.POST("/api/alpha/community", { body: params })).data;
    return {
      ...response,
      community_view: toCommunityView(response.community_view)
    };
  }
  async getCommunity(params) {
    const response = (await this.#client.GET("/api/alpha/community", {
      params: {
        query: params
      }
    })).data;
    return {
      ...response,
      community_view: toCommunityView(response.community_view),
      moderators: response.moderators.map((i) => ({
        community: toCommunity(i.community),
        moderator: toPerson(i.moderator)
      }))
    };
  }
  async editCommunity(params) {
    const response = (await this.#client.PUT("/api/alpha/community", {
      body: params
    })).data;
    return {
      ...response,
      community_view: toCommunityView(response.community_view)
    };
  }
  async listCommunities(params) {
    const response = (await this.#client.GET("/api/alpha/community/list", {
      params: {
        query: fromListCommunities(params)
      }
    })).data;
    return {
      communities: response.communities.map(toCommunityView)
    };
  }
  async followCommunity(params) {
    const response = (await this.#client.POST("/api/alpha/community/follow", { body: params })).data;
    return {
      ...response,
      community_view: toCommunityView(response.community_view)
    };
  }
  async blockCommunity(params) {
    const response = (await this.#client.POST("/api/alpha/community/block", { body: params })).data;
    return {
      ...response,
      community_view: toCommunityView(response.community_view)
    };
  }
  async deleteCommunity(params) {
    const response = (await this.#client.POST("/api/alpha/community/delete", { body: params })).data;
    return {
      ...response,
      community_view: toCommunityView(response.community_view)
    };
  }
  async hideCommunity() {
    throw new Error("unsupported");
  }
  async removeCommunity() {
    throw new Error("unsupported");
  }
  async banFromCommunity(params) {
    const response = (
      // piefed has separate methods for ban/unban
      (params.ban ? await this.#client.POST("/api/alpha/community/moderate/ban", {
        body: {
          ...params,
          expiredAt: new Date(
            params.expires ?? "6767-06-07T00:00:00.000Z"
          ).toISOString(),
          user_id: params.person_id,
          reason: params.reason ?? "No reason provided."
        }
      }) : await this.#client.PUT("/api/alpha/community/moderate/unban", {
        body: {
          community_id: params.community_id,
          user_id: params.person_id
        }
      })).data
    );
    return {
      banned: params.ban,
      person_view: {
        person: toPerson(response.banned_user),
        counts: { comment_count: -1, person_id: -1, post_count: -1 },
        is_admin: false
      }
    };
  }
  async addModToCommunity(params) {
    const response = (await this.#client.POST("/api/alpha/community/mod", { body: params })).data;
    return {
      moderators: response.moderators.map((i) => ({
        community: toCommunity(i.community),
        moderator: toPerson(i.moderator)
      }))
    };
  }
  async markPostAsRead(params) {
    await this.#client.POST("/api/alpha/post/mark_as_read", {
      body: { ...params }
    });
    return {
      success: true
    };
  }
  async hidePost() {
    throw new Error("unsupported");
  }
  async lockPost(params) {
    const response = (await this.#client.POST("/api/alpha/post/lock", { body: params })).data;
    return {
      ...response,
      post_view: toPostView(response.post_view)
    };
  }
  async featurePost(params) {
    const response = (await this.#client.POST("/api/alpha/post/feature", { body: params })).data;
    return {
      ...response,
      post_view: toPostView(response.post_view)
    };
  }
  async listPostLikes(params) {
    const response = (await this.#client.GET("/api/alpha/post/like/list", {
      params: { query: params }
    })).data;
    return {
      post_likes: response.post_likes.map((i) => ({
        ...i,
        creator_banned_from_community: false,
        creator: toPerson(i.creator)
      }))
    };
  }
  async savePost(params) {
    const response = (await this.#client.PUT("/api/alpha/post/save", { body: params })).data;
    return {
      post_view: toPostView(response.post_view)
    };
  }
  async createPostReport(params) {
    const response = (await this.#client.POST("/api/alpha/post/report", { body: params })).data;
    return {
      post_report_view: {
        ...response.post_report_view,
        community: toCommunity(response.post_report_view.community),
        post: toPost(response.post_report_view.post),
        creator: toPerson(response.post_report_view.creator),
        // TODO figure out if this is a bug or not
        resolver: response.post_report_view.resolver ? toPerson(response.post_report_view.resolver) : void 0,
        post_creator: toPerson(response.post_report_view.post_creator),
        read: false,
        hidden: false,
        creator_banned_from_community: false,
        unread_comments: -1
      }
    };
  }
  async resolvePostReport() {
    throw new Error("unsupported");
  }
  async listPostReports() {
    throw new Error("unsupported");
  }
  async getSiteMetadata(params) {
    return (await this.#client.GET("/api/alpha/post/site_metadata", {
      params: { query: params }
    })).data;
  }
  async createComment(params) {
    const response = (await this.#client.POST("/api/alpha/comment", {
      body: fromCreateComment(params)
    })).data;
    return {
      ...response,
      comment_view: toCommentView(response.comment_view),
      recipient_ids: []
    };
  }
  async editComment(params) {
    const response = (await this.#client.PUT("/api/alpha/comment", {
      body: { ...params, body: params.content }
    })).data;
    return {
      comment_view: toCommentView(response.comment_view),
      recipient_ids: []
    };
  }
  async deleteComment(params) {
    const response = (await this.#client.POST("/api/alpha/comment/delete", { body: params })).data;
    return {
      comment_view: toCommentView(response.comment_view),
      recipient_ids: []
    };
  }
  async removeComment(params) {
    const response = (await this.#client.POST("/api/alpha/comment/remove", { body: params })).data;
    return {
      comment_view: toCommentView(response.comment_view),
      recipient_ids: []
    };
  }
  async markCommentReplyAsRead(params) {
    await this.#client.POST("/api/alpha/comment/mark_as_read", {
      body: params
    });
  }
  async likeComment(params) {
    const response = (await this.#client.POST("/api/alpha/comment/like", {
      body: {
        ...params,
        // TODO add private votes
        private: false
      }
    })).data;
    return {
      comment_view: toCommentView(response.comment_view),
      recipient_ids: []
    };
  }
  async listCommentLikes(params) {
    const response = (await this.#client.GET("/api/alpha/comment/like/list", {
      params: { query: params }
    })).data;
    return {
      comment_likes: response.comment_likes.map((i) => ({
        ...i,
        creator: toPerson(i.creator)
      }))
    };
  }
  async saveComment(params) {
    const response = (await this.#client.PUT("/api/alpha/comment/save", { body: params })).data;
    return {
      ...response,
      comment_view: toCommentView(response.comment_view),
      recipient_ids: []
    };
  }
  async distinguishComment() {
    throw new Error("unsupported");
  }
  async getComments(params) {
    const response = (await this.#client.GET("/api/alpha/comment/list", {
      params: { query: fromGetComments(params) }
    })).data;
    return {
      comments: response.comments.map(toCommentView)
    };
  }
  async getComment(params) {
    const response = (await this.#client.GET("/api/alpha/comment", {
      params: { query: params }
    })).data;
    return {
      ...response,
      comment_view: toCommentView(response.comment_view),
      recipient_ids: []
    };
  }
  async createCommentReport(params) {
    const response = (await this.#client.POST("/api/alpha/comment/report", {
      body: {
        ...params,
        // TODO add remote reports
        report_remote: false
      }
    })).data;
    return {
      ...response,
      comment_report_view: {
        ...response.comment_report_view,
        comment: toComment(response.comment_report_view.comment),
        community: toCommunity(response.comment_report_view.community),
        comment_creator: toPerson(response.comment_report_view.comment_creator),
        creator: toPerson(response.comment_report_view.creator),
        post: toPost(response.comment_report_view.post),
        // TODO figure out what's wrong here
        resolver: response.comment_report_view.resolver ? toPerson(response.comment_report_view.resolver) : void 0,
        subscribed: response.comment_report_view.subscribed
      }
    };
  }
  async resolveCommentReport() {
    throw new Error("unsupported");
  }
  async listCommentReports() {
    throw new Error("unsupported");
  }
  async getPrivateMessages(params) {
    const response = (await this.#client.GET("/api/alpha/private_message/list", {
      params: { query: params }
    })).data;
    return {
      private_messages: response.private_messages.map(toPrivateMessageView)
    };
  }
  async createPrivateMessage(params) {
    const response = (await this.#client.POST("/api/alpha/private_message", { body: params })).data;
    return {
      ...response,
      private_message_view: toPrivateMessageView(response.private_message_view)
    };
  }
  async editPrivateMessage(params) {
    const response = (await this.#client.PUT("/api/alpha/private_message", { body: params })).data;
    return {
      ...response,
      private_message_view: toPrivateMessageView(response.private_message_view)
    };
  }
  async deletePrivateMessage(params) {
    const response = (await this.#client.POST("/api/alpha/private_message/delete", {
      body: params
    })).data;
    return {
      ...response,
      private_message_view: toPrivateMessageView(response.private_message_view)
    };
  }
  async markPrivateMessageAsRead(params) {
    const response = (await this.#client.POST("/api/alpha/private_message/mark_as_read", {
      body: params
    })).data;
    return {
      ...response,
      private_message_view: toPrivateMessageView(response.private_message_view)
    };
  }
  async createPrivateMessageReport() {
    throw new Error("unsupported");
  }
  async resolvePrivateMessageReport() {
    throw new Error("unsupported");
  }
  async listPrivateMessageReports() {
    throw new Error("unsupported");
  }
  async register() {
    throw new Error("unsupported");
  }
  async login(params) {
    const response = await this.#client.POST("/api/alpha/user/login", {
      body: { username: params.username_or_email, password: params.password }
    });
    return {
      verify_email_sent: false,
      registration_created: false,
      jwt: response.data?.jwt
    };
  }
  async logout() {
    throw new Error("unsupported");
  }
  async getPersonDetails(params) {
    const response = (await this.#client.GET("/api/alpha/user", {
      params: {
        query: {
          ...params,
          include_content: true,
          sort: toSortType(params.sort)
        }
      }
    })).data;
    return {
      comments: response.comments.map(toCommentView),
      moderates: response.moderates.map((i) => ({
        community: toCommunity(i.community),
        moderator: toPerson(i.moderator)
      })),
      person_view: toPersonView(response.person_view),
      posts: response.posts.map(toPostView)
    };
  }
  async getPersonMentions(params) {
    const response = (await this.#client.GET("/api/alpha/user/mentions", {
      params: { query: { ...params, sort: toCommentSortType(params.sort) } }
    })).data;
    return {
      mentions: response.replies.map(toPersonMentionView)
    };
  }
  async markPersonMentionAsRead(params) {
    await this.#client.POST("/api/alpha/mention/mark_as_read", {
      body: params
    });
  }
  async getReplies(params) {
    const response = (await this.#client.GET("/api/alpha/user/replies", {
      params: { query: fromGetReplies(params) }
    })).data;
    return {
      replies: response.replies.map(toCommentReplyView)
    };
  }
  async banPerson() {
    throw new Error("unsupported");
  }
  async getBannedPersons() {
    throw new Error("unsupported");
  }
  async blockPerson(params) {
    const response = (await this.#client.POST("/api/alpha/user/block", { body: params })).data;
    return {
      ...response,
      person_view: toPersonView(response.person_view)
    };
  }
  async getCaptcha() {
    throw new Error("unsupported");
  }
  async deleteAccount() {
    throw new Error("unsupported");
  }
  async passwordReset() {
    throw new Error("unsupported");
  }
  async passwordChangeAfterReset() {
    throw new Error("unsupported");
  }
  async markAllAsRead() {
    const response = (await this.#client.POST("/api/alpha/user/mark_all_as_read")).data;
    return {
      replies: response.replies.map(toCommentReplyView)
    };
  }
  async saveUserSettings(params) {
    await this.#client.PUT("/api/alpha/user/save_user_settings", {
      body: params
    });
    return {
      success: true
    };
  }
  async changePassword() {
    throw new Error("unsupported");
  }
  async getReportCount() {
    throw new Error("unsupported");
  }
  async getUnreadCount() {
    return (await this.#client.GET("/api/alpha/user/unread_count")).data;
  }
  async verifyEmail() {
    throw new Error("unsupported");
  }
  async addAdmin() {
    throw new Error("unsupported");
  }
  async getUnreadRegistrationApplicationCount() {
    throw new Error("unsupported");
  }
  async listRegistrationApplications() {
    throw new Error("unsupported");
  }
  async approveRegistrationApplication() {
    throw new Error("unsupported");
  }
  async getRegistrationApplication() {
    throw new Error("unsupported");
  }
  async purgePerson() {
    throw new Error("unsupported");
  }
  async purgeCommunity() {
    throw new Error("unsupported");
  }
  async purgePost() {
    throw new Error("unsupported");
  }
  async purgeComment() {
    throw new Error("unsupported");
  }
  async getFederatedInstances() {
    return (await this.#client.GET("/api/alpha/federated_instances")).data;
  }
  async blockInstance(params) {
    return (await this.#client.POST("/api/alpha/site/block", {
      body: { ...params }
    })).data;
  }
  async uploadImage(params) {
    const formData = new FormData();
    formData.append("file", params.image);
    const response = (await this.#client.POST("/api/alpha/upload/image", {
      // @ts-expect-error this is the only working way to do this
      body: formData
    })).data;
    return {
      ...response,
      msg: "yeah it worked i think"
    };
  }
  async setFlair(params) {
    const response = (await this.#client.POST("/api/alpha/user/set_flair", { body: params })).data;
    return toPersonView(response.person_view);
  }
  async editSite() {
    throw new Error("unsupported");
  }
  async deleteImage() {
    throw new Error("unsupported");
  }
  async getFeeds(params) {
    const response = (await this.#client.GET("/api/alpha/feed/list", {
      params: { query: params }
    })).data;
    return {
      ...response,
      feeds: response.feeds.map(toFeedView)
    };
  }
  async getTopics(params) {
    const response = (await this.#client.GET("/api/alpha/topic/list", {
      params: { query: params }
    })).data;
    return {
      ...response,
      topics: response.topics.map(toTopicView)
    };
  }
  async assignFlair(params) {
    const response = (await this.#client.POST("/api/alpha/post/assign_flair", {
      body: params
    })).data;
    return toPostView(response);
  }
  async listMedia() {
    throw new Error("unsupported");
  }
  async voteOnPoll(params) {
    const response = (await this.#client.POST("/api/alpha/post/poll_vote", { body: params })).data;
    return toPostView(response.post_view);
  }
  async setNote(params) {
    const response = (await this.#client.POST("/api/alpha/user/note", { body: params })).data;
    return toPersonView(response.person_view);
  }
}
const youtubeDomain = (place) => {
  switch (place) {
    case "youtube": {
      return "www.youtube-nocookie.com";
    }
    case "invidious": {
      return settings.embeds.invidious || "yewtu.be";
    }
    case "piped": {
      return settings.embeds.piped || "piped.video";
    }
  }
};
function youtubeVideoID(url) {
  const regex = /^(?:https?:\/\/)?(?:www\.|m\.)?(?:youtu\.be\/|youtube\.com\/(?:embed\/|shorts\/|live\/|v\/|watch\?v=|watch\?.+&v=))((\w|-){11})(?:\S+)?$/;
  const match = url.match(regex);
  if (match && match[1]) {
    return match[1];
  }
  return null;
}
function PostIframe($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const urlToEmbed = (inputUrl) => {
      if (type == "video") {
        return inputUrl;
      }
      if (type == "youtube") {
        const url2 = new URL(inputUrl);
        const videoID = youtubeVideoID(inputUrl);
        if (videoID) {
          const embedUrl2 = new URL(`https://${youtubeDomain(settings.embeds.youtube)}/embed/${videoID}`);
          embedUrl2.searchParams.set("start", url2.searchParams.get("t") ?? "");
          url2.searchParams.forEach((value, key) => {
            embedUrl2.searchParams.set(key, value);
          });
          if (autoplay) embedUrl2.searchParams.set("autoplay", "1");
          return embedUrl2.toString();
        }
      }
      return "";
    };
    const typeData = (type2) => {
      switch (type2) {
        case "youtube": {
          return { icon: VideoCamera, text: "YouTube Video" };
        }
        case "video": {
          return { icon: VideoCamera, text: "Video" };
        }
        default: {
          return { icon: PuzzlePiece, text: "Embed" };
        }
      }
    };
    let {
      type = "none",
      thumbnail = void 0,
      url,
      title,
      opened = !settings.embeds.clickToView,
      autoplay = settings.embeds.clickToView
    } = $$props;
    let data = typeData(type);
    let embedUrl = urlToEmbed(url);
    $$renderer2.push(`<div class="iframe-container svelte-1d4prf0">`);
    if (opened) {
      $$renderer2.push("<!--[-->");
      if (type == "video") {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<video${attr("autoplay", autoplay, true)} controls class="svelte-1d4prf0"><source${attr("src", url)}/></video>`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<iframe${attr("src", embedUrl)} title="Embed player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen class="svelte-1d4prf0"></iframe>`);
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<button class="iframe-preview svelte-1d4prf0"><div role="presentation" class="preview-start svelte-1d4prf0"><div class="start-button svelte-1d4prf0">`);
      Icon($$renderer2, { src: Play, size: "32", mini: true });
      $$renderer2.push(`<!----></div></div> `);
      if (thumbnail) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<img${attr("src", optimizeImageURL(thumbnail, 512))} class="absolute top-0 left-0 -z-10 w-full object-cover h-full mask-b-from-0 brightness-75" alt=""/>`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<div class="absolute inset-0 w-full h-full scale-200 -z-10 opacity-50">`);
        Blobs($$renderer2, { seed: title ?? data.text });
        $$renderer2.push(`<!----></div>`);
      }
      $$renderer2.push(`<!--]--> `);
      Icon($$renderer2, { src: data.icon, solid: true, size: "40" });
      $$renderer2.push(`<!----> <h1 class="font-display text-xl md:text-2xl xl:text-3xl font-medium text-left overflow-hidden overflow-ellipsis line-clamp-2">${escape_html(title ?? data.text)}</h1> <div class="text-slate-600 dark:text-zinc-400">${escape_html(URL.parse?.(url)?.hostname ?? data.text)}</div></button>`);
    }
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, { opened });
  });
}
class InstanceData {
  #instance = derived(() => profile.current.instance);
  get data() {
    return this.#instance() ?? DEFAULT_INSTANCE_URL;
  }
}
const instance = new InstanceData();
const LINKED_INSTANCE_URL = (public_env.PUBLIC_LOCK_TO_INSTANCE ?? "true").toLowerCase() == "true" ? public_env.PUBLIC_INSTANCE_URL : void 0;
const getDefaultInstance = () => {
  {
    return public_env.PUBLIC_INTERNAL_INSTANCE || public_env.PUBLIC_INSTANCE_URL || "lemdro.id";
  }
};
const DEFAULT_INSTANCE_URL = getDefaultInstance();
function MdImage($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let loaded = getContext("options")?.autoloadImages ?? true;
    let { href, title = void 0, text = "" } = $$props;
    let type = mediaType(href);
    $$renderer2.push(`<div class="w-auto h-auto max-h-96 rounded-2xl border border-slate-200 dark:border-zinc-800 inline-block group">`);
    if (loaded) {
      $$renderer2.push("<!--[-->");
      if (type == "video" || type == "embed" || type == "iframe") {
        $$renderer2.push("<!--[-->");
        PostIframe($$renderer2, {
          type: iframeType(href),
          url: href,
          opened: true,
          autoplay: false,
          class: "w-auto h-auto max-h-80 inline-block rounded-[inherit] cursor-pointer"
        });
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<button class="inline cursor-pointer bg-slate-200 dark:bg-zinc-900 rounded-[inherit]"><img${attr("src", optimizeImageURL(href, 1024))}${attr("title", title)}${attr("alt", text)}${attr("width", 300)}${attr("height", 300)}${attr_class(clsx([
          "object-contain w-auto h-auto max-h-80 inline rounded-[inherit] group-hover:scale-98 group-active:scale-95",
          "transition-transform ease-cubic duration-300"
        ]))}/></button>`);
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<button class="w-40 h-40 flex flex-col justify-center items-center gap-4 p-2 group cursor-pointer"${attr("title", store_get($$store_subs ??= {}, "$t", t)("common.download"))}>`);
      Icon($$renderer2, {
        src: ArrowDownTray,
        size: "24",
        class: "text-primary-900 dark:text-primary-100"
      });
      $$renderer2.push(`<!----></button>`);
    }
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function MdLink($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { href = "", title = void 0, children } = $$props;
    const parseURL = (href2) => {
      try {
        return new URL(href2);
      } catch {
        return void 0;
      }
    };
    let photonified = photonify(href);
    $$renderer2.push(`<a${attr("href", photonified ?? href)}${attr("title", title)} class="hover:underline text-blue-600 dark:text-blue-400">`);
    children?.($$renderer2);
    $$renderer2.push(`<!----></a>`);
    bind_props($$props, { parseURL });
  });
}
function MdList($$renderer, $$props) {
  let { ordered, start, children } = $$props;
  if (ordered) {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<ol${attr("start", start)} class="pl-5 list-decimal">`);
    children?.($$renderer);
    $$renderer.push(`<!----></ol>`);
  } else {
    $$renderer.push("<!--[!-->");
    $$renderer.push(`<ul class="list-disc pl-8 *:marker:content-['• ']!">`);
    children?.($$renderer);
    $$renderer.push(`<!----></ul>`);
  }
  $$renderer.push(`<!--]-->`);
}
function MdListItem($$renderer, $$props) {
  let { children } = $$props;
  $$renderer.push(`<li class="svelte-1o0y3jo">`);
  children?.($$renderer);
  $$renderer.push(`<!----></li>`);
}
function MdParagraph($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { children } = $$props;
    const options = getContext("options");
    $$renderer2.push(`<p${attr_class(clsx([!options.noStyle && "leading-[1.7] break-words max-w"]), "svelte-g7db9n")}>`);
    children?.($$renderer2);
    $$renderer2.push(`<!----></p>`);
  });
}
function MdQuote($$renderer, $$props) {
  let { children } = $$props;
  $$renderer.push(`<blockquote class="flex flex-col gap-2 border-l-2 dark:border-zinc-700 border-slate-300 p-1 px-3">`);
  children?.($$renderer);
  $$renderer.push(`<!----></blockquote>`);
}
function MdSpoiler($$renderer, $$props) {
  let { raw, children } = $$props;
  function extractTitle(text) {
    const spoilerRegex = /^::: ?spoiler (.+)\n([\s\S]+?)\n:::/gm;
    const result = spoilerRegex.exec(text);
    if (!result?.[1] || !result?.[2]) return { title: "parsing error", content: "parsing error" };
    return { title: result[1], content: result[2] };
  }
  let data = extractTitle(raw);
  {
    let title = function($$renderer2) {
      $$renderer2.push(`<div class="text-left">${escape_html(data.title)}</div>`);
    };
    Expandable($$renderer, {
      class: "border-y border-slate-200 dark:border-zinc-800 py-2",
      title,
      children: ($$renderer2) => {
        children?.($$renderer2);
        $$renderer2.push(`<!---->`);
      },
      $$slots: { title: true, default: true }
    });
  }
}
function MdSubscript($$renderer, $$props) {
  let { text } = $$props;
  $$renderer.push(`<sub>${escape_html(text)}</sub>`);
}
function MdSuperscript($$renderer, $$props) {
  let { text } = $$props;
  $$renderer.push(`<sup>${escape_html(text)}</sup>`);
}
function MdText($$renderer, $$props) {
  let { children } = $$props;
  children?.($$renderer);
  $$renderer.push(`<!---->`);
}
function containerExtension(tokensExtractor) {
  return {
    name: "container",
    level: "block",
    start(src) {
      return src.match(/:::[^:\n]/)?.index;
    },
    tokenizer(src) {
      const rule = /:::[\s]?(?<type>[a-z0-9-]+)(?<options>.*)?\n(?<content>(?:.|\n)*)\n:::(?:\n)*/i;
      const match = rule.exec(findRawContainer(src));
      if (!match || !match.groups) return null;
      const type = match.groups.type.toLocaleLowerCase();
      const options = parseOptions(match.groups.options || "");
      const content = match.groups.content || "";
      const result = tokensExtractor({
        type,
        content,
        raw: match[0],
        options,
        lexer: this.lexer
      });
      if (result?.tokens) {
        this.lexer.blockTokens(content, result.tokens);
      }
      return result;
    }
  };
}
function findRawContainer(src) {
  if (!src.startsWith(":::")) return void 0;
  const lines = src.split("\n");
  let open = 1;
  let lineNumber = 1;
  for (lineNumber = 1; lineNumber < lines.length; lineNumber++) {
    const line = lines[lineNumber];
    if (line.startsWith(":::")) {
      if (/:::[^:\n\s]/.test(line)) {
        open++;
      } else if (/^:::(\n|$)/.test(line)) {
        open -= 1;
      }
    }
    if (open === 0) {
      break;
    }
  }
  return lines.slice(0, lineNumber + 1).join("\n");
}
function parseOptions(options) {
  const output = {};
  let remaining = options;
  while (true) {
    const regex = /(?<name>[a-z0-9]+)(?:="(?<value>(?:.*?))")?/i;
    const match = regex.exec(remaining);
    if (!match) break;
    const name = match?.groups?.name;
    if (name) {
      output[name] = match?.groups?.value ?? true;
    }
    remaining = remaining.slice(match.index + match[0].length);
  }
  return output;
}
function MdCodespan($$renderer, $$props) {
  let { children } = $$props;
  $$renderer.push(`<code>`);
  children?.($$renderer);
  $$renderer.push(`<!----></code>`);
}
function MdDel($$renderer, $$props) {
  let { children } = $$props;
  $$renderer.push(`<del>`);
  children?.($$renderer);
  $$renderer.push(`<!----></del>`);
}
function MdEm($$renderer, $$props) {
  let { children } = $$props;
  $$renderer.push(`<em>`);
  children?.($$renderer);
  $$renderer.push(`<!----></em>`);
}
function MdStrong($$renderer, $$props) {
  let { children } = $$props;
  $$renderer.push(`<strong>`);
  children?.($$renderer);
  $$renderer.push(`<!----></strong>`);
}
function MdTable($$renderer, $$props) {
  let { children } = $$props;
  $$renderer.push(`<div class="overflow-auto w-full table-container svelte-cqfp8m"><table class="w-full table-fixed rounded-xl min-w-md svelte-cqfp8m">`);
  children?.($$renderer);
  $$renderer.push(`<!----></table></div>`);
}
function MdTableBody($$renderer, $$props) {
  let { children } = $$props;
  $$renderer.push(`<tbody>`);
  children?.($$renderer);
  $$renderer.push(`<!----></tbody>`);
}
function MdTableCell($$renderer, $$props) {
  let { header, align = void 0, children } = $$props;
  if (header) {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<th${attr("align", align)}>`);
    children?.($$renderer);
    $$renderer.push(`<!----></th>`);
  } else {
    $$renderer.push("<!--[!-->");
    $$renderer.push(`<td${attr("align", align)}>`);
    children?.($$renderer);
    $$renderer.push(`<!----></td>`);
  }
  $$renderer.push(`<!--]-->`);
}
function MdTableHead($$renderer, $$props) {
  let { children } = $$props;
  $$renderer.push(`<thead>`);
  children?.($$renderer);
  $$renderer.push(`<!----></thead>`);
}
function MdTableRow($$renderer, $$props) {
  let { children } = $$props;
  $$renderer.push(`<tr>`);
  children?.($$renderer);
  $$renderer.push(`<!----></tr>`);
}
function preprocess(src) {
  return src.replaceAll(/\[([^\]]*)\]\(\s*javascript:[^)]*\)/gim, "*link removed*").replaceAll(/^\s*\[[^\]]+\]:\s*javascript:.*$/gim, "*link removed*");
}
marked.setOptions({ gfm: true, breaks: false });
marked.use(linkify, {
  extensions: [
    containerExtension((params) => {
      if (params.type == "spoiler") {
        return {
          type: "spoiler",
          raw: params.raw,
          title: params.options,
          tokens: []
        };
      }
      return null;
    }),
    subSupscriptExtension((params) => {
      if (params.type == "subscript") {
        return { type: "subscript", raw: params.raw, text: params.content };
      }
      if (params.type == "superscript") {
        return { type: "superscript", raw: params.raw, text: params.content };
      }
      return null;
    })
  ]
});
const renderers = {
  heading: MdHeading,
  image: MdImage,
  link: MdLink,
  blockquote: MdQuote,
  hr: MdHr,
  html: MdHtml,
  code: MdCode,
  list: MdList,
  spoiler: MdSpoiler,
  table: MdTable,
  tablebody: MdTableBody,
  tablecell: MdTableCell,
  tablehead: MdTableHead,
  tablerow: MdTableRow,
  paragraph: MdParagraph,
  listitem: MdListItem,
  subscript: MdSubscript,
  superscript: MdSuperscript,
  space: MdParagraph,
  list_item: MdListItem,
  text: MdText,
  em: MdEm,
  strong: MdStrong,
  del: MdDel,
  codespan: MdCodespan
};
const inlineRenderers = {
  paragraph: MdParagraph,
  subscript: MdSubscript,
  superscript: MdSuperscript,
  text: MdText,
  link: MdLink,
  em: MdEm,
  strong: MdStrong,
  del: MdDel,
  codespan: MdCodespan
};
function Markdown($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      source = "",
      inline = false,
      noStyle = false,
      style = "",
      class: clazz = "",
      rendererOptions = { autoloadImages: true }
    } = $$props;
    setContext("options", { ...rendererOptions, inline, noStyle });
    let tokens = marked.lexer(preprocess(source));
    element(
      $$renderer2,
      inline ? "div" : "article",
      () => {
        $$renderer2.push(` dir="auto"${attr_class(clsx([!noStyle && "break-words space-y-4 leading-normal", clazz]))}${attr_style(style)}`);
      },
      () => {
        MdTree($$renderer2, { tokens, renderers: inline ? inlineRenderers : renderers });
      }
    );
  });
}
const toastColors = {
  error: "material-error",
  warning: "material-warning",
  success: "material-success",
  info: "material-info"
};
const toasts = writable([]);
function toast({
  title,
  content,
  type = "info",
  duration = 5e3,
  loading = false,
  long = false,
  action
}) {
  let id = 0;
  toasts.update((toasts2) => {
    id = Math.max(0, ...toasts2.map((t2) => t2.id)) + 1;
    return [
      ...toasts2,
      {
        id,
        content,
        title,
        type,
        loading,
        long,
        action
      }
    ];
  });
  setTimeout(() => {
    toasts.update((toasts2) => toasts2.filter((toast2) => toast2.id != id));
  }, duration);
  return id;
}
const removeToast = (id) => toasts.update((toasts2) => toasts2.filter((toast2) => toast2.id != id));
function Badge($$renderer, $$props) {
  const badgeColor = {
    "red-subtle": "bg-red-100 dark:bg-red-500/20 text-red-600 dark:text-red-400",
    "green-subtle": `bg-green-100 dark:bg-green-500/20 text-green-700 dark:text-green-400`,
    "yellow-subtle": "bg-yellow-100 dark:bg-yellow-500/20 text-yellow-700 dark:text-yellow-400",
    "gray-subtle": "bg-gray-100 dark:bg-gray-500/20 text-gray-700 dark:text-gray-300",
    "blue-subtle": "bg-blue-100 dark:bg-blue-500/20 text-blue-700 dark:text-blue-300",
    custom: ""
  };
  const badgeRoundness = { full: "rounded-full", md: "rounded-md", custom: "" };
  let {
    label = "",
    color = "gray-subtle",
    rounding = "full",
    allowIconOnly = false,
    class: clazz = "",
    icon,
    children,
    $$slots,
    $$events,
    ...rest
  } = $$props;
  $$renderer.push(`<span${attributes({
    ...rest,
    class: clsx([
      allowIconOnly && "max-md:px-1.5 max-md:py-1.5",
      "text-xs font-medium flex items-center gap-1 ring-1 ring-black/20 dark:ring-white/20 ring-inset px-2 py-1",
      badgeRoundness[rounding],
      badgeColor[color],
      clazz
    ]),
    title: label
  })}>`);
  icon?.($$renderer);
  $$renderer.push(`<!----> <span${attr_class(clsx(allowIconOnly ? "sr-only md:contents" : "contents"))}>`);
  children?.($$renderer);
  $$renderer.push(`<!----></span></span>`);
}
function getFromStorage(key) {
  return;
}
const getCookie = (key) => {
  return void 0;
};
class Profile {
  static DONATION_CHECK_TIMEOUT = 3 * 1e3;
  static DONATION_REMINDER_INTERVAL = 375 * 24 * 60 * 60 * 1e3;
  meta = getFromStorage() ?? {
    profiles: [
      {
        id: 1,
        instance: DEFAULT_INSTANCE_URL,
        username: "Guest",
        color: "#505050",
        client: DEFAULT_CLIENT_TYPE
      }
    ],
    profile: 1
  };
  #current = derived(() => this.meta.profiles.find((i) => i.id == this.meta.profile) ?? this.getDefaultProfile());
  #client = derived(() => client({
    auth: this.#current().jwt,
    clientType: this.#current().client,
    instanceURL: this.#current().instance
  }));
  get client() {
    return this.#client();
  }
  set client($$value) {
    return this.#client($$value);
  }
  inbox = new InboxService(this);
  getDefaultProfile() {
    return {
      id: -1,
      instance: DEFAULT_INSTANCE_URL,
      client: DEFAULT_CLIENT_TYPE
    };
  }
  constructor() {
    this.initCookieMigrate();
    this.donationPoll(Profile.DONATION_CHECK_TIMEOUT);
  }
  get current() {
    return this.#current();
  }
  set current(value) {
    if (!value) return;
    const index = this.meta.profiles.findLastIndex((i) => i.id === value.id);
    if (index != -1) this.meta.profiles[index] = value;
  }
  async initCookieMigrate() {
    if (!(public_env.PUBLIC_MIGRATE_COOKIE && this.meta.profiles.length == 0 && public_env.PUBLIC_INSTANCE_URL)) return;
    const jwt = getCookie();
    if (!jwt) return;
    const result = await this.add(jwt, public_env.PUBLIC_INSTANCE_URL ?? "", DEFAULT_CLIENT_TYPE);
    if (result) toast({
      content: "Your instance migrated frontends, and your account was transferred.",
      type: "success"
    });
  }
  donationPoll(delay) {
    return setTimeout(
      () => {
        if (profile.current.user?.local_user_view.local_user.last_donation_notification) {
          const donationDate = publishedToDate(profile.current.user?.local_user_view.local_user.last_donation_notification);
          if (Date.now() - donationDate.getTime() > Profile.DONATION_REMINDER_INTERVAL) {
            toast({
              content: t.get("toast.lemmyDonate"),
              duration: 3600 * 1e3,
              long: true
            });
            fetch(`${instanceToURL(profile.current.instance)}/api/v3/user/donation_dialog_shown`, {
              method: "POST",
              headers: { authorization: `Bearer ${profile.current.jwt}` }
            });
          }
        }
      },
      delay
    );
  }
  async fetchUserData() {
    const startId = this.#current().id;
    if (this.#current().jwt) {
      site.data = void 0;
      const res = await userFromJwt(this.#current().jwt, this.#current().instance, this.#current().client);
      if (!res?.user) toast({
        content: "Your account's instance did not return your user data. Your login may have expired.",
        type: "error"
      });
      if (this.#current().id != startId) {
        console.error("profile was switched too fast, ID mismatch");
        return;
      }
      site.data = res?.site;
      this.#current().user = res?.user;
      if (profile.current.user) {
        this.#current().avatar = res?.user?.local_user_view.person.avatar;
        this.#current().username = res?.user?.local_user_view.person.name;
      }
      this.inbox.init();
    }
    return this;
  }
  async add(jwt, instance2, type) {
    try {
      const user = await userFromJwt(jwt, instance2, type);
      if (!user?.user) {
        throw new Error("No user data received");
      }
      const id = Math.max(...this.meta.profiles.map((p) => p.id), 0) + 1;
      this.meta.profiles.unshift({
        id,
        instance: instance2,
        jwt,
        username: user.user.local_user_view.person.name,
        avatar: user.user.local_user_view.person.avatar,
        client: type
      });
      this.meta.profile = id;
      return user;
    } catch (err) {
      toast({ content: errorMessage(err), type: "error" });
      return null;
    }
  }
  remove(id) {
    this.meta.profiles.splice(this.meta.profiles.findIndex((p) => p.id == id), 1);
    if (id == this.meta.profile) this.meta.profile = -1;
  }
  move(id, up) {
    try {
      const index = this.meta.profiles.findIndex((i) => i.id == id);
      this.meta.profiles = moveItem(this.meta.profiles, index, index + (up ? -1 : 1));
    } catch {
    }
  }
  isMod(community) {
    if (community) return (this.#current().user?.moderates.some((i) => i.community.id == community.id) || community.local && this.isAdmin) ?? false;
    else return (this.#current().user?.moderates.length ?? 0) > 0;
  }
  get isAdmin() {
    return site.data?.admins.some((i) => i.person.id == this.#current().user?.local_user_view.person.id) ?? false;
  }
  get isDefaultProfile() {
    return !this.#current().jwt && this.#current().instance == DEFAULT_INSTANCE_URL;
  }
  mainEffect = () => {
  };
}
class InboxService {
  POLL_INTERVAL = 4 * 60 * 1e3;
  #pollInterval = null;
  #profile;
  notifications = { applications: 0, inbox: 0, reports: 0 };
  constructor(profile2) {
    this.#profile = profile2;
  }
  async init() {
    this.cleanup();
    this.notifications = await this.checkInbox();
    this.#pollInterval = setInterval(
      async () => {
        this.notifications = await this.checkInbox();
      },
      this.POLL_INTERVAL
    );
  }
  cleanup() {
    if (this.#pollInterval) clearInterval(this.#pollInterval);
    this.#pollInterval = null;
  }
  clear() {
    this.notifications = { applications: 0, inbox: 0, reports: 0 };
    return this.notifications;
  }
  async checkInbox() {
    if (!this.#profile.current.user || !this.#profile.current.jwt) return this.clear();
    const unreadsPromise = client().getUnreadCount().then((res) => res.mentions + res.private_messages + res.replies).catch(() => 0);
    const reportsPromise = this.#profile.isMod() ? client().getReportCount({}).then((res) => res.comment_reports + res.post_reports + (res.private_message_reports ?? 0)).catch(() => 0) : new Promise((res) => res(0));
    const applicationsPromise = this.#profile.isAdmin ? client().getUnreadRegistrationApplicationCount().then((res) => res.registration_applications).catch(() => 0) : new Promise((res) => res(0));
    const [unreads, reports, applications] = await Promise.all([unreadsPromise, reportsPromise, applicationsPromise]);
    return { inbox: unreads, reports, applications };
  }
}
const profile = new Profile();
async function userFromJwt(jwt, instance2, type) {
  const sitePromise = client({ instanceURL: instance2, auth: jwt, clientType: type }).getSite();
  const timer = setTimeout(
    () => toast({
      content: `Still loading your user data...`,
      type: "warning",
      loading: true
    }),
    5e3
  );
  const site2 = await sitePromise.then((r) => {
    clearTimeout(timer);
    return r;
  }).catch((e) => {
    toast({ content: `Failed to contact the instance. ${e}` });
  });
  if (!site2) return;
  const myUser = site2.my_user;
  return { user: myUser, site: site2 };
}
function fromGetPosts(getPosts) {
  return {
    ...getPosts,
    type_: getPosts.type_ == "Popular" ? "All" : getPosts.type_
  };
}
function toListingType(listingType) {
  if (listingType == "Popular") listingType = "All";
  return listingType;
}
class LemmyClient {
  type = { name: "lemmy", baseUrl: "/api/v3" };
  static constants = { password: { minLength: 8, maxLength: 60 } };
  #client;
  constructor(baseUrl, args) {
    this.#client = new LemmyHttp(baseUrl, args);
  }
  async getSite(...params) {
    return await this.#client.getSite(...params);
  }
  async generateTotpSecret(...params) {
    return await this.#client.generateTotpSecret(...params);
  }
  async listLogins(...params) {
    return await this.#client.listLogins(...params);
  }
  async listAllMedia(...params) {
    return await this.#client.listAllMedia(...params);
  }
  async updateTotp(...params) {
    return await this.#client.updateTotp(...params);
  }
  async getModlog(...params) {
    return await this.#client.getModlog(...params);
  }
  async search(params) {
    return await this.#client.search({
      ...params,
      listing_type: toListingType(params.listing_type)
    });
  }
  async resolveObject(...params) {
    return await this.#client.resolveObject(...params);
  }
  async createCommunity(...params) {
    return await this.#client.createCommunity(...params);
  }
  async getCommunity(...params) {
    return await this.#client.getCommunity(...params);
  }
  async editCommunity(...params) {
    return await this.#client.editCommunity(...params);
  }
  async listCommunities(params) {
    return await this.#client.listCommunities({
      ...params,
      type_: toListingType(params.type_)
    });
  }
  async followCommunity(...params) {
    return await this.#client.followCommunity(...params);
  }
  async blockCommunity(...params) {
    return await this.#client.blockCommunity(...params);
  }
  async deleteCommunity(...params) {
    return await this.#client.deleteCommunity(...params);
  }
  async hideCommunity(...params) {
    return await this.#client.hideCommunity(...params);
  }
  async removeCommunity(...params) {
    return await this.#client.removeCommunity(...params);
  }
  async banFromCommunity(...params) {
    return await this.#client.banFromCommunity(...params);
  }
  async addModToCommunity(...params) {
    return await this.#client.addModToCommunity(...params);
  }
  async createPost(...params) {
    return await this.#client.createPost(...params);
  }
  async getPost(...params) {
    return await this.#client.getPost(...params);
  }
  async editPost(...params) {
    return await this.#client.editPost(...params);
  }
  async deletePost(...params) {
    return await this.#client.deletePost(...params);
  }
  async removePost(...params) {
    return await this.#client.removePost(...params);
  }
  async markPostAsRead(...params) {
    return await this.#client.markPostAsRead(...params);
  }
  async hidePost(...params) {
    return await this.#client.hidePost(...params);
  }
  async lockPost(...params) {
    return await this.#client.lockPost(...params);
  }
  async featurePost(...params) {
    return await this.#client.featurePost(...params);
  }
  async getPosts(params) {
    return await this.#client.getPosts(fromGetPosts(params));
  }
  async likePost(...params) {
    return await this.#client.likePost(...params);
  }
  async listPostLikes(...params) {
    return await this.#client.listPostLikes(...params);
  }
  async savePost(...params) {
    return await this.#client.savePost(...params);
  }
  async createPostReport(...params) {
    return await this.#client.createPostReport(...params);
  }
  async resolvePostReport(...params) {
    return await this.#client.resolvePostReport(...params);
  }
  async listPostReports(...params) {
    return await this.#client.listPostReports(...params);
  }
  async getSiteMetadata(...params) {
    return await this.#client.getSiteMetadata(...params);
  }
  async createComment(...params) {
    return await this.#client.createComment(...params);
  }
  async editComment(...params) {
    return await this.#client.editComment(...params);
  }
  async deleteComment(...params) {
    return await this.#client.deleteComment(...params);
  }
  async removeComment(...params) {
    return await this.#client.removeComment(...params);
  }
  async markCommentReplyAsRead(...params) {
    return await this.#client.markCommentReplyAsRead(...params);
  }
  async likeComment(...params) {
    return await this.#client.likeComment(...params);
  }
  async listCommentLikes(...params) {
    return await this.#client.listCommentLikes(...params);
  }
  async saveComment(...params) {
    return await this.#client.saveComment(...params);
  }
  async distinguishComment(...params) {
    return await this.#client.distinguishComment(...params);
  }
  async getComments(params) {
    return await this.#client.getComments({
      ...params,
      type_: toListingType(params.type_)
    });
  }
  async getComment(...params) {
    return await this.#client.getComment(...params);
  }
  async createCommentReport(...params) {
    return await this.#client.createCommentReport(...params);
  }
  async resolveCommentReport(...params) {
    return await this.#client.resolveCommentReport(...params);
  }
  async listCommentReports(...params) {
    return await this.#client.listCommentReports(...params);
  }
  async getPrivateMessages(...params) {
    return await this.#client.getPrivateMessages(...params);
  }
  async createPrivateMessage(...params) {
    return await this.#client.createPrivateMessage(...params);
  }
  async editPrivateMessage(...params) {
    return await this.#client.editPrivateMessage(...params);
  }
  async deletePrivateMessage(...params) {
    return await this.#client.deletePrivateMessage(...params);
  }
  async markPrivateMessageAsRead(...params) {
    return await this.#client.markPrivateMessageAsRead(...params);
  }
  async createPrivateMessageReport(...params) {
    return await this.#client.createPrivateMessageReport(...params);
  }
  async resolvePrivateMessageReport(...params) {
    return await this.#client.resolvePrivateMessageReport(...params);
  }
  async listPrivateMessageReports(...params) {
    return await this.#client.listPrivateMessageReports(...params);
  }
  async register(...params) {
    return await this.#client.register(...params);
  }
  async login(...params) {
    return await this.#client.login(...params);
  }
  async logout(...params) {
    return await this.#client.logout(...params);
  }
  async getPersonDetails(...params) {
    return await this.#client.getPersonDetails(...params);
  }
  async getPersonMentions(...params) {
    return await this.#client.getPersonMentions(...params);
  }
  async markPersonMentionAsRead(...params) {
    return await this.#client.markPersonMentionAsRead(...params);
  }
  async getReplies(...params) {
    return await this.#client.getReplies(...params);
  }
  async banPerson(...params) {
    return await this.#client.banPerson(...params);
  }
  async getBannedPersons(...params) {
    return await this.#client.getBannedPersons(...params);
  }
  async blockPerson(...params) {
    return await this.#client.blockPerson(...params);
  }
  async getCaptcha(...params) {
    return await this.#client.getCaptcha(...params);
  }
  async deleteAccount(...params) {
    return await this.#client.deleteAccount(...params);
  }
  async passwordReset(...params) {
    return await this.#client.passwordReset(...params);
  }
  async passwordChangeAfterReset(...params) {
    return await this.#client.passwordChangeAfterReset(...params);
  }
  async markAllAsRead(...params) {
    return await this.#client.markAllAsRead(...params);
  }
  async saveUserSettings(...params) {
    return await this.#client.saveUserSettings(...params);
  }
  async changePassword(...params) {
    return await this.#client.changePassword(...params);
  }
  async getReportCount(...params) {
    return await this.#client.getReportCount(...params);
  }
  async getUnreadCount(...params) {
    return await this.#client.getUnreadCount(...params);
  }
  async verifyEmail(...params) {
    return await this.#client.verifyEmail(...params);
  }
  async addAdmin(...params) {
    return await this.#client.addAdmin(...params);
  }
  async getUnreadRegistrationApplicationCount(...params) {
    return await this.#client.getUnreadRegistrationApplicationCount(...params);
  }
  async listRegistrationApplications(...params) {
    return await this.#client.listRegistrationApplications(...params);
  }
  async approveRegistrationApplication(...params) {
    return await this.#client.approveRegistrationApplication(...params);
  }
  async getRegistrationApplication(...params) {
    return await this.#client.getRegistrationApplication(...params);
  }
  async purgePerson(...params) {
    return await this.#client.purgePerson(...params);
  }
  async purgeCommunity(...params) {
    return await this.#client.purgeCommunity(...params);
  }
  async purgePost(...params) {
    return await this.#client.purgePost(...params);
  }
  async purgeComment(...params) {
    return await this.#client.purgeComment(...params);
  }
  async getFederatedInstances(...params) {
    return await this.#client.getFederatedInstances(...params);
  }
  async blockInstance(...params) {
    return await this.#client.blockInstance(...params);
  }
  async uploadImage(...params) {
    return await this.#client.uploadImage(...params);
  }
  async editSite(...params) {
    return await this.#client.editSite(...params);
  }
  async deleteImage(...params) {
    return await this.#client.deleteImage(...params);
  }
  async listMedia(...params) {
    return await this.#client.listMedia(...params);
  }
}
class SiteData {
  #data;
  get data() {
    return this.#data;
  }
  set data(value) {
    this.#data = value;
  }
}
const site = new SiteData();
async function customFetch(func, input, init, auth) {
  const f = func ? func : fetch;
  if (init) {
    init.headers = {
      ...init.headers,
      "User-Agent": `Photon/${"2.2.2"}`,
      ...auth ? { authorization: `Bearer ${auth}` } : {}
    };
    if (auth) {
      init.cache = "no-store";
    }
  }
  const res = await f(input, init);
  if (!res.ok) error(res.status, await res.text());
  return res;
}
function client({ instanceURL, func, auth, clientType } = {}) {
  if (!instanceURL) instanceURL = profile.current.instance || DEFAULT_INSTANCE_URL;
  if (!clientType) {
    clientType = profile.current.client ?? DEFAULT_CLIENT_TYPE;
  }
  const jwt = auth ?? profile.current?.jwt;
  const headers = jwt ? { authorization: `Bearer ${jwt}` } : {};
  return new (clientType.name == "piefed" ? PiefedClient : LemmyClient)(instanceToURL(instanceURL), {
    fetchFunction: (input, init) => customFetch(func, input, init, jwt),
    headers
  });
}
function getClient(instanceURL, func, auth) {
  return client({ instanceURL, func, auth });
}
export {
  html as $,
  ArrowDownTray as A,
  Button as B,
  ClipboardDocument as C,
  DEFAULT_INSTANCE_URL as D,
  Expandable as E,
  DEFAULT_CLIENT_TYPE as F,
  DOMAIN_REGEX_FORMS as G,
  LemmyClient as H,
  placeholders as I,
  isImage as J,
  isVideo as K,
  LINKED_INSTANCE_URL as L,
  Material as M,
  NoSymbol as N,
  instance as O,
  PiefedClient as P,
  isPostView as Q,
  ReactiveState as R,
  SvelteURL as S,
  hidePost as T,
  UserLink as U,
  VideoCamera as V,
  postLink as W,
  isCommunityView as X,
  isUser as Y,
  optimizeImageURL as Z,
  Blobs as _,
  getClient as a,
  buttonSize as a0,
  removeToast as a1,
  escapeHtml as a2,
  Minus as a3,
  isComment as a4,
  buttonColor as a5,
  Language as a6,
  mediaType as a7,
  PostIframe as a8,
  iframeType as a9,
  bestImageURL as aa,
  toastColors as ab,
  toasts as ac,
  Logo as ad,
  Badge as b,
  client as c,
  awaitIfServer as d,
  errorMessage as e,
  fullCommunityName as f,
  goto as g,
  Avatar as h,
  Markdown as i,
  searchParam as j,
  invalidate as k,
  SvelteURLSearchParams as l,
  communityLink as m,
  SvelteMap as n,
  Plus as o,
  profile as p,
  publishedToDate as q,
  recursiveEqual as r,
  site as s,
  toast as t,
  userLink as u,
  getItemPublished as v,
  isCommentView as w,
  instanceToURL as x,
  Spinner as y,
  SvelteSet as z
};
//# sourceMappingURL=client.svelte.js.map
