import "clsx";
import { n as SvelteMap, r as recursiveEqual } from "./client.svelte.js";
class Feed {
  #data;
  #fetch;
  #lastParams;
  constructor(fetch) {
    this.#fetch = fetch;
  }
  async load(params) {
    if (!recursiveEqual(params, this.#lastParams)) {
      this.#data = void 0;
    }
    this.#lastParams = params;
    if (this.#data == null) this.#data = await this.#fetch(params);
    return this.#data;
  }
  peek() {
    return this.#data;
  }
  update(value) {
    this.#data = value;
  }
}
const feeds = new SvelteMap();
function feed(id, init) {
  feeds.get(id);
  const feedData = new Feed(init);
  feeds.set(id, feedData);
  return feedData;
}
export {
  feeds as a,
  feed as f
};
//# sourceMappingURL=feed.svelte.js.map
