const routes = {
  passwordChange: {
    instance: "Millä instanssilla tilisi sijaitsee?",
    title: "Vaihda salasana",
    description: "Valitse uusi salasana."
  },
  resetLogin: {
    title: "Palauta salasana",
    description: "Syötä käyttäjätiliisi liitetty sähköposti. Salasanan palautuslinkki lähetetään sinne. Jos tiliisi ei ole liitetty sähköpostia, ota yhteys instanssisi ylläpitoon."
  },
  theme: {
    title: "Teema",
    "import": "Tuo",
    "export": "Vie",
    reset: "Palauta oletukset",
    accent: "Korostusväri",
    resetWarning: {
      title: "Palauta teema",
      description: "Tämä palauttaa kaikki värisi oletukseksi. On suositeltavaa viedä teema ulos ensin."
    },
    preset: {
      title: "Ei voi muuttaa",
      description: "Oletusteemoja ei voi muuttaa.",
      "delete": {
        title: "Poista teema",
        confirm: "Vahvista"
      },
      "default": "Oletus",
      classic: "Vanha",
      imported: "Teemasi",
      "new": "Uusi teema",
      presets: "Esiasetukset"
    }
  },
  frontpage: {
    title: "Etusivu",
    footer: "{{users:number}} {{users; 1:aktiivinen käyttäjä; default:aktiivista käyttäjää;}}",
    endFeed: "Olet saavuttanut {{community_name; undefined:syötteen lopun.; default:yhteisön {{community_name}} lopun.}}",
    empty: {
      title: "Ei julkaisuja",
      description: "Julkaisuja, jotka vastaavat tätä hakua ei löytynyt."
    }
  },
  modlog: {
    filters: "Suodattimet",
    title: "Moderointiloki"
  },
  profile: {
    user: "Käyttäjä",
    blocks: {
      title: "Estot",
      empty: {
        title: "Ei estoja",
        description: "Estämiesi käyttäjien ja yhteisöjen sisältö piilotetaan syötteestäsi."
      }
    },
    credentials: "Kirjautumistiedot",
    moderates: "Moderoidut yhteisöt",
    settings: "Asetukset",
    favorites: "Suosikit",
    media: {
      title: "Media",
      download: "Lataa"
    },
    upvoted: "Ylä-äänet",
    downvoted: "Alaäänet",
    logins: "Kirjautumishistoria",
    welcome: "Tervetuloa, {{default}}!",
    "delete": {
      title: "Poista tili",
      warning: "Tiliä ei voi palauttaa poistamisen jälkeen. Oletko varma?"
    },
    overview: "Yleisnäkymä",
    submissions: "Lähetykset",
    edit: "Muokkaa"
  },
  instances: "Instanssit",
  createPost: "Luo julkaisu",
  translators: "Kääntäjät",
  accounts: "Käyttäjätilit",
  search: {
    title: "Haku",
    query: "Hakusanat",
    noResults: {
      title: "Ei tuloksia",
      alt: "Etsi mitä tahansa fediversestä.",
      description: "Haku ei tuottanut tuloksia näillä rajoituksilla. Yritä muokata hakua."
    },
    federating: "Federoidaan",
    top: "Parhaat tulokset",
    other: "Muut tulokset"
  },
  saved: "Tallennetut",
  createCommunity: "Luo yhteisö",
  post: {
    commentCount: "Kommentit",
    addComment: "Kommentoi",
    scrollToTop: "Takaisin ylös",
    thread: {
      context: "Näytä konteksti",
      allComments: "Kaikki kommentit",
      single: "Selaat yksittäistä ketjua.",
      part: "Selaat osittaista ketjua."
    },
    remoteView: "Etänäkymä",
    localView: "Siirry paikalliseen näkymään",
    crosspostCount: "Ristijulkaisut",
    instanceWarning: "Tämä julkaisu haettiin eri palvelimelta, kuin käyttäjäsi. Moni toiminto ei toimi.",
    emptyComments: {
      title: "Ei kommentteja",
      description: "Aloita keskustelu!"
    },
    commented: "Kommenttisi on lähetetty.",
    loadComments: "Lataa kommentit"
  },
  inbox: {
    title: "Postilaatikko",
    markAsRead: "Merkitse kaikki luetuksi",
    empty: {
      title: "Ei uusia ilmoituksia",
      description: "Viestit, vastaukset, sekä maininnat näkyvät täällä."
    },
    item: {
      reply: "{{user}} vastasi kommenttiisi ketjussa {{post}}",
      mention: "{{user}} mainisti sinut ketjussa: {{post}}",
      message: "{{user}} lähetti viestin käyttäjälle {{recipient}}"
    },
    messages: {
      conversation: "Tämä on keskustelun alku käyttäjän {{user}} kanssa",
      start: "Aloita keskustelu",
      empty: {
        title: "Ei viestejä"
      }
    }
  },
  legal: {
    title: "Lakitiedot",
    noLegal: "Tällä instanssilla ei ole lakitietoja."
  },
  moderation: {
    resolve: "Ratkaise",
    unresolve: "Merkitse ratkaisemattomaksi",
    title: "Moderointi",
    empty: {
      description: "Kun sisältö ilmiannetaan, voit ratkaista tapauksen täällä.",
      title: "Ei uusia ilmiantoja"
    },
    reason: "Syy",
    resolved: "Käsitelty",
    resolvedBy: "Käsitellyt",
    manage: {
      title: "Hallinta",
      modlogs: "Viimeaikaiset moderointilokit",
      ban: "Anna porttikielto",
      unban: "Poista porttikielto"
    },
    markAllComplete: "Joukkotoiminto valmis.",
    markAll: "Merkitse sivu käsitellyksi",
    feed: "Ilmiannot"
  },
  admin: {
    title: "Ylläpito",
    config: {
      icon: "Kuvake",
      banner: "Kansikuva",
      downvotesEnabled: "Ota alaäänet käyttöön",
      nsfwEnabled: "Salli NSFW",
      registration: {
        label: "Rekisteröitymistila",
        open: "Avoin",
        application: "Vaadi hakemus",
        closed: "Suljettu"
      },
      sidebar: "Sivupalkki",
      title: "Sivusto",
      applicationQuestion: "Hakemuksen kysymys",
      adminCommunityOnly: "Vain ylläpitäjät voivat luoda yhteisöjä",
      requireVerifyEmail: "Vaadi sähköpostivahvistus",
      emailAdminsOnReport: "Lähetä ylläpitäjille sähköposti-ilmoitus ilmiannoista",
      listingType: {
        label: "Listaustyyppi",
        all: "Kaikki",
        local: "Paikallinen"
      },
      "private": "Yksityinen instanssi",
      hideModlogModNames: "Piilota moderaattorien nimet lokissa",
      slurFilter: "Kielletyt sanat (regex)",
      federation: "Federointi päällä",
      captcha: {
        enabled: "CAPTCHA päällä"
      },
      emailAdminsOnApplication: "Lähetä ylläpitäjille sähköposti-ilmoitus hakemuksista",
      federationDebug: "Federoinnin vianetsintätila"
    },
    applications: {
      title: "Hakemukset",
      empty: {
        title: "Ei uusia hakemuksia",
        description: "Liittymishakemukset ilmestyvät tänne."
      },
      application: "Hakemus",
      approved: "Hyväksytty",
      denied: "Evätty",
      user: "Käyttäjä",
      approve: "Hyväksy",
      reason: "Syy",
      modalTitle: "Epää hakemus",
      deny: "Epää"
    },
    taglines: {
      title: "Iskulauseet",
      add: "Lisää iskulause",
      empty: {
        title: "Ei iskulauseita",
        description: "Sivun kortissa näytetään satunnaisesti valittu iskulause, kun käyttäjä vierailee instanssillasi."
      }
    },
    team: {
      title: "Ylläpitäjät",
      empty: {
        title: "Ei ylläpitäjiä",
        description: "Jostain syyst tällä sivustolla ei ole ylläpitäjiä. Miten??"
      }
    },
    federation: {
      title: "Federointi",
      csv: "Lataa CSV",
      blocked: "Estetyt instanssit",
      block: "Estä",
      blockplaceholder: "Estä instanssi...",
      allowed: "Sallitut instanssit",
      allowplaceholder: "Lisää sallittu instanssi",
      emptyBlock: {
        title: "Ei estettyjä instansseja",
        description: "Instanssin estäminen piilottaa uuden sisällön siltä."
      },
      emptyAllow: {
        title: "Ei erikseen sallittuja instansseja",
        description: "Sallittujen instanssien määrittäminen estää listaamattomat instanssit."
      },
      allow: "Sallitut"
    },
    media: {
      title: "Media"
    }
  },
  verifyEmail: {
    message: "Sähköpostisi on vahvistettu. Voit nyt sulkea tämän ikkunan.",
    error: "Sähköpostin vahvistus epäonnistui."
  },
  communities: {
    title: "Yhteisöt",
    trending: "Trendaavat",
    search: {
      placeholder: "Etsi uusia yhteisöjä"
    }
  },
  community: {
    settings: {
      team: "Tiimi",
      settings: "Asetukset",
      manage: "Muuta asetuksia"
    },
    languageWarning: "Tämä yhteisö käyttää kieliä, joita et ole valinnut. Osa tai kaikki yhteisön sisällösta on voi puuttua."
  },
  postRedirect: {
    description: "Tämä linkki johtaa eri instanssille, kuin millä selaat nyt ({{homeInstance}}).",
    title: "Osoitteen instanssi ei täsmää",
    actions: {
      back: "Mene takaisin",
      fetch: "Hae julkaisu oman instanssisi kautta: {{homeInstance}}",
      "switch": "Vaihda tilille kohdeinstanssilla {{destInstance}}"
    }
  }
};
const cards = {
  site: {
    about: "Tietoja",
    stats: "Tilastot",
    admins: "Ylläpitäjät"
  },
  community: {
    members: "Jäsenet",
    moderators: "Moderaattorit",
    subscribe: "Tilaa",
    subscribed: "Tilattu",
    modlog: "Moderointiloki",
    block: "Estä yhteisö",
    unblock: "Poista yhteisön esto",
    blockInstance: "Estä instanssi",
    favorite: "Lisää suosikkeihin",
    unfavorite: "Poista suosikeista",
    activeDay: "Aktiivisia tänään"
  }
};
const post = {
  actions: {
    more: {
      share: "Jaa linkki",
      markRead: "Merkitse luetuksi",
      markUnread: "Merkitse lukemattomaksi",
      translate: "Käännä",
      label: "Lisää toimintoja",
      edit: "Muokkaa",
      creator: "Lähettäjä",
      crosspost: "Tee ristijulkaisu",
      actions: "Toiminnot",
      "delete": "Poista",
      restore: "Palauta",
      hide: "Piilota",
      unhide: "Näytä",
      mediaBias: "Median puolueellisuus"
    },
    comments: "Kommentit",
    save: "Tallenna",
    unsave: "Poista tallennus",
    mediaBias: {
      description: "Kuvaus",
      noData: {
        title: "Ei tietoja",
        description: "Ei tietoja sivuston puolueellisuudesta."
      },
      credibility: "Uskottavuus",
      downloading: "Ladataan tietoja",
      loading: "Ladataan lähdettä",
      reporting: "Todenmukainen raportointi"
    },
    link: {
      title: "Vaihtoehtoiset linkit",
      actions: "Linkin toiminnot"
    },
    vote: {
      upvote: "Anna ylä-ääni",
      downvote: "Anna alaääni",
      score: "Äänet"
    }
  },
  badges: {
    featured: "Nostettu",
    removed: "Poistettu",
    deleted: "Käyttäjän poistama",
    locked: "Lukittu",
    saved: "Tallennettu",
    nsfw: "NSFW"
  },
  image: {
    zoomIn: "Suurenna",
    zoomOut: "Pienennä",
    close: "Sulje"
  },
  meta: {
    lastEdited: "Viimeksi muokattu {{default}}",
    created: "Luotu {{default}}"
  }
};
const content = {
  all: "Kaikki",
  users: "Käyttäjät",
  posts: "Julkaisut",
  comments: "Kommentit",
  instances: "Instanssit",
  message: "Viesti",
  communities: "Yhteisöt",
  url: "URL"
};
const admin = {
  purge: "Puhdista",
  instance: "Instanssi",
  label: "Ylläpito",
  purgeCommunity: {
    title: "Puhdista yhteisö",
    warning: "Tämä poistaa kaikki julkaisut. Oletko varma? (Nappula avautuu kolmessa sekunnissa)"
  }
};
const nav = {
  menu: {
    app: "Sovellus",
    label: "Profiili",
    settings: "Asetukset",
    colorscheme: {
      dark: "Tumma",
      light: "Vaalea",
      label: "Väritila",
      system: "Oletus"
    },
    theme: "Teemat",
    about: "Tietoja",
    source: "Lähdekoodi",
    donate: "Lahjoita",
    instance: "Instanssi"
  },
  communities: "Selaa yhteisöjä",
  home: "Koti",
  search: "Hae",
  create: {
    label: "Luo",
    post: "Julkaisu",
    community: "Yhteisö",
    logingate: "Kirjaudu sisään luodaksesi sisältöä."
  },
  moderation: "Moderointi",
  admin: "Ylläpito",
  commands: {
    prompt: "Komentopaletti",
    recents: "Viimeksi luetut",
    content: "Sisältö",
    search: "Hae: {{default}}",
    main: "Päävalikko",
    setViewTo: "{{default}}",
    setColorTo: "{{default}}",
    feeds: "Syötteet",
    downloading: "Ladataan toimintoja",
    setView: "Valitse näkymä",
    setColor: "Valitse väritila",
    setTheme: "Aseta teema",
    setThemeTo: "Aseta teema: {{default}}",
    contextual: "Tällä sivulla"
  },
  notifications: "Ilmoitukset"
};
const profile = {
  profile: "Profiili",
  inbox: "Postilaatikko",
  subscribed: "Tilaukset",
  saved: "Tallennetut"
};
const account = {
  login: "Kirjaudu sisään",
  logout: "Kirjaudu ulos",
  signup: "Luo tili",
  accounts: "Käyttäjätilit",
  changeinstance: "Vaihda instanssia",
  resetColor: "Palauta oletusväri",
  addGuest: "Lisää vieras",
  moveUp: "Siirrä ylös",
  moveDown: "Siirrä alas",
  guest: "Vieras",
  versionGate: "Tämä Photon-versio tukee instansseja versiosta {{version}} eteenpäin."
};
const filter = {
  sort: {
    top: {
      label: "Parhaat",
      time: {
        all: "milloin tahansa",
        label: "Aika",
        "9months": "9 kk",
        "3months": "3 kk",
        month: "kuukausi",
        week: "viikko",
        day: "päivä",
        hour: "tunti",
        "12hours": "12 t",
        "6hours": "6 t",
        "6months": "6 kk"
      }
    },
    hot: "Kuumat",
    label: "Lajittelu",
    active: "Aktiiviset",
    controversial: "Kiistanalaiset",
    "new": "Uusimmat",
    old: "Vanhimmat",
    newcomments: "Uusia vastauksia",
    scaled: "Skaalattu",
    mostcomments: "Eniten kommentteja"
  },
  location: {
    moderator: "Moderaattori",
    label: "Sijainti",
    local: "Paikallinen",
    subscribed: "Tilaukset",
    all: "Kaikki",
    global: "Yleinen"
  },
  inbox: {
    mentions: "Maininnat",
    messages: "Viestit",
    replies: "Vastaukset"
  },
  view: {
    compact: "Tiivis",
    label: "Näkymä",
    cozy: "Mukava",
    list: "Lista",
    legacy: "Vanha"
  },
  type: "Tyyppi",
  filter: "Suodata",
  unread: "Lukemattomat"
};
const form = {
  "2fa": "2FA-koodi",
  username: "Käyttäjänimi",
  forgotpassword: "Unohdin salasanani",
  name: "Nimi",
  password: "Salasana",
  post: {
    body: "Sisältö",
    nsfw: "NSFW",
    community: "Yhteisö",
    title: "Otsikko",
    uploadImage: "Lisää kuva",
    generateTitle: "Hae otsikko",
    create: "Luo julkaisu",
    edit: "Muokkaa julkaisua",
    url: "URL",
    altText: "Vaihtoehtoinen teksti",
    selectFile: "Valitse tiedosto",
    addUrl: "Liitä linkki",
    setLanguage: "Aseta kieli",
    unset: "Poista",
    readMore: "Lue lisää"
  },
  profile: {
    "2fa": {
      totp: "TOTP",
      "2fa": "Kaksivaiheinen tunnistautuminen (2FA)",
      paste: "Liitä tämä todenninsovellukseesi (authenticator app).",
      disabled: "2FA on pois päältä"
    },
    deleteAccount: {
      warning: "Tämä poistaa KAIKEN lähettämäsi sisällön.",
      label: "Poista tili",
      deleteContent: "Poista sisältö"
    },
    bio: "Profiilin kuvaus",
    matrix: "Matrix-käyttäjä",
    newPassword: "Uusi salasana",
    verifyNewPassword: "Vahvista uusi salasana",
    currentPassword: "Nykyinen salasana",
    email: "Sähköposti",
    bot: "Robottikäyttäjä",
    avatar: "Profiilikuva",
    banner: "Kansikuva",
    showNSFW: "Näytä NSFW-sisältö",
    scores: "Näytä pisteet",
    showRead: "Näytä luetut julkaisut",
    showBots: "Näytä robottikäyttäjät",
    displayName: "Näyttönimi",
    languages: {
      description: "Kielten asettaminen piilottaa muunkielisen sisällön. Suurinta osaa sisällöstä ei ole merkitty, jolloin sen kieli on 'Undetermined'.",
      title: "Kielet"
    },
    credentials: {
      title: "Hallitse kirjautumista",
      description: "Täällä voit asettaa kaksivaiheisen tunnistautumisen (2FA) päälle, vaihtaa salasanasi, tarkastella kirjautuneita laitteita tai poistaa tilisi."
    }
  },
  setup: "Ota käyttöön",
  signup: {
    title: "Luo tili",
    application: {
      label: "Vastaus",
      info: "Liittyäksesi tälle instanssille, sinun tulee täyttää tämä hakemus ja odottaa sen hyväksymistä. Saat vastauksen sähköpostiisi, kun se on hyväksytty.",
      notice: "Rekisteröitymisesi on vireillä. Saat sähköpostin, kun ylläpitäjä on tarkastanut sen."
    },
    closed: {
      title: "Rekisteröityminen suljettu",
      description: "Rekisteröityminen tälle instanssille on suljettu. Etsi toinen instanssi.",
      anotherInstance: "Etsi toinen instanssi"
    },
    chooseInstance: "Valitse instanssi",
    description: "Valitse kiinnostava instanssi tai syötä osoite manuaalisesti.",
    info: "Instanssi on palvelin, jolla käyttäjätilisi sijaitsee. Voit silti osallistua keskusteluun muilla instansseilla.",
    verify: {
      title: "Varmista sähköposti",
      description: "Sähköpostiisi on lähetetty varmistuslinkki. Paina allaolevaa nappulaa, kun olet avannut sen.",
      submit: "Olen varmistanut sähköpostini",
      error: "Sähköpostisi ei ole varmistettu."
    }
  },
  description: "Kuvaus",
  email: "Sähköposti",
  preview: "Esikatsele",
  submit: "Lähetä",
  confirmPassword: "Vahvista salasana",
  edit: "Muokkaa",
  instance: "Instanssin osoite",
  time: {
    duration: "Kesto",
    minutes: "Minuuttia",
    hours: "Tuntia",
    days: "Päivää",
    months: "Kuukautta",
    years: "Vuotta",
    permanent: "Pysyvä"
  }
};
const moderation = {
  ban: {
    banning: "Anna porttikielo",
    unbanning: "Poista porttikielto",
    deleteData: "Poista data",
    expires: "Vanhentuu (UTC)",
    banFromCommunity: "Anna porttikielto yhteisöön",
    unbanFromCommunity: "Poista porttikielto yhteisöstä",
    warning: "Tämä poistaa KAIKEN tämän käyttäjän lähettämän sisällön tänne."
  },
  removeSubmission: {
    title: "Poista lähetys",
    titleRestore: "Palauta lähetys",
    titlePurge: "Puhdista lähetys",
    withReason: "Ilmoita käyttäjälle",
    comment: "Kommentti",
    failMessage: "Viestin lähetys epäonnistui. Poistetaan silti...",
    successPurge: "Lähetys puhdistettiin onnistuneesti.",
    failReply: "Vastauksen lähetys epäonnistui. Poistetaan silti...",
    message: "Viesti",
    failEmptyReply: 'Vastaus ei voi olla tyhjä, jos "Ilmoita käyttäjälle" on valittu.'
  },
  reportModal: {
    title: "Ilmianna",
    success: "Lähetys ilmiannettu."
  },
  reason: "Syy",
  lock: "Lukitse",
  unlock: "Poista lukitus",
  remove: "Poista",
  restore: "Palauta",
  label: "Moderointi",
  labelInstanceOnly: "Moderointi (vain instanssi)",
  feature: "Nosta",
  unfeature: "Poista nosto",
  report: "Ilmianna",
  modlog: {
    comment: "Kommentin moderointiloki",
    user: "Käyttäjän moderointiloki",
    post: "Julkaisun moderointiloki"
  },
  votes: "Äänet"
};
const comment = {
  actions: {
    link: "Kopioi linkki",
    label: "Toiminnot"
  },
  locked: "Tämä julkaisu on lukittu.",
  reply: "Vastaa",
  more: "{{comments:number}} lisää",
  banned: "Olet saanut porttikiellon tähän yhteisöön."
};
const common = {
  back: "Takaisin",
  next: "Seuraava",
  debug: "Vianetsintä",
  refresh: "Päivitä",
  jump: "Hyppää",
  save: "Tallenna",
  enabled: "Päällä",
  disabled: "Pois päältä",
  enable: "Ota käyttöön",
  disable: "Poista käytöstä",
  add: "Lisää",
  send: "Lähetä",
  cancel: "Peru",
  general: "Yleinen",
  remove: "Poista",
  download: "Lataa",
  attach: "Liitä tiedosto",
  info: "Tietoja"
};
const message = {
  success: "Onnistui",
  error: "Virhe",
  retry: "Yritä uudelleen"
};
const toast = {
  noComments: "API ei palauttanut kommentteja.",
  loginVoteGate: "Kirjaudu sisään äänestääksesi.",
  blockedCommunity: "Yhteisö estetty.",
  unblockedCommunity: "Yhteisön esto poistettu.",
  purgedCommunity: "Yhteisö puhdistettu.",
  blockedInstance: "Instanssi estetty.",
  sentMessage: "Viesti lähetetty.",
  bannedUser: "Porttikielto annettu käyttäjälle.",
  unbannedUser: "Porttilkielto poistettu käyttäjältä.",
  needCommunity: "Täsmennä yhteisö.",
  invalidURL: "Virheellinen URL",
  invalidDateBeforeCurrent: "Virheellinen päivämäärä. Päivämäärä on menneisyydessä.",
  generatedTitle: "Otsikko ja sisältö haettu osoitteen perusteella. Peru?",
  copied: "Kopioitu leikepöydälle.",
  approvedApplication: "Hakemus hyväksytty.",
  deniedApplication: "Hakemus evätty.",
  updatedSite: "Sivusto päivitetty.",
  failCSV: "CSV:n luku epäonnistui",
  removeAdminWarning: "Oletko varma, että haluat poistaa tämän ylläpitäjän?",
  removeAdmin: "Ylläpitäjä poistettu.",
  failFindUser: "Käyttäjää ei löydetty.",
  updateMods: "Yhteisön moderaattorit päivitetty.",
  logIn: "Sisäänkirjautuminen onnistui.",
  failInstanceURL: "Yhteys instanssiin epäonnistui. Onko se alhaalla?",
  addAccount: "Käyttäjätili lisätty.",
  resolveReport: "Ilmianto ratkaistu.",
  unresolveReport: "Ilmianto merkitty ratkaisemattomaksi.",
  passwordReset: "Salasanasi on palautettu.",
  loginRefresh: "Kirjautumisesi on päivitetty.",
  saveSettings: "Käyttäjän asetukset tallennettu. Jos vaihdoit sähkköpostisi, saat vahvistuslinkin.",
  confirmDelete1: "Oletko varma, että haluat poistaa käyttäjätilisi?",
  confirmDelete2: "Oletko oikeasti varma?",
  needPassword: "Salasana tarvitaan.",
  deleting: "Poistetaan käyttäjätiliä...",
  deleted: "Käyttäjätilisi on poistettu.",
  resetSettings: "Haluatko palauttaa oletusasetukset?",
  failFetchInstances: "Saatavilla olevien instanssien haku epäonnistui.",
  failSignup: "Rekisteröityminen epäonnistui.",
  successSignup: "Rekisteröidytty.",
  waitApplication: "Odota rekisteröitymisesi hyväksymistä ennen sisäänkirjautumista.",
  blockUser: "Käyttäjä estetty.",
  unblockUser: "Käyttäjän esto poistettu.",
  purgeUser: "Käyttäjä puhdistettu.",
  restoredFromDraft: "Julkaisu palautettu luonnoksesta.",
  fetchPostOnHome: "Haetaan julkaisu omalta instanssiltasi...",
  updatedCommunity: "Yhteisösi on päivitetty.",
  invalidDateAbsolute: "Virheellinen päivämäärä. Päivämäärä ei voi olla suhteellinen.",
  failGenerateTitle: "Otsikon hakeminen sivulta epäonnistui.",
  addMod: "Moderaattori lisätty.",
  resetLink: "Palautuslinkki lähetettin sähköpostiisi.",
  invalidLogin: "Virheelliset kirjautuimistiedot",
  confirmDelete3: "Viimeinen varoitus. Oletko oikeasti varma?",
  verifyEmail: "Vahvistuslinkki lähetettiin sähköpostiisi. Vahvista sähköpostisi ja sitten kirjaudu.",
  settingsImport: "Asetusten tuonti onnistui.",
  settingsImportWarning: "Tuodut asetukset eivät vaikuta kelvollisilta. Haluatko yrittää siitä huolimatta?",
  userLoading: "Ladataan käyttäjätietoja...",
  lemmyDonate: "Instanssisi käyttää avoimen lähdekoodin Lemmy-ohjelmistoa. Lemmyn kehittäjät ottavat vastaan lahjoituksia. Kiitos käyttäjien tuen, Lemmy on vapaa mainoksista ja jäljityksestä.\n\nVuosittain he pyytävät harkitsemaan lahjoitusta, jotta Lemmyn ylläpito ja parantaminen jatkuisi.\n\n[Lahjoita](https://join-lemmy.org/donate)\n\n*Huomaa: tämä on lahjoitus Lemmylle, ei Photonille.*"
};
const settings = {
  app: {
    sort: {
      title: "Oletusjärjestys",
      description: "Syötteiden oletuslajittelu."
    },
    view: {
      title: "Näkymän tyyli",
      legacy: "Photonin vanha ulkoasu.",
      cozy: "Näytä kuvat, sisältö ja upotukset suurina.",
      compact: "Näytä julkaisut tiiviinä listana, ilman sisältöä.",
      list: "Näytä julkaisut listana, lyhennetyn sisällön kanssa."
    },
    lang: {
      title: "Kieli",
      en: "englanti",
      "en-US": "englanti",
      he: "heprea",
      et: "viro",
      fr: "ranska",
      auto: "automaattinen",
      credits: "Kääntäjät",
      description: "Käyttöliittymän kieli.",
      note: "Virallisesti tuetut kielet ovat englanti ja heprea. Muut käännökset ovat yhteisön tekemiä, eivätkä siten välttämättä ole täydellisiä.",
      fi: "suomi",
      pt: "portugali",
      de: "saksa",
      useRtl: {
        title: "Oikealta vasemmalle -asettelu",
        description: "Käytä asettelua oikealta vasemmalle luettaville kielille."
      },
      zh: "kiina",
      "zh-Hans": "kiina (yksinkertaistettu)",
      "zh-Hant": "kiina (perinteinen)"
    },
    title: "Sovellus",
    theming: {
      title: "Teemat",
      description: "Muokkaa värejä.",
      link: "Mene teemoihin"
    },
    displayName: {
      title: "Käytä näyttönimeä",
      description: "Näytä käyttäjien näyttönimet oikeiden käyttäjänimien sijaan."
    },
    limitLayoutWidth: {
      title: "Rajoita leveyttä",
      description: "Paranna luettavuutta rajoittamalla käyttöliittymän leveyttä."
    },
    expandImages: {
      title: "Laajenna kuvat",
      description: "Julkaisun kuvan klikkaaminen suurentaa sen, eikä avaa itse julkaisua."
    },
    duplicateTitles: {
      title: "Piilota identtinen otsikko ja sisältö",
      description: "Jos julkaisun otsikko ja sisältö ovat identtiset upotuksen kanssa, piilota ne."
    },
    font: {
      description: "Valitse käyttöliittymän fontti.",
      title: "Fontti"
    },
    translation: {
      title: "Käännös",
      description: "LibreTranslate-instanssi, jota käyttää konekäännöksiin.",
      instance: "Verkkotunnus"
    },
    thumbnailSide: {
      title: "Pikkukuvan sijainti",
      left: "Vasen",
      right: "Oikea",
      description: "Pikkukuvan sijainti tiiviissä- ja listanäkymässä"
    },
    postsInNewTab: {
      title: "Avaa uudessa välilehdessä",
      description: "Avaa julkaisut aina uudessa välilehdessä."
    },
    placeholders: {
      title: "Satunnaiset paikkamerkit",
      description: "Näytä satunnaisia paikkamerkkejä tyhjillä tekstikentillä."
    },
    colorscheme: {
      title: "Väritila",
      description: "Valitse väritila."
    },
    infiniteScroll: {
      description: "Lataa lisää julkaisuja automaattisesti alaspäin vieritettäessä.",
      title: "Jatkuva selaus"
    },
    titleTags: {
      description: "Muuta [hakasulkeissa] olevat tekstinpätkät tageiksi, joiden avulla voi hakea sisältöä.",
      title: "Erottele tagit otsikoista",
      rules: {
        "blur-sm": "Sumenna",
        hide: "Piilota",
        show: "Näytä",
        title: "Valinnat"
      }
    },
    reverseActions: {
      title: "Käänteinen toimintopalkki",
      description: "Käännä julkaisujen ja kommenttien toimintojen järjestys päinvastaiseksi."
    },
    titleOpensUrl: {
      title: "Otsikko avaa URL:n",
      description: "Otsikon klikkaaminen avaa julkaisun sijaan siihen liitetyn osoitteen."
    },
    absoluteDates: {
      title: "Näytä päiväys",
      description: "Korvaa suhteelliset aikaleimat (esim. 3 tuntia sitten) tarkoilla päiväyksillä."
    }
  },
  title: "Asetukset",
  beta: "Beta",
  navigation: {
    title: "Navigointi",
    dockPos: {
      title: "Telakan sijainti",
      top: "Ylhäällä",
      bottom: "Alhaalla",
      adaptive: "Mukautuva",
      description: "Minne telakka sijoitetaan näytöllä."
    },
    panel: {
      title: "Paneelitila",
      description: "Laajenna telakka näytön reunoille.",
      on: "Päällä",
      off: "Pois päältä",
      adaptive: "Mukautuva"
    },
    pins: {
      title: "Kiinnitykset",
      description: "Lisää kiinnityksiä sivupalkkiin napsauttamalla kuvaketta. Napsauta oikealla poistaaksesi sen."
    },
    commands: {
      description: "Paina vinoviivanäppäintä (/) tai klikkaa logoa oikealla näppäimellä avataksesi komentopaletin.",
      title: "Komentopaletti"
    },
    autoHide: {
      title: "Piilota telakka automaattisesti",
      description: "Piilottaa telakan mobiilinäkymässä, kun kelaat alaspäin."
    }
  },
  lemmy: {
    compactFeatured: {
      title: "Tiiviit nostot",
      description: "Näyttää nostetut julkaisut tiiviinä."
    },
    markReadPosts: {
      description: "Merkitsee julkaisut luetuksi avattaessa.",
      title: "Merkitse avatut julkaisut luetuksi"
    },
    fadeReadPosts: {
      title: "Häivytä luetut",
      description: "Häivytä luettujen julkaisujen otsikot"
    },
    hideSubmissions: {
      title: "Piilota sisältö",
      description: "Piilota tietyntyyppinen sisältö.",
      removed: "Poistettu moderaattorin toimesta",
      deleted: "Poistettu käyttäjän toimesta"
    },
    instances: {
      description: "Näyttää instanssin, josta sisältö on kotoisin.",
      title: "Näytä instanssit"
    },
    nsfwBlur: {
      title: "NSFW-sumennus",
      description: "Sumentaa NSFW-julkaisujen kuvat ja piilotta tekstin."
    },
    title: "Lemmy",
    crosspostMarker: {
      title: "Merkitse ristijulkaisut",
      description: "Lisää linkin alkuperäiseen julkaisuun jakaessa ristiin."
    },
    showHiddenPosts: {
      title: "Näytä piilotetut julkaisut",
      description: "Näyttää käsin piilottamasi julkaisut."
    }
  },
  moderation: {
    title: "Moderointi",
    replyPresets: {
      title: "Poistovastaukset",
      description: "Valmiit vastaukset sisällön poiston syyksi.",
      syntax: "Syntaksi"
    }
  },
  embeds: {
    title: "Upotukset",
    clickToView: {
      title: "Klikkaa näyttääksesi",
      description: "Lataa upotus vasta, kun olet klikannut sitä."
    },
    youtube: {
      description: "Sivusto, jota käytetään YouTube-sisällön upotukseen."
    },
    instance: {
      description: "Instanssi, jonka kautta upottaa YouTube-sisältö.",
      invidious: "Invidious-instanssi",
      piped: "Piped-instanssi"
    }
  },
  other: {
    debug: {
      title: "Vianetsintätiedot",
      description: "Näyttää vianetsintätiedot."
    },
    title: "Muut",
    virtualizeFeeds: {
      title: "Älä virtualisoi syötettä",
      description: "Virtualisotu syöte ei piirrä näytön ulkopuolelle jääviä julkaisuja, mikä tehostaa sivun toimintaa huomattavasti. Poista virtualisointi käytöstä, jos syötteen selaus nykii. Tämä poistaa jatkuvan selauksen käytöstä."
    }
  },
  desktop: "Työpöytä",
  tablet: "Tabletti",
  mobile: "Mobiili",
  "export": "Vie",
  "import": "Tuo",
  reset: "Palauta oletukset",
  account: {
    title: "Käyttäjätili"
  }
};
const error = {
  incorrect_login: "Virheelliset kirjautumistiedot. Yritä uudelleen.",
  incorrect_login_2: "Virheelliset kirjautumistiedot. Yritä uudelleen uudelleen.",
  incorrect_login_3: "Virheelliset kirjautumistiedot. Yritä vielä muutaman kerran.",
  incorrect_login_6: "Onko tämä mielestäsi jokin vitsi?",
  incorrect_login_5: "Katso tarkkaan, mitä näppäimia painelet tällä kertaa.",
  incorrect_login_7: "Sinulla taitaa olla vaikeuksia kirjoittamisen kanssa.",
  incorrect_login_4: "Virheelliset kirjautumistiedot. Jatka yrittämistä.",
  incorrect_login_12: "...",
  incorrect_login_8: "Luovutan.",
  incorrect_login_9: "Pyyhkisit joskus nenäsi.",
  incorrect_login_10: "Ajattele ylläpitäjiä.",
  incorrect_login_11: "Luovutan, oikeasti tällä kertaa.",
  email_already_exists: "Sähköpostiosoitteesi on jo käytössä toisella tilillä.",
  couldnt_find_post: "Hakemaasi julkaisua ei löytynyt.",
  cant_block_yourself: "Et voi estää itseäsi.",
  email_not_verified: "Tilisi sähköpostia ei ole vahvistettu.",
  passwords_do_not_match: "Antamasi salasanat eivät täsmää.",
  downvotes_are_disabled: "Alaäänet ovat poissa käytöstä tällä instanssilla.",
  captcha_failed: "CAPTCHA ei mennyt läpi.",
  cant_block_local_instance: "Et voi estää omaa instanssiasi.",
  invalid_vote_value: "Äänen arvo on virheellinen. Vaalivilppi on Lemmyssä on kielletty.",
  registration_application_is_pending: "Tilin rekisteröitymistä ei ole vielä käsitelty.",
  honeypot_failed: "Oletko varma, ettet ole robotti? Joku kävi hunajapurkilla.",
  slurs: "Lähetyksesi sisältää kiellettyjä sanoja.",
  language_not_allowed: "Valitsemasi kieli ei ole sallitu tässä yhteisössä. Poista valinta käyttääksesi yhteisön oletusta.",
  couldnt_find_community: "Tätä yhteisöä ei ole olemassa.",
  couldnt_find_person: "Tätä käyttäjää ei ole olemassa.",
  not_an_admin: "Et ole instanssin ylläpitäjä."
};
const aria = {
  vote: {
    group: "Julkaisun äänestäminen",
    upvotes: "{{default}} ylä-ääntä",
    downvotes: "{{default}} alaääntä",
    score: "Pisteet: {{default}}"
  },
  pagination: {
    nav: "Sivutus",
    current: "Nykyinen sivu"
  },
  sidebar: {
    title: "Sivupalkki"
  },
  loading: "Ladataan",
  element: {
    pageHeader: "Sivun otsikko"
  },
  postDecor: {
    openImage: "Avaa kuva: {{default}}",
    openLink: "Avaa linkki: {{default}}",
    openPost: "Avaa julkaisu: {{default}}"
  }
};
const stats = {
  joined: "Liittyi",
  created: "Luotu"
};
const placeholders = {
  title: "Kirjoita julkaisun otsikko"
};
const fi = {
  routes,
  cards,
  post,
  content,
  admin,
  nav,
  profile,
  account,
  filter,
  form,
  moderation,
  comment,
  common,
  message,
  toast,
  settings,
  error,
  aria,
  stats,
  placeholders
};
export {
  account,
  admin,
  aria,
  cards,
  comment,
  common,
  content,
  fi as default,
  error,
  filter,
  form,
  message,
  moderation,
  nav,
  placeholders,
  post,
  profile,
  routes,
  settings,
  stats,
  toast
};
//# sourceMappingURL=fi.js.map
