import { p as profile, c as client } from "./client.svelte.js";
async function blockUser(block, id) {
  return await client().blockPerson({
    block,
    person_id: id
  });
}
function isBlocked(me, user) {
  return me.person_blocks.find((b) => b.target.id == user);
}
function addSubscription(community, subscribe = true) {
  const index = profile.current.user?.follows.map((f) => f.community.id).indexOf(community.id);
  if (subscribe && index == -1) {
    profile.current.user?.follows.push({
      follower: profile.current.user.follows[0]?.follower,
      community
    });
  } else {
    profile.current.user?.follows.splice(index ?? 0, 1);
  }
}
export {
  addSubscription as a,
  blockUser as b,
  isBlocked as i
};
//# sourceMappingURL=index6.js.map
