import { t } from "./index.js";
import { w as writable } from "./index2.js";
const shownModal = writable();
const action = (action2) => ({
  action: action2?.action ? () => {
    action2?.action?.();
    if (action2.close) shownModal.set(void 0);
  } : () => shownModal.set(void 0),
  type: action2?.type ?? "secondary",
  content: action2?.content || t.get("common.back"),
  close: action2?.close ?? true
});
function modal(inputModal) {
  const modal2 = {
    actions: inputModal.actions ?? [action()],
    dismissable: inputModal.dismissable ?? true,
    title: inputModal.title,
    body: inputModal.body,
    type: inputModal.type ?? "info",
    snippet: inputModal.snippet
  };
  shownModal.set(modal2);
}
export {
  action as a,
  modal as m,
  shownModal as s
};
//# sourceMappingURL=modal2.js.map
