import { c as client } from "./client.svelte.js";
import { w as writable } from "./index2.js";
const modals = writable({
  reporting: {
    open: false,
    item: void 0
  },
  removing: {
    open: false,
    item: void 0,
    purge: false
  },
  banning: {
    open: false,
    banned: false,
    user: void 0,
    community: void 0
  },
  votes: {
    open: false,
    item: void 0
  }
});
function report(item) {
  modals.update((m) => ({
    ...m,
    reporting: {
      open: true,
      item
    }
  }));
}
function remove(item, purge = false) {
  modals.update((m) => ({
    ...m,
    removing: {
      open: true,
      item,
      purge
    }
  }));
}
function ban(banned, item, community) {
  modals.update((m) => ({
    ...m,
    banning: {
      open: true,
      user: item,
      banned,
      community
    }
  }));
}
async function feature(featured, item, jwt) {
  return await client({ auth: jwt }).distinguishComment({
    comment_id: item.id,
    distinguished: featured
  });
}
async function viewVotes(item) {
  modals.update((m) => ({
    ...m,
    votes: {
      open: true,
      item
    }
  }));
}
const removalTemplate = (input, content) => {
  if (content.postTitle) input = input.replaceAll("{{post}}", content.postTitle);
  if (content.communityLink)
    input = input.replaceAll("{{community}}", content.communityLink);
  if (content.username)
    input = input.replaceAll("{{username}}", content.username);
  if (content.reason) input = input.replaceAll("{{reason}}", content.reason);
  return input;
};
export {
  remove as a,
  ban as b,
  report as c,
  feature as f,
  modals as m,
  removalTemplate as r,
  viewVotes as v
};
//# sourceMappingURL=moderation.js.map
