import "clsx";
import { c as client, P as PiefedClient } from "./client.svelte.js";
class PostFormState {
  type;
  community;
  title;
  body;
  url;
  nsfw;
  altText;
  thumbnail;
  language;
  poll;
  event;
  flairList;
  constructor(post) {
    this.type = post?.type ?? "normal";
    this.community = post?.community;
    this.title = post?.name ?? "";
    this.body = post?.body;
    this.url = post?.url;
    this.nsfw = post?.nsfw ?? false;
    this.altText = post?.alt_text;
    this.language = post?.language_id?.toString();
    this.thumbnail = void 0;
    this.poll = post?.poll ?? {
      mode: "single",
      local_only: false,
      choices: [
        { choice_text: "Option 1", id: 1, num_votes: 0, sort_order: 0 },
        { choice_text: "Option 2", id: 2, num_votes: 0, sort_order: 1 }
      ]
    };
    this.event = post?.event;
    this.flairList = post?.flair_list ?? [];
  }
  validate(mode) {
    if (mode == "create" && !this.community) return false;
    if (this.url && !URL.canParse(this.url)) return false;
    return true;
  }
  async submit(postId) {
    if (!this.validate(postId ? "edit" : "create")) throw new Error("failed validation");
    const api = client();
    let res;
    if (postId) {
      res = (await api.editPost({
        post_id: postId,
        name: this.title,
        body: this.body,
        url: this.url,
        nsfw: this.nsfw,
        alt_text: this.altText,
        custom_thumbnail: this.thumbnail,
        language_id: Number(this.language) || void 0,
        poll: this.type == "poll" ? this.poll : void 0,
        event: this.type == "event" ? this.event : void 0
      })).post_view;
    } else {
      res = (await api.createPost({
        community_id: this.community.id,
        name: this.title,
        body: this.body,
        url: this.url,
        alt_text: this.altText,
        custom_thumbnail: this.thumbnail,
        nsfw: this.nsfw,
        language_id: Number(this.language) || void 0,
        poll: this.type == "poll" ? this.poll : void 0,
        event: this.type == "event" ? this.event : void 0
      })).post_view;
    }
    if (api instanceof PiefedClient) {
      const flairRes = await api.assignFlair({
        flair_id_list: this.flairList.map((i) => i.id),
        post_id: res.post.id
      });
      res.flair_list = flairRes.flair_list;
    }
    return res;
  }
}
async function autofillPost(url) {
  const res = await client().getSiteMetadata({ url: url.toString() });
  return { title: res.metadata.title, body: res.metadata.description };
}
export {
  PostFormState as P,
  autofillPost as a
};
//# sourceMappingURL=postform.svelte.js.map
