import "clsx";
import { p as public_env } from "./shared-server.js";
import "./index.js";
const SSR_ENABLED = public_env.PUBLIC_SSR_ENABLED?.toLowerCase() == "true";
const toBool = (str) => {
  if (!str) {
    return null;
  }
  return str.toLowerCase() === "true";
};
const defaultSettings = {
  settingsVer: 7,
  expandableImages: toBool(public_env.PUBLIC_EXPANDABLE_IMAGES) ?? true,
  markReadPosts: toBool(public_env.PUBLIC_MARK_READ_POSTS) ?? true,
  showInstances: {
    user: toBool(public_env.PUBLIC_SHOW_INSTANCES_USER) ?? true,
    community: toBool(public_env.PUBLIC_SHOW_INSTANCES_COMMUNITY) ?? true,
    comments: toBool(public_env.PUBLIC_SHOW_INSTANCES_COMMENTS) ?? true
  },
  defaultSort: {
    sort: public_env.PUBLIC_DEFAULT_FEED_SORT ?? "Active",
    feed: public_env.PUBLIC_DEFAULT_FEED ?? "Local",
    comments: public_env.PUBLIC_DEFAULT_COMMENT_SORT ?? "Hot"
  },
  hidePosts: {
    deleted: toBool(public_env.PUBLIC_HIDE_DELETED) ?? false,
    removed: toBool(public_env.PUBLIC_HIDE_REMOVED) ?? false
  },
  expandSidebar: toBool(public_env.PUBLIC_EXPAND_SIDEBAR) ?? true,
  expand: {
    communities: toBool(public_env.PUBLIC_EXPAND_COMMUNITIES) ?? true,
    favorites: toBool(public_env.PUBLIC_EXPAND_FAVORITES) ?? true,
    moderates: toBool(public_env.PUBLIC_EXPAND_MODERATES) ?? true,
    about: false,
    stats: false,
    team: false,
    accounts: true
  },
  displayNames: toBool(public_env.PUBLIC_DISPLAY_NAMES) ?? true,
  nsfwBlur: toBool(public_env.PUBLIC_NSFW_BLUR) ?? true,
  moderation: {
    presets: [
      {
        title: "Preset 1",
        content: `Your submission in *"{{post}}"* was removed for {{reason}}.`
      }
    ],
    defaultRemoveAction: null
  },
  modlogCardView: toBool(public_env.PUBLIC_MODLOG_CARD_VIEW) ?? void 0,
  debugInfo: toBool(public_env.PUBLIC_DEBUG_INFO) ?? false,
  expandImages: toBool(public_env.PUBLIC_EXPAND_IMAGES) ?? true,
  view: public_env.PUBLIC_VIEW ?? "compact",
  font: public_env.PUBLIC_FONT ?? "inter",
  leftAlign: toBool(public_env.PUBLIC_LEFT_ALIGN) ?? false,
  newWidth: toBool(public_env.PUBLIC_LIMIT_LAYOUT_WIDTH) ?? true,
  markPostsAsRead: toBool(public_env.PUBLIC_MARK_POSTS_AS_READ) ?? true,
  openLinksInNewTab: false,
  crosspostOriginalLink: true,
  embeds: {
    clickToView: true,
    youtube: "youtube",
    invidious: void 0,
    piped: void 0
  },
  dock: { paletteHotkey: "/", autoHide: true },
  posts: {
    deduplicateEmbed: toBool(public_env.PUBLIC_DEDUPLICATE_EMBED) ?? true,
    compactFeatured: toBool(public_env.PUBLIC_COMPACT_FEATURED) ?? true,
    showHidden: false,
    noVirtualize: false,
    reverseActions: toBool(public_env.PUBLIC_REVERSE_ACTIONS) ?? false,
    titleOpensUrl: toBool(public_env.PUBLIC_TITLE_OPENS_URL) ?? false
  },
  forms: { autosubmitAutofill: false },
  infiniteScroll: true,
  language: public_env.PUBLIC_LANGUAGE ?? null,
  useRtl: false,
  parseTags: true,
  logoColorMonth: null,
  absoluteDates: false,
  messages: { fullMarkdown: toBool(public_env.PUBLIC_FULL_MARKDOWN) ?? false },
  voteRatioBar: false
};
function createSettingsState(initial) {
  let settings2 = initial;
  return settings2;
}
const settings = createSettingsState(JSON.parse(JSON.stringify(defaultSettings)));
export {
  SSR_ENABLED as S,
  defaultSettings as d,
  settings as s
};
//# sourceMappingURL=settings.svelte.js.map
