const debounce = (fn, ms = 300) => {
  let timeoutId;
  return function(...args) {
    clearTimeout(timeoutId);
    timeoutId = setTimeout(() => fn.apply(this, args), ms);
  };
};
export {
  debounce as d
};
//# sourceMappingURL=time.js.map
