const form = {
  profile: {
    email: "邮箱",
    displayName: "昵称",
    bio: "个人简介",
    avatar: "头像",
    banner: "背景横幅",
    showNSFW: "显示NSFW内容",
    scores: "显示分数",
    bot: "机器人账号",
    showBots: "显示机器人帖子",
    showRead: "显示已读",
    currentPassword: "当前密码",
    newPassword: "新密码",
    verifyNewPassword: "确认密码",
    matrix: "Matrix 用户",
    "2fa": {
      totp: "TOTP",
      paste: "将此粘贴到您的身份验证器应用程序中。",
      "2fa": "2FA"
    },
    deleteAccount: {
      label: "删除帐户",
      deleteContent: "删除内容",
      warning: "这将删除您提交的所有内容。"
    }
  },
  username: "用户名",
  name: "名字",
  instance: "网址",
  password: "密码",
  confirmPassword: "确认密码",
  "2fa": "2FA两步验证码",
  forgotpassword: "忘记密码",
  submit: "发送",
  edit: "编辑",
  preview: "预览",
  post: {
    create: "发布",
    edit: "编辑帖子",
    community: "社群",
    title: "标题",
    url: "网址",
    body: "正文",
    nsfw: "NSFW",
    generateTitle: "代入标题",
    uploadImage: "上传图片",
    altText: "替代文本",
    selectFile: "选择文件",
    readMore: "查看更多",
    addUrl: "添加链接",
    setLanguage: "设置语言",
    unset: "撤销设置"
  },
  signup: {
    title: "注册",
    description: "选择您感兴趣的实例，或输入网址。",
    info: "实例是托管你账户的服务器，但你仍然可以访问来自其他实例的内容并与之互动。",
    chooseInstance: "选择一个实例",
    application: {
      label: "应用程序",
      info: "要加入此实例，您必须填写申请表，并等待审核结果。如果您的申请被接受，您将收到一封电子邮件通知。"
    },
    closed: {
      title: "注册通道已关闭",
      description: "此实例的注册通道已关闭。请寻找其它实例。",
      anotherInstance: "寻找其它实例"
    }
  },
  email: "邮箱",
  setup: "配置",
  description: "描述"
};
const routes = {
  createPost: "发帖",
  saved: "保存",
  createCommunity: "建立社群",
  post: {
    crosspostCount: "转贴",
    commentCount: "评论",
    addComment: "新增评论",
    instanceWarning: "此帖子是从与您的账户不同的实例请求的。许多操作将无法进行。",
    scrollToTop: "回到顶部",
    remoteView: "所有",
    localView: "本站视图",
    thread: {
      single: "您正在查看单个对话串。",
      allComments: "所有评论",
      part: "您正在查看对话串的一部分。",
      context: "显示上下文"
    },
    emptyComments: {
      title: "暂无评论",
      description: "开始对话！"
    }
  },
  verifyEmail: {
    message: "您已验证邮箱。您现在可以关闭此窗口。",
    error: "无法验证您的邮箱。"
  },
  passwordChange: {
    title: "修改密码",
    description: "选择您的新密码。",
    instance: "您的帐户托管在哪个实例上？"
  },
  resetLogin: {
    title: "重置密码",
    description: "输入您帐户的邮箱，系统将发送密码重置链接。如果您的帐户没有邮箱，请联系您的实例管理员。"
  },
  theme: {
    title: "主题",
    "import": "导入",
    "export": "导出",
    reset: "重置",
    resetWarning: {
      description: "这将把所有颜色重置为默认值。建议在此之前导出主题。",
      title: "重置主题"
    },
    accent: "强调色",
    preset: {
      title: "无法编辑",
      classic: "经典",
      imported: "你的主题",
      "new": "新主题",
      description: "这是默认主题，因此无法编辑。",
      "delete": {
        title: "删除主题",
        confirm: "确认"
      },
      "default": "默认",
      presets: "预设"
    }
  },
  admin: {
    applications: {
      empty: {
        description: "你的实例的注册申请将显示在此处。",
        title: "没有新的申请"
      },
      title: "申请",
      application: "申请",
      approved: "已批准",
      denied: "已拒绝",
      user: "用户",
      deny: "拒绝",
      approve: "批准",
      reason: "原因",
      modalTitle: "拒绝申请"
    },
    team: {
      empty: {
        description: "好奇怪，这个实例竟然没有管理员。怎么会这样？？",
        title: "没有管理员"
      },
      title: "实例管理员"
    },
    config: {
      slurFilter: "侮辱性词语过滤正则表达式",
      title: "配置",
      sidebar: "侧边栏",
      icon: "图标",
      banner: "横幅",
      downvotesEnabled: "启用点踩",
      nsfwEnabled: "启用NSFW",
      registration: {
        label: "注册方式",
        open: "开放注册",
        application: "需要申请",
        closed: "关闭"
      },
      applicationQuestion: "申请问题",
      adminCommunityOnly: "只有管理员可以创建社群",
      requireVerifyEmail: "需要电子邮件验证",
      emailAdminsOnApplication: "在收到新申请时向管理员发送电子邮件",
      emailAdminsOnReport: "在收到新举报时向管理员发送电子邮件",
      listingType: {
        label: "列表类型",
        all: "全部",
        local: "本站"
      },
      "private": "私有实例",
      hideModlogModNames: "隐藏管理日志中的管理员名称",
      federation: "联合已启用",
      federationDebug: "联合调试模式",
      captcha: {
        enabled: "已启用验证码"
      }
    },
    federation: {
      emptyBlock: {
        description: "屏蔽一个实例后，来自该实例的新帖子将被隐藏。",
        title: "没有被屏蔽的实例"
      },
      title: "联合",
      csv: "上传CSV",
      blocked: "被屏蔽的实例",
      block: "屏蔽",
      blockplaceholder: "屏蔽某个实例...",
      allowed: "白名单实例",
      allow: "白名单",
      allowplaceholder: "将实例列入白名单",
      emptyAllow: {
        title: "没有白名单实例",
        description: "将一个实例列入白名单将阻止与其他所有实例的联合。"
      }
    },
    title: "实例管理",
    taglines: {
      title: "标语",
      add: "添加标语",
      empty: {
        title: "没有标语",
        description: "当用户访问您的实例时，实例信息卡上会出现一条随机标语。"
      }
    }
  },
  search: {
    noResults: {
      description: "没有符合该筛选条件的结果。请尝试优化你的搜索。",
      title: "没有内容",
      alt: "在整个联邦宇宙搜索"
    },
    title: "搜索",
    federating: "联合",
    query: "查询",
    top: "最匹配的结果",
    other: "其它结果"
  },
  profile: {
    moderates: "管理",
    user: "用户",
    settings: "设置",
    blocks: {
      empty: {
        description: "屏蔽某个对象后，它将不再在你的信息流中出现。",
        title: "暂无屏蔽的条目"
      },
      title: "已屏蔽"
    },
    credentials: "凭证",
    favorites: "收藏",
    upvoted: "点赞",
    downvoted: "点踩",
    media: {
      title: "媒体",
      download: "下载"
    },
    welcome: "欢迎，{{default}}！",
    "delete": {
      title: "删除帐户",
      warning: "此操作是永久性的。您确定要继续吗？"
    },
    logins: "登录记录",
    overview: "概况",
    submissions: "发表历史"
  },
  moderation: {
    resolve: "解决",
    unresolve: "撤销解决",
    title: "社群管理",
    empty: {
      title: "暂无新举报",
      description: "当帖子被举报时，您可以在此处采取行动。"
    },
    reason: "原因",
    resolvedBy: "已解决，处理人是",
    resolved: "已解决"
  },
  frontpage: {
    title: "首页",
    footer: "{{users:number}} 活跃 {{用户; 1:用户; default:用户;}}",
    endFeed: "您已到达{{community_name; undefined:信息流; default:{{community_name}}}}的末尾"
  },
  modlog: "管理日志",
  instances: "实例",
  legal: {
    title: "条款",
    noLegal: "此实例未设置任何条款。"
  },
  translators: "翻译",
  accounts: "账户",
  communities: {
    title: "社群",
    trending: "热门",
    search: {
      placeholder: "搜索新社群"
    }
  },
  inbox: {
    title: "收件箱",
    markAsRead: "标记全部已读",
    empty: {
      title: "没有新通知",
      description: "消息、回复和提及将显示在此处。"
    },
    item: {
      reply: "{{user}} 在 {{post}} 中回复了你",
      message: "{{user}} 向 {{recipient}} 发送了消息",
      mention: "{{user}} 在 {{post}} 中提及了你"
    }
  },
  community: {
    settings: {
      team: "团队",
      settings: "设置",
      manage: "管理"
    }
  }
};
const common = {
  back: "后退",
  next: "下一页",
  refresh: "刷新",
  disabled: "已停用",
  cancel: "取消",
  debug: "调试",
  jump: "跳过",
  save: "保存",
  enabled: "已启用",
  enable: "启用",
  disable: "停用",
  add: "添加",
  send: "发送",
  general: "综合"
};
const profile = {
  profile: "帐户",
  inbox: "收件箱",
  saved: "收藏",
  subscribed: "关注"
};
const nav = {
  home: "主页",
  admin: "站点管理",
  moderation: "社群管理",
  communities: "探索",
  search: "搜索",
  create: {
    label: "新增",
    post: "帖子",
    community: "社群",
    logingate: "你需要先登录，才能发帖。"
  },
  menu: {
    label: "账户",
    app: "App",
    settings: "设置",
    colorscheme: {
      label: "配色方案",
      system: "跟随系统",
      dark: "深色",
      light: "浅色"
    },
    theme: "主题",
    about: "关于",
    source: "来源",
    instance: "站点",
    donate: "捐款"
  },
  commands: {
    contextual: "在此页",
    prompt: "指令面板",
    recents: "最近使用",
    content: "内容",
    search: "搜索 {{default}}",
    main: "常用",
    setView: "设置视图",
    setViewTo: "将视图模式设置为 {{default}}",
    setColorTo: "将色调设置为 {{default}}",
    feeds: "信源",
    downloading: "正在加载操作",
    setColor: "设置配色方案",
    setTheme: "设置主题",
    setThemeTo: "将主题设为 {{default}}"
  }
};
const account = {
  login: "登录",
  logout: "退出",
  signup: "注册",
  accounts: "账号",
  changeinstance: "更改实例",
  resetColor: "重置颜色",
  addGuest: "新增游客账户",
  moveUp: "上移",
  moveDown: "下移",
  guest: "游客",
  versionGate: "当前版本的 Photon 支持 {{version}} 或更高版本的实例。"
};
const filter = {
  location: {
    label: "位置",
    all: "所有",
    local: "本站",
    subscribed: "订阅",
    moderator: "参与管理",
    global: "全部"
  },
  sort: {
    label: "排序",
    active: "活跃",
    hot: "热门",
    top: {
      label: "最佳",
      time: {
        label: "时间",
        all: "所有",
        "9months": "9月内",
        "6months": "6月内",
        "3months": "3月内",
        month: "1月内",
        week: "本周",
        day: "今天",
        "12hours": "12小时",
        "6hours": "6小时",
        hour: "1小时"
      }
    },
    "new": "最新",
    old: "最旧",
    controversial: "争议",
    scaled: "各版热议",
    mostcomments: "最多评论",
    newcomments: "最新回复"
  },
  view: {
    label: "显示模式",
    cozy: "默认",
    list: "列表",
    compact: "紧湊",
    legacy: "经典"
  },
  type: "类型",
  filter: "筛选",
  unread: "未读",
  inbox: {
    messages: "私信",
    replies: "回复",
    mentions: "提及"
  }
};
const cards = {
  site: {
    about: "关于",
    stats: "数据",
    admins: "实例管理员"
  },
  community: {
    members: "成员",
    moderators: "社群管理员",
    subscribe: "关注",
    subscribed: "已关注",
    block: "屏蔽",
    unblock: "取消屏蔽",
    blockInstance: "屏蔽实例",
    favorite: "收藏",
    unfavorite: "取消收藏",
    modlog: "日志",
    activeDay: "今日活跃"
  }
};
const content = {
  all: "所有",
  users: "用户",
  posts: "帖子",
  comments: "评论",
  communities: "社群",
  instances: "实例",
  message: "消息"
};
const post = {
  actions: {
    save: "保存",
    more: {
      crosspost: "转发",
      label: "更多操作",
      edit: "编辑",
      creator: "作者",
      actions: "操作",
      markRead: "标记为已读",
      markUnread: "标记为未读",
      hide: "隐藏",
      unhide: "取消隐藏",
      translate: "翻译",
      mediaBias: "媒体偏见",
      share: "分享",
      "delete": "删除",
      restore: "恢复"
    },
    mediaBias: {
      noData: {
        description: "本实例没有偏见数据。",
        title: "无数据"
      },
      description: "描述",
      credibility: "可信度",
      reporting: "事实报道",
      downloading: "正在下载数据集",
      loading: "正在加载源"
    },
    comments: "评论",
    unsave: "不保存",
    vote: {
      upvote: "顶",
      downvote: "踩",
      score: "分数"
    },
    link: {
      title: "备用链接",
      actions: "链接操作"
    }
  },
  badges: {
    nsfw: "NSFW",
    featured: "已加精",
    locked: "已锁定",
    removed: "已被移除",
    deleted: "已删除",
    saved: "已保存"
  },
  image: {
    zoomIn: "放大",
    zoomOut: "缩小",
    close: "关闭"
  },
  meta: {
    lastEdited: "最后编辑于 {{default}}",
    created: "创建于 {{default}}"
  }
};
const moderation = {
  report: "举报",
  removeSubmission: {
    failEmptyReply: "如果启用了“回复原因”，您的回复不能为空。",
    title: "删除提交内容",
    titleRestore: "恢复提交内容",
    titlePurge: "清除提交内容",
    withReason: "回复理由",
    comment: "评论",
    message: "留言",
    failReply: "无法发布回复。仍然继续删除…",
    failMessage: "无法向用户留言。仍然继续删除...",
    successPurge: "已成功清除该条提交内容。"
  },
  reportModal: {
    title: "举报",
    success: "举报了该条提交内容。"
  },
  reason: "原因",
  unlock: "解除锁定",
  remove: "删除",
  lock: "锁定",
  label: "社群管理",
  labelInstanceOnly: "社群管理（仅实例）",
  feature: "加精",
  unfeature: "取消加精",
  ban: {
    banning: "封禁用户",
    unbanning: "取消封禁用户",
    deleteData: "删除数据",
    warning: "这将删除此用户在此处提交的所有内容。",
    expires: "到期时间 (UTC)",
    banFromCommunity: "从社群封禁",
    unbanFromCommunity: "从社群解除封禁"
  },
  restore: "恢复"
};
const settings = {
  title: "设置",
  app: {
    lang: {
      title: "语言",
      auto: "自动",
      "zh-Hans": "中文（简体）",
      "zh-Hant": "中文（繁体）",
      useRtl: {
        title: "使用RTL布局",
        description: "对RTL语言使用RTL布局。"
      },
      description: "Photon的用户界面所使用的语言。",
      note: "英语和希伯来语以外的语言均由社区翻译，可能不完整。",
      en: "英语",
      "en-US": "英语（美国）",
      he: "希伯来语",
      et: "爱沙尼亚语",
      fr: "法语",
      de: "德语",
      fi: "芬兰语",
      pt: "葡萄牙语",
      zh: "中文",
      credits: "致谢"
    },
    expandImages: {
      description: "点击帖子图片会使您进入大图浏览，而不是帖子页面。",
      title: "展开图片"
    },
    view: {
      list: "按列表展示帖子，显示帖子内容和紧凑格式的媒体。",
      cozy: "显示大图像、富文本嵌入内容与长帖子正文。",
      compact: "按列表显示帖子，不显示帖子正文，间隔更紧凑。",
      legacy: "旧版 Photon 外观。",
      title: "帖子风格"
    },
    infiniteScroll: {
      description: "新帖子会在你向下滚动时自动加载，不需要点击“下一页”。",
      title: "无限滚动"
    },
    duplicateTitles: {
      title: "隐藏重复的标题/正文",
      description: "如果帖子标题和正文与嵌入内容相同，则隐藏它们。"
    },
    thumbnailSide: {
      title: "缩略图对齐",
      description: "缩略图应以列表/压缩模式显示在帖子上的位置",
      left: "左",
      right: "右"
    },
    font: {
      title: "字体",
      description: "Photon 在用户界面中使用什么字体。"
    },
    translation: {
      title: "翻译",
      description: "用于翻译的LibreTranslate实例。",
      instance: "域名"
    },
    placeholders: {
      title: "随机占位符",
      description: "为某些文本输入框显示随机占位符。"
    },
    limitLayoutWidth: {
      description: "通过限制主要内容的宽度来提高可读性。",
      title: "限制布局宽度"
    },
    title: "Photon",
    theming: {
      title: "主题",
      description: "自定义 Photon 的颜色。",
      link: "转到主题"
    },
    colorscheme: {
      title: "配色方案",
      description: "要使用的配色方案。"
    },
    sort: {
      title: "默认排序方式",
      description: "在信息源中使用的默认排序方式。"
    },
    postsInNewTab: {
      title: "在新标签页中打开帖子",
      description: "用单独标签页，而不是在当前选项卡打开帖子。"
    },
    displayName: {
      title: "使用昵称",
      description: "显示用户的昵称，而不是他们的实际用户名。"
    },
    titleTags: {
      title: "解析标题中的标签",
      description: "将[括号]中的文本转换为可以单击搜索的标签。",
      rules: {
        title: "规则",
        "blur-sm": "模糊",
        hide: "隐藏",
        show: "显示"
      }
    },
    reverseActions: {
      title: "反转操作列",
      description: "反转帖子和评论中的操作顺序。"
    }
  },
  lemmy: {
    nsfwBlur: {
      title: "模糊 NSFW 内容",
      description: "模糊图像并移除NSFW帖子的内容。"
    },
    fadeReadPosts: {
      description: "淡化你已经阅读过的帖子的标题",
      title: "淡化已读帖子"
    },
    markReadPosts: {
      description: "点击帖子时，将其标记为已读",
      title: "将帖子标记为已读"
    },
    instances: {
      description: "显示某些内容来自的实例。",
      title: "显示实例"
    },
    title: "Lemmy",
    showHiddenPosts: {
      title: "显示被隐藏的帖子",
      description: "显示您手动隐藏的帖子。"
    },
    compactFeatured: {
      title: "紧凑显示精华帖",
      description: "使精华帖的展示更加紧凑"
    },
    crosspostMarker: {
      title: "标记转帖",
      description: "转帖时显示 '转自'。"
    },
    hideSubmissions: {
      title: "隐藏提交内容",
      description: "隐藏某些类型的提交内容。",
      deleted: "已被用户删除的",
      removed: "已被社群管理员删除的"
    }
  },
  navigation: {
    pins: {
      description: "点击一个图钉即可将其置于侧边栏顶部。右键点击已固定的项目即可将其移除。",
      title: "置顶"
    },
    dockPos: {
      bottom: "底部",
      adaptive: "自适应",
      title: "Dock栏位置",
      description: "Dock栏应放在屏幕上的位置。",
      top: "顶部"
    },
    panel: {
      title: "面板模式",
      description: "将Dock栏延伸到屏幕边缘，类似于面板。",
      on: "开",
      off: "关",
      adaptive: "自适应"
    },
    title: "导航",
    commands: {
      title: "指令面板",
      description: "按下斜杠键或右键单击Photon标志，即可通过搜索在应用各部分间跳转。"
    }
  },
  embeds: {
    title: "嵌入内容",
    clickToView: {
      title: "点击查看",
      description: "只有点击后才能加载嵌入内容。"
    },
    youtube: {
      description: "要嵌入 YouTube 内容的网站。"
    },
    instance: {
      invidious: "Invidious 实例",
      piped: "Piped 实例",
      description: "嵌入 YouTube 内容的实例。"
    }
  },
  moderation: {
    title: "社群管理",
    replyPresets: {
      title: "预设回复删除原因",
      description: "在提交内容删除对话框中用于“回复原因”的预设。",
      syntax: "语法"
    }
  },
  other: {
    title: "其他",
    debug: {
      title: "调试信息",
      description: "显示调试信息"
    },
    virtualizeFeeds: {
      title: "不对信息源进行虚拟化处理",
      description: "虚拟化仅渲染可见的帖子，从而大幅提高性能。如果遇到卡顿问题，请禁用虚拟化。这将禁用无限滚动。"
    }
  },
  beta: "Beta",
  desktop: "桌面",
  tablet: "平板",
  mobile: "手机",
  "export": "导出",
  "import": "导入",
  reset: "重置",
  account: {
    title: "账户"
  }
};
const toast = {
  settingsImportWarning: "导入的设置似乎无效。您确定要导入吗？",
  resetLink: "密码重置链接已发送到您的邮箱。",
  needPassword: "您必须提供密码。",
  verifyEmail: "验证链接已发送到您的邮箱。验证您的邮箱，然后登录。",
  unblockedCommunity: "已取消屏蔽该社群。",
  invalidDateBeforeCurrent: "日期无效。 日期在当前时间之前。",
  confirmDelete3: "最后警告。你真的确定吗？",
  failGenerateTitle: "该实例没有可用的标题或描述。",
  saveSettings: "已保存您的用户设置。 如果您更改了邮箱， 则会发送验证链接。",
  noComments: "API未返回任何评论。",
  loginVoteGate: "您必须登录才能赞踩。",
  blockedCommunity: "已屏蔽该社群。",
  purgedCommunity: "已清除该社群。",
  blockedInstance: "已屏蔽该实例。",
  updatedCommunity: "您的社群已被更新。",
  sentMessage: "消息已发送。",
  invalidDateAbsolute: "日期无效。必须是绝对日期。",
  bannedUser: "已封禁该用户。",
  unbannedUser: "已取消封禁该用户。",
  needCommunity: "你必须建立一个社群。",
  invalidURL: "链接无效",
  generatedTitle: "从链接生成了标题和正文。 是否撤消此操作？",
  restoredFromDraft: "已从草稿中恢复您的帖子。",
  copied: "已复制到剪贴板。",
  approvedApplication: "已批准该申请。",
  deniedApplication: "已拒绝该申请。",
  updateMods: "已更新社群管理员。",
  logIn: "已成功登录。",
  failInstanceURL: "联系该实例失败。 该实例是否处于下线状态？",
  addAccount: "已添加该帐户。",
  updatedSite: "已更新你的站点。",
  failCSV: "读取CSV失败",
  removeAdminWarning: "您确定要删除该实例管理员吗？",
  removeAdmin: "已删除该实例管理员。",
  failFindUser: "找不到该用户。",
  addMod: "已添加该社群管理员。",
  resolveReport: "已解决该举报。",
  unresolveReport: "已撤销解决该举报。",
  passwordReset: "您的密码已重置。",
  fetchPostOnHome: "正在尝试从您的主实例上获取此帖...",
  loginRefresh: "您的登录已被刷新。",
  invalidLogin: "提供的凭据有误",
  confirmDelete1: "您确定要删除您的帐户吗？",
  confirmDelete2: "你真的确定吗？",
  deleting: "正在删除您的帐户...",
  deleted: "您的帐户已被删除。",
  resetSettings: "您是否想将设置重置为默认值？",
  failFetchInstances: "无法获取可用实例。",
  failSignup: "注册失败。",
  successSignup: "已注册。",
  waitApplication: "在登录前，请先等待您的注册申请被批准。",
  blockUser: "已屏蔽该用户。",
  unblockUser: "已取消屏蔽该用户。",
  purgeUser: "已清除该用户。",
  settingsImport: "已成功导入设置",
  userLoading: "仍在加载你的用户数据。。。"
};
const admin = {
  purgeCommunity: {
    warning: "这将删除所有帖子。你确定吗？（该按钮将在3秒后启用）",
    title: "清除社群"
  },
  purge: "清除",
  instance: "实例",
  label: "实例管理"
};
const message = {
  success: "成功",
  error: "错误",
  retry: "重试"
};
const comment = {
  reply: "回复",
  actions: {
    label: "操作",
    link: "复制链接"
  },
  locked: "此帖子已被锁定。",
  banned: "你已被此社群封禁。",
  more: "更多 {{comments:number}} 条"
};
const error = {
  language_not_allowed: "该语言在此社群中不被允许。请撤销语言设置以使用社群的默认语言。",
  invalid_vote_value: "抱歉，你不能在 Lemmy 帖子上进行投票欺诈。",
  incorrect_login: "登录凭据不正确。请重试。",
  email_not_verified: "你还没有验证账户邮箱。",
  passwords_do_not_match: "你输入的密码与确认密码不一致。",
  honeypot_failed: "你是... 你是机器人吗？哔哔叭噗。如果你不是，那这个检测可就失败了。",
  downvotes_are_disabled: "此实例已禁用点踩功能。",
  email_already_exists: "此邮箱已经与一个现有账户关联。",
  captcha_failed: "验证码应答失败。",
  incorrect_login_5: "我觉得你一定是按错键了。",
  incorrect_login_7: "要么你是有打字障碍，要么你是在骚扰我。",
  incorrect_login_8: "我服了。",
  incorrect_login_2: "登录凭据不正确。请重试。",
  incorrect_login_3: "登录凭据仍然不正确。需要继续重试。",
  incorrect_login_4: "登录凭据仍然不正确。继续重试。",
  incorrect_login_6: "这好玩吗？",
  incorrect_login_9: "你知道吗，你每次这么一弄，都得费老大劲传一堆数据。结果呢？登录失败。",
  incorrect_login_10: "你想过没？就因为你这些没用的请求，可怜的管理员还得维护服务器。",
  incorrect_login_11: "这次我真服了。",
  incorrect_login_12: "...",
  registration_application_is_pending: "该账户的注册申请目前尚未被接受。",
  couldnt_find_post: "该帖子不存在、不在此实例或已被删除。",
  cant_block_yourself: "你不能屏蔽自己。也不应该这么做，你是个很好的人！",
  slurs: "你提交的内容含有被此实例屏蔽的关键词。",
  cant_block_local_instance: "你不能屏蔽你正在使用的实例。",
  couldnt_find_person: "该用户不存在。",
  couldnt_find_community: "该社群不存在。"
};
const aria = {
  vote: {
    downvotes: "{{default}} 踩",
    upvotes: "{{default}} 赞",
    score: "分数: {{default}}",
    group: "帖子赞踩控制"
  },
  pagination: {
    nav: "分页",
    current: "当前页"
  }
};
const stats = {
  joined: "加入于",
  created: "创建于"
};
const zhHans = {
  form,
  routes,
  common,
  profile,
  nav,
  account,
  filter,
  cards,
  content,
  post,
  moderation,
  settings,
  toast,
  admin,
  message,
  comment,
  error,
  aria,
  stats
};
export {
  account,
  admin,
  aria,
  cards,
  comment,
  common,
  content,
  zhHans as default,
  error,
  filter,
  form,
  message,
  moderation,
  nav,
  post,
  profile,
  routes,
  settings,
  stats,
  toast
};
//# sourceMappingURL=zh-Hans.js.map
