import { e as escape_html, s as store_get, u as unsubscribe_stores } from "../../chunks/index3.js";
import { M as Material, B as Button, g as goto, e as errorMessage } from "../../chunks/client.svelte.js";
import { p as page } from "../../chunks/index4.js";
import { t } from "../../chunks/index.js";
import "clsx";
function _error($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    function getError(message) {
      try {
        return { string: errorMessage(message), code: false };
      } catch {
        return { string: message, code: true };
      }
    }
    $$renderer2.push(`<div class="flex flex-col gap-4 my-auto h-full justify-center max-w-xl w-full mx-auto">`);
    Material($$renderer2, {
      rounding: "3xl",
      padding: "xl",
      color: "error",
      class: "space-y-2",
      children: ($$renderer3) => {
        $$renderer3.push(`<h1 class="text-4xl font-medium flex items-center flex-row gap-2 font-mono">${escape_html(page.status)}</h1> `);
        if (page?.error?.message) {
          $$renderer3.push("<!--[-->");
          const error = getError(page?.error?.message);
          if (error.code) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<code class="rounded-md dark:bg-zinc-950! px-2 py-1 min-w-48">${escape_html(error.string)}</code>`);
          } else {
            $$renderer3.push("<!--[!-->");
            $$renderer3.push(`<p class="text-lg">${escape_html(error.string)}</p>`);
          }
          $$renderer3.push(`<!--]-->`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> <div class="flex items-center gap-2 px-4">`);
    Button($$renderer2, {
      size: "lg",
      onclick: () => goto(page.url, {}),
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("message.retry"))}`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Button($$renderer2, {
      href: "/",
      size: "lg",
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.home"))}`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _error as default
};
//# sourceMappingURL=_error.svelte.js.map
