import { f as bind_props, h as head, e as escape_html, s as store_get, g as await_block, u as unsubscribe_stores, b as attr, i as element, d as ensure_array_like, j as attr_style, k as stringify } from "../../chunks/index3.js";
import { b as browser } from "../../chunks/index5.js";
import { p as page } from "../../chunks/index4.js";
import { s as site, B as Button } from "../../chunks/client.svelte.js";
import { t } from "../../chunks/index.js";
import { s as settings, S as SSR_ENABLED } from "../../chunks/settings.svelte.js";
import { L as Location } from "../../chunks/Location.js";
import { S as Sort } from "../../chunks/Sort.js";
import { V as ViewSelect } from "../../chunks/ViewSelect.js";
import { V as VirtualFeed, P as PostFeed, A as ArrowRight } from "../../chunks/VirtualFeed.js";
import { S as Skeleton } from "../../chunks/Skeleton.js";
import { H as Header } from "../../chunks/Header.js";
import "@sveltejs/kit/internal";
import "../../chunks/exports.js";
import "../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import { I as Icon } from "../../chunks/Icon.js";
import { P as Pageination } from "../../chunks/Pageination.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data = void 0 } = $$props;
    const FeedComponent = settings.infiniteScroll && browser ? VirtualFeed : PostFeed;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>
    ${escape_html(SSR_ENABLED && site.data ? site.data.site_view.site.name : store_get($$store_subs ??= {}, "$t", t)("routes.frontpage.title"))}
  </title>`);
        });
      });
      {
        let extended = function($$renderer4) {
          $$renderer4.push(`<form class="contents" method="get"${attr("action", page.url.pathname)}><div class="flex flex-row gap-2 max-w-full">`);
          Location($$renderer4, {
            name: "type",
            navigate: true,
            get selected() {
              return data.filters.value.type_;
            },
            set selected($$value) {
              data.filters.value.type_ = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          Sort($$renderer4, {
            placement: "bottom",
            name: "sort",
            navigate: true,
            get selected() {
              return data.filters.value.sort;
            },
            set selected($$value) {
              data.filters.value.sort = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          ViewSelect($$renderer4, { placement: "bottom" });
          $$renderer4.push(`<!----> <noscript>`);
          Button($$renderer4, {
            class: "self-end h-[34px] aspect-square",
            size: "custom",
            submit: true,
            children: ($$renderer5) => {
              Icon($$renderer5, { src: ArrowRight, size: "16", micro: true });
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----></noscript></div></form>`);
        };
        Header($$renderer3, {
          pageHeader: true,
          extended,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.frontpage.title"))}`);
          }
        });
      }
      $$renderer3.push(`<!----> `);
      await_block(
        $$renderer3,
        data.feed.value,
        () => {
          $$renderer3.push(`<div class="space-y-4"><!--[-->`);
          const each_array = ensure_array_like(new Array(5));
          for (let index = 0, $$length = each_array.length; index < $$length; index++) {
            let _ = each_array[index];
            $$renderer3.push(`<!---->${escape_html(_)} <div class="animate-pop-in"${attr_style(`animation-delay: ${stringify(index * 50)}ms; opacity: 0; width: ${stringify(1 / ((index + 1) % 3) * 100)}%`)}>`);
            Skeleton($$renderer3);
            $$renderer3.push(`<!----></div>`);
          }
          $$renderer3.push(`<!--]--></div>`);
        },
        (feed) => {
          var bind_get = () => feed.client.lastSeen ?? 0;
          var bind_set = (v) => feed.client.lastSeen = v;
          $$renderer3.push(`<!---->`);
          FeedComponent($$renderer3, {
            get lastSeen() {
              return bind_get();
            },
            set lastSeen($$value) {
              bind_set($$value);
            },
            virtualList: { itemHeights: feed.client?.itemHeights ?? [] },
            get posts() {
              return feed.posts;
            },
            set posts($$value) {
              feed.posts = $$value;
              $$settled = false;
            },
            get params() {
              return feed.params;
            },
            set params($$value) {
              feed.params = $$value;
              $$settled = false;
            }
          });
          $$renderer3.push(`<!----> `);
          element($$renderer3, settings.infiniteScroll && !settings.posts.noVirtualize ? "noscript" : "div", void 0, () => {
            Pageination($$renderer3, {
              cursor: { next: feed.next_page },
              href: (page2) => typeof page2 == "number" ? `?page=${page2}` : `?cursor=${page2}`,
              back: false
            });
          });
        }
      );
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { data });
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
