import { R as ReactiveState, d as awaitIfServer, c as client } from "../../chunks/client.svelte.js";
import { t } from "../../chunks/index.js";
import { s as settings } from "../../chunks/settings.svelte.js";
import { f as feed } from "../../chunks/feed.svelte.js";
import { C as ChevronDoubleUp } from "../../chunks/ChevronDoubleUp.js";
async function load({ url, fetch, route }) {
  const cursor = url.searchParams.get("cursor");
  const sort = url.searchParams.get("sort") || settings.defaultSort.sort;
  const listingType = url.searchParams.get("type") || settings.defaultSort.feed;
  const feedData = feed(route.id, async (params) => {
    const posts = await client({ func: fetch }).getPosts(params);
    return {
      ...posts,
      params: { ...params, page_cursor: posts.next_page },
      client: {}
    };
  }).load({
    page_cursor: cursor,
    sort,
    type_: listingType,
    limit: 20,
    show_hidden: settings.posts.showHidden
  });
  return {
    feed: new ReactiveState((await awaitIfServer(feedData)).data),
    filters: new ReactiveState({
      sort,
      type_: listingType
    }),
    contextual: {
      actions: [
        {
          name: t.get("routes.post.scrollToTop"),
          handle: () => window?.scrollTo({ top: 0, behavior: "instant" }),
          icon: ChevronDoubleUp
        }
      ]
    }
  };
}
export {
  load
};
//# sourceMappingURL=_page.ts.js.map
