import { h as head, e as escape_html, s as store_get, d as ensure_array_like, a as attr_class, b as attr, c as clsx, u as unsubscribe_stores } from "../../../chunks/index3.js";
import { p as profile, D as DEFAULT_INSTANCE_URL, L as LINKED_INSTANCE_URL, b as Badge, F as DEFAULT_CLIENT_TYPE, B as Button, o as Plus } from "../../../chunks/client.svelte.js";
import { t } from "../../../chunks/index.js";
import { s as settings } from "../../../chunks/settings.svelte.js";
import { P as ProfileAvatar } from "../../../chunks/ProfileAvatar.js";
import { P as Placeholder } from "../../../chunks/Placeholder.js";
import { H as Header } from "../../../chunks/Header.js";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import { C as CommonList } from "../../../chunks/CommonList.js";
import { I as Icon } from "../../../chunks/Icon.js";
import { A as ArrowLeftOnRectangle } from "../../../chunks/ArrowLeftOnRectangle.js";
import { B as BugAnt } from "../../../chunks/BugAnt.js";
import { C as ChevronDown } from "../../../chunks/ChevronDown.js";
import { C as ChevronUp } from "../../../chunks/ChevronUp.js";
import { E as EllipsisHorizontal } from "../../../chunks/EllipsisHorizontal.js";
import { I as Identification } from "../../../chunks/Identification.js";
import { Q as QuestionMarkCircle } from "../../../chunks/QuestionMarkCircle.js";
import { M as Modal } from "../../../chunks/Modal.js";
import { M as Menu, a as MenuButton } from "../../../chunks/MenuButton.js";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
import "@dicebear/core";
import "@dicebear/initials";
import DebugObject from "../../../chunks/DebugObject.js";
const ArrowRightOnRectangle = {
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M3 4.25A2.25 2.25 0 0 1 5.25 2h5.5A2.25 2.25 0 0 1 13 4.25v2a.75.75 0 0 1-1.5 0v-2a.75.75 0 0 0-.75-.75h-5.5a.75.75 0 0 0-.75.75v11.5c0 .414.336.75.75.75h5.5a.75.75 0 0 0 .75-.75v-2a.75.75 0 0 1 1.5 0v2A2.25 2.25 0 0 1 10.75 18h-5.5A2.25 2.25 0 0 1 3 15.75V4.25Z",
        "clip-rule": "evenodd"
      },
      {
        "fill-rule": "evenodd",
        "d": "M6 10a.75.75 0 0 1 .75-.75h9.546l-1.048-.943a.75.75 0 1 1 1.004-1.114l2.5 2.25a.75.75 0 0 1 0 1.114l-2.5 2.25a.75.75 0 1 1-1.004-1.114l1.048-.943H6.75A.75.75 0 0 1 6 10Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M15.75 9V5.25A2.25 2.25 0 0 0 13.5 3h-6a2.25 2.25 0 0 0-2.25 2.25v13.5A2.25 2.25 0 0 0 7.5 21h6a2.25 2.25 0 0 0 2.25-2.25V15m3 0 3-3m0 0-3-3m3 3H9"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M7.5 3.75A1.5 1.5 0 0 0 6 5.25v13.5a1.5 1.5 0 0 0 1.5 1.5h6a1.5 1.5 0 0 0 1.5-1.5V15a.75.75 0 0 1 1.5 0v3.75a3 3 0 0 1-3 3h-6a3 3 0 0 1-3-3V5.25a3 3 0 0 1 3-3h6a3 3 0 0 1 3 3V9A.75.75 0 0 1 15 9V5.25a1.5 1.5 0 0 0-1.5-1.5h-6Zm10.72 4.72a.75.75 0 0 1 1.06 0l3 3a.75.75 0 0 1 0 1.06l-3 3a.75.75 0 1 1-1.06-1.06l1.72-1.72H9a.75.75 0 0 1 0-1.5h10.94l-1.72-1.72a.75.75 0 0 1 0-1.06Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let debugging = false;
    let debugProfile = void 0;
    let removing = { shown: false, account: void 0 };
    let radioSelected = profile.current.id;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.accounts"))}</title>`);
        });
      });
      if (debugging) {
        $$renderer3.push("<!--[-->");
        {
          let title = function($$renderer4) {
            $$renderer4.push(`<span class="flex flex-col"><h1 class="font-bold text-2xl">Debug</h1> <span class="text-slate-600 dark:text-zinc-400 text-base font-normal">Do NOT share anything from this menu.</span></span>`);
          };
          DebugObject($$renderer3, {
            object: debugProfile?.id == profile.current?.id ? profile.current : debugProfile,
            get open() {
              return debugging;
            },
            set open($$value) {
              debugging = $$value;
              $$settled = false;
            },
            title,
            $$slots: { title: true }
          });
        }
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (removing.shown && removing.account) {
        $$renderer3.push("<!--[-->");
        {
          let customTitle = function($$renderer4) {
            $$renderer4.push(`<span>${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.logout"))}</span>`);
          };
          Modal($$renderer3, {
            get open() {
              return removing.shown;
            },
            set open($$value) {
              removing.shown = $$value;
              $$settled = false;
            },
            customTitle,
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="flex flex-row items-center gap-2">`);
              ProfileAvatar($$renderer4, { profile: removing.account, selected: true });
              $$renderer4.push(`<!----> <div class="flex flex-col"><span class="font-bold">${escape_html(removing.account.username)}</span> <span class="text-sm text-slate-600 dark:text-zinc-400">${escape_html(removing.account.instance)}</span></div></div> <div class="flex flex-row gap-2 items-center">`);
              Button($$renderer4, {
                size: "lg",
                class: "flex-1",
                onclick: () => removing.shown = false,
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Cancel`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                onclick: () => {
                  removing.shown = false;
                  if (removing.account) profile.remove(removing.account.id);
                },
                size: "lg",
                class: "flex-1",
                color: "danger",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Remove`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { customTitle: true, default: true }
          });
        }
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      {
        let extended = function($$renderer4) {
          $$renderer4.push(`<div class="flex gap-2 items-center flex-wrap">`);
          Button($$renderer4, {
            href: "/accounts/login",
            color: "primary",
            size: "lg",
            rounding: "2xl",
            icon: ArrowLeftOnRectangle,
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.login"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Button($$renderer4, {
            href: "/signup",
            size: "lg",
            rounding: "2xl",
            icon: Identification,
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.signup"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          if (!LINKED_INSTANCE_URL) {
            $$renderer4.push("<!--[-->");
            Button($$renderer4, {
              href: "/accounts/login/guest",
              size: "lg",
              rounding: "2xl",
              icon: Plus,
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.addGuest"))}`);
              },
              $$slots: { default: true }
            });
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--></div>`);
        };
        Header($$renderer3, {
          pageHeader: true,
          extended,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.accounts"))}`);
          }
        });
      }
      $$renderer3.push(`<!----> `);
      if (profile.meta.profiles.length == 1 && !profile.current.jwt && profile.current.instance == DEFAULT_INSTANCE_URL) {
        $$renderer3.push("<!--[-->");
        Placeholder($$renderer3, {
          icon: Identification,
          title: store_get($$store_subs ??= {}, "$t", t)("routes.accounts.placeholder.title"),
          description: LINKED_INSTANCE_URL ? store_get($$store_subs ??= {}, "$t", t)("routes.accounts.placeholder.description") : store_get($$store_subs ??= {}, "$t", t)("routes.accounts.placeholder.descriptionWithGuest"),
          class: "my-auto"
        });
      } else {
        $$renderer3.push("<!--[!-->");
        $$renderer3.push(`<form class="accounts-grid gap-4 svelte-11yx1mx">`);
        CommonList($$renderer3, {
          animate: false,
          children: ($$renderer4) => {
            $$renderer4.push(`<!--[-->`);
            const each_array = ensure_array_like(profile.meta.profiles);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let p = each_array[$$index];
              $$renderer4.push(`<li${attr_class(clsx(["xs px-4 py-1", p.id == profile.meta.profile && "selected"]))}><label class="relative block"><input type="radio"${attr("id", p.id.toString())} name="profile"${attr("value", p.id)} class="hidden peer"${attr("checked", radioSelected === p.id, true)}/> <div${attr_class(clsx([
                "flex flex-row items-center gap-2 transition-all duration-75",
                "cursor-pointer relative ring-transparent"
              ]))}><div class="absolute -inset-2 -inset-x-3 sm:-inset-y-3 sm:-inset-x-4 group-first/li:rounded-t-2xl group-last/li:rounded-b-2xl rounded-md ring-2 ring-inherit"></div> `);
              ProfileAvatar($$renderer4, { profile: p, selected: profile?.current.id == p.id, size: 24 });
              $$renderer4.push(`<!----> <div class="flex flex-col overflow-hidden"><span class="break-words font-medium text-base">${escape_html(p.username)} `);
              if (!p.jwt) {
                $$renderer4.push("<!--[-->");
                Badge($$renderer4, {
                  class: "inline-grid w-6 h-6 p-0! place-items-center",
                  children: ($$renderer5) => {
                    Icon($$renderer5, { src: QuestionMarkCircle, size: "16", micro: true });
                  },
                  $$slots: { default: true }
                });
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--></span> `);
              if (!LINKED_INSTANCE_URL) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<span class="text-xs text-slate-600 dark:text-zinc-400"><span class="capitalize">${escape_html(p.client?.name ?? DEFAULT_CLIENT_TYPE.name)}</span> • ${escape_html(p.instance)}</span>`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--></div> `);
              {
                let target = function($$renderer5, attachment) {
                  Button($$renderer5, {
                    size: "square-md",
                    color: "tertiary",
                    class: "justify-self-end ml-auto z-50",
                    "aria-label": store_get($$store_subs ??= {}, "$t", t)("post.actions.more.label"),
                    icon: EllipsisHorizontal
                  });
                };
                Menu($$renderer4, {
                  placement: "bottom-end",
                  target,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<div class="px-4 py-2 flex items-center gap-2">`);
                    Button($$renderer5, {
                      size: "square-md",
                      color: "secondary",
                      title: store_get($$store_subs ??= {}, "$t", t)("account.moveUp"),
                      onclick: () => profile.move(p.id, true),
                      icon: ChevronUp
                    });
                    $$renderer5.push(`<!----> `);
                    Button($$renderer5, {
                      size: "square-md",
                      color: "secondary",
                      title: store_get($$store_subs ??= {}, "$t", t)("account.moveDown"),
                      onclick: () => profile.move(p.id, false),
                      icon: ChevronDown
                    });
                    $$renderer5.push(`<!----></div> `);
                    if (settings.debugInfo) {
                      $$renderer5.push("<!--[-->");
                      MenuButton($$renderer5, {
                        onclick: () => {
                          debugProfile = p;
                          debugging = !debugging;
                        },
                        icon: BugAnt,
                        children: ($$renderer6) => {
                          $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.debug"))}`);
                        },
                        $$slots: { default: true }
                      });
                    } else {
                      $$renderer5.push("<!--[!-->");
                    }
                    $$renderer5.push(`<!--]--> `);
                    if (!LINKED_INSTANCE_URL || p.user) {
                      $$renderer5.push("<!--[-->");
                      MenuButton($$renderer5, {
                        onclick: () => {
                          removing.account = p;
                          removing.shown = !removing.shown;
                        },
                        color: "danger-subtle",
                        icon: ArrowRightOnRectangle,
                        children: ($$renderer6) => {
                          $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.logout"))}`);
                        },
                        $$slots: { default: true }
                      });
                    } else {
                      $$renderer5.push("<!--[!-->");
                    }
                    $$renderer5.push(`<!--]-->`);
                  },
                  $$slots: { target: true, default: true }
                });
              }
              $$renderer4.push(`<!----></div></label></li>`);
            }
            $$renderer4.push(`<!--]-->`);
          }
        });
        $$renderer3.push(`<!----></form>`);
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
