import { g as await_block, e as escape_html, s as store_get, u as unsubscribe_stores } from "../../../../chunks/index3.js";
import { t } from "../../../../chunks/index.js";
import { C as CommentItem } from "../../../../chunks/CommentItem.js";
import { C as CommunityItem } from "../../../../chunks/CommunityItem.js";
import { y as Spinner } from "../../../../chunks/client.svelte.js";
import "../../../../chunks/settings.svelte.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import "@sveltejs/kit";
import "lemmy-js-client";
import "openapi-fetch";
import "@dicebear/core";
import "@dicebear/initials";
import { P as PostItem } from "../../../../chunks/PostItem.js";
import { U as UserItem } from "../../../../chunks/UserItem.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div class="flex flex-col items-center justify-center h-full gap-3">`);
      await_block(
        $$renderer3,
        data.resolved,
        () => {
          Spinner($$renderer3, { width: 32 });
          $$renderer3.push(`<!----> <span class="font-medium text-lg">${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.search.federating"))}...</span>`);
        },
        (object) => {
          $$renderer3.push(`<div class="w-full max-w-md">`);
          if (object.community) {
            $$renderer3.push("<!--[-->");
            CommunityItem($$renderer3, {
              get community() {
                return object.community;
              },
              set community($$value) {
                object.community = $$value;
                $$settled = false;
              }
            });
          } else {
            $$renderer3.push("<!--[!-->");
            if (object.person) {
              $$renderer3.push("<!--[-->");
              UserItem($$renderer3, { user: object.person });
            } else {
              $$renderer3.push("<!--[!-->");
              if (object.post) {
                $$renderer3.push("<!--[-->");
                PostItem($$renderer3, { post: object.post });
              } else {
                $$renderer3.push("<!--[!-->");
                if (object.comment) {
                  $$renderer3.push("<!--[-->");
                  CommentItem($$renderer3, { comment: object.comment });
                } else {
                  $$renderer3.push("<!--[!-->");
                }
                $$renderer3.push(`<!--]-->`);
              }
              $$renderer3.push(`<!--]-->`);
            }
            $$renderer3.push(`<!--]-->`);
          }
          $$renderer3.push(`<!--]--></div>`);
        }
      );
      $$renderer3.push(`<!--]--></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
