import { e as escape_html, s as store_get, u as unsubscribe_stores } from "../../../chunks/index3.js";
import { p as profile, b as Badge } from "../../../chunks/client.svelte.js";
import { t } from "../../../chunks/index.js";
import { T as Tabs } from "../../../chunks/Tabs.js";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import "../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
import "@dicebear/core";
import "@dicebear/initials";
function _layout($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { children } = $$props;
    $$renderer2.push(`<!--[-->`);
    {
      const notifications = profile.inbox.notifications;
      if (notifications.applications > 0) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<span class="flex flex-row text-red-500 gap-2">`);
        Badge($$renderer2, {
          color: "red-subtle",
          class: "w-max",
          children: ($$renderer3) => {
            $$renderer3.push(`<!---->${escape_html(notifications.applications > 99 ? "∞" : notifications.applications)}`);
          },
          $$slots: { default: true }
        });
        $$renderer2.push(`<!----> unread applications</span>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--> `);
    Tabs($$renderer2, {
      routes: [
        {
          href: "/admin/config",
          name: store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.title")
        },
        {
          href: "/admin/applications",
          name: store_get($$store_subs ??= {}, "$t", t)("routes.admin.applications.title")
        },
        {
          href: "/admin/taglines",
          name: store_get($$store_subs ??= {}, "$t", t)("routes.admin.taglines.title")
        },
        {
          href: "/admin/team",
          name: store_get($$store_subs ??= {}, "$t", t)("routes.admin.team.title")
        },
        {
          href: "/admin/federation",
          name: store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.title")
        },
        {
          href: "/admin/media",
          name: store_get($$store_subs ??= {}, "$t", t)("routes.admin.media.title")
        }
      ]
    });
    $$renderer2.push(`<!----> <div class="flex flex-col gap-4 h-full">`);
    children?.($$renderer2);
    $$renderer2.push(`<!----></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _layout as default
};
//# sourceMappingURL=_layout.svelte.js.map
