import { c as client, R as ReactiveState } from "../../../../chunks/client.svelte.js";
async function load({ fetch, url }) {
  const page = Number(url.searchParams.get("page")) || 1;
  const type = url.searchParams.get("type") || "unread";
  const res = await client({ func: fetch }).listRegistrationApplications({
    page,
    limit: 40,
    unread_only: type == "unread"
  });
  return {
    page,
    applications: new ReactiveState(res.registration_applications),
    type: new ReactiveState(type)
  };
}
export {
  load
};
//# sourceMappingURL=_page.ts.js.map
