import { h as head, e as escape_html, s as store_get, d as ensure_array_like, u as unsubscribe_stores } from "../../../../chunks/index3.js";
import { M as Material, s as site, b as Badge, o as Plus, B as Button } from "../../../../chunks/client.svelte.js";
import { t } from "../../../../chunks/index.js";
import { M as MarkdownEditor } from "../../../../chunks/MarkdownEditor.js";
import { I as ImageInputUpload } from "../../../../chunks/ImageInputUpload.js";
import { H as Header } from "../../../../chunks/Header.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { L as Label } from "../../../../chunks/Label.js";
import { T as TextInput } from "../../../../chunks/TextInput.js";
import { S as Select, O as Option } from "../../../../chunks/Select.js";
import { S as Switch } from "../../../../chunks/Switch.js";
import { I as Icon } from "../../../../chunks/Icon.js";
import { M as Menu, a as MenuButton } from "../../../../chunks/MenuButton.js";
import "../../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@dicebear/core";
import "@dicebear/initials";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data: pageData } = $$props;
    let data = pageData;
    const formData = data.site ? {
      ...data.site.site_view.local_site,
      ...data.site.site_view.site,
      discussion_languages: data.site.discussion_languages
    } : void 0;
    let saving = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.title"))}</title>`);
        });
      });
      $$renderer3.push(`<form class="flex flex-col gap-4">`);
      Header($$renderer3, {
        pageHeader: true,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.title"))}`);
        }
      });
      $$renderer3.push(`<!----> `);
      if (formData) {
        $$renderer3.push("<!--[-->");
        var bind_get = () => formData.name ?? "";
        var bind_set = (v) => formData.description = v;
        var bind_get_1 = () => formData.description ?? "";
        var bind_set_1 = (v) => formData.description = v;
        var bind_get_2 = () => formData.sidebar ?? "";
        var bind_set_2 = (v) => formData.sidebar = v;
        var bind_get_3 = () => formData.legal_information ?? "";
        var bind_set_3 = (v) => formData.legal_information = v;
        TextInput($$renderer3, {
          get value() {
            return bind_get();
          },
          set value($$value) {
            bind_set($$value);
          },
          label: store_get($$store_subs ??= {}, "$t", t)("form.name")
        });
        $$renderer3.push(`<!----> `);
        TextInput($$renderer3, {
          get value() {
            return bind_get_1();
          },
          set value($$value) {
            bind_set_1($$value);
          },
          label: store_get($$store_subs ??= {}, "$t", t)("form.description")
        });
        $$renderer3.push(`<!----> `);
        MarkdownEditor($$renderer3, {
          previewButton: true,
          get value() {
            return bind_get_2();
          },
          set value($$value) {
            bind_set_2($$value);
          },
          label: store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.sidebar")
        });
        $$renderer3.push(`<!----> `);
        MarkdownEditor($$renderer3, {
          previewButton: true,
          get value() {
            return bind_get_3();
          },
          set value($$value) {
            bind_set_3($$value);
          },
          label: store_get($$store_subs ??= {}, "$t", t)("routes.legal.title")
        });
        $$renderer3.push(`<!----> `);
        ImageInputUpload($$renderer3, {
          label: store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.icon"),
          get imageUrl() {
            return formData.icon;
          },
          set imageUrl($$value) {
            formData.icon = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----> `);
        ImageInputUpload($$renderer3, {
          label: store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.banner"),
          get imageUrl() {
            return formData.banner;
          },
          set imageUrl($$value) {
            formData.banner = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----> `);
        Switch($$renderer3, {
          get checked() {
            return formData.enable_downvotes;
          },
          set checked($$value) {
            formData.enable_downvotes = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.downvotesEnabled"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Switch($$renderer3, {
          get checked() {
            return formData.enable_nsfw;
          },
          set checked($$value) {
            formData.enable_nsfw = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.nsfwEnabled"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Select($$renderer3, {
          label: store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.registration.label"),
          class: "w-max",
          get value() {
            return formData.registration_mode;
          },
          set value($$value) {
            formData.registration_mode = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            Option($$renderer4, {
              value: "Open",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.registration.open"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "RequireApplication",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.registration.application"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "Closed",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.registration.closed"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        if (formData.registration_mode == "RequireApplication") {
          $$renderer3.push("<!--[-->");
          MarkdownEditor($$renderer3, {
            previewButton: true,
            label: store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.applicationQuestion"),
            get value() {
              return formData.application_question;
            },
            set value($$value) {
              formData.application_question = $$value;
              $$settled = false;
            }
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        Switch($$renderer3, {
          get checked() {
            return formData.community_creation_admin_only;
          },
          set checked($$value) {
            formData.community_creation_admin_only = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.adminCommunityOnly"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Switch($$renderer3, {
          get checked() {
            return formData.require_email_verification;
          },
          set checked($$value) {
            formData.require_email_verification = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.requireVerifyEmail"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Switch($$renderer3, {
          get checked() {
            return formData.application_email_admins;
          },
          set checked($$value) {
            formData.application_email_admins = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.emailAdminsOnApplication"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Switch($$renderer3, {
          get checked() {
            return formData.reports_email_admins;
          },
          set checked($$value) {
            formData.reports_email_admins = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.emailAdminsOnReport"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Select($$renderer3, {
          label: store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.listingType.label"),
          class: "w-max",
          get value() {
            return formData.default_post_listing_type;
          },
          set value($$value) {
            formData.default_post_listing_type = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            Option($$renderer4, {
              value: "All",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.listingType.all"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "Local",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.listingType.local"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Switch($$renderer3, {
          get checked() {
            return formData.private_instance;
          },
          set checked($$value) {
            formData.private_instance = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.private"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Switch($$renderer3, {
          get checked() {
            return formData.hide_modlog_mod_names;
          },
          set checked($$value) {
            formData.hide_modlog_mod_names = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.hideModlogModNames"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        TextInput($$renderer3, {
          label: store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.slurFilter"),
          placeholder: "(word1|word2)",
          get value() {
            return formData.slur_filter_regex;
          },
          set value($$value) {
            formData.slur_filter_regex = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----> `);
        Switch($$renderer3, {
          get checked() {
            return formData.federation_enabled;
          },
          set checked($$value) {
            formData.federation_enabled = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.federation"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Switch($$renderer3, {
          get checked() {
            return formData.federation_debug;
          },
          set checked($$value) {
            formData.federation_debug = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.federationDebug"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Switch($$renderer3, {
          get checked() {
            return formData.captcha_enabled;
          },
          set checked($$value) {
            formData.captcha_enabled = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.captcha.enabled"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> <div class="space-y-1">`);
        Label($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.profile.languages.title"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> <p>${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.profile.languages.description"))}</p> `);
        Material($$renderer3, {
          rounding: "xl",
          color: "uniform",
          class: "dark:bg-zinc-950",
          children: ($$renderer4) => {
            if (site.data) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="flex gap-2 flex-wrap flex-row">`);
              {
                let target = function($$renderer5, attachment) {
                  $$renderer5.push(`<button type="button">`);
                  Badge($$renderer5, {
                    color: "blue-subtle",
                    children: ($$renderer6) => {
                      Icon($$renderer6, { src: Plus, micro: true, size: "14" });
                      $$renderer6.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.add"))}`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----></button>`);
                };
                Menu($$renderer4, {
                  class: "gap-px",
                  target,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!--[-->`);
                    const each_array = ensure_array_like(site.data.all_languages.filter((l) => !formData.discussion_languages?.includes(l.id)));
                    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                      let language = each_array[$$index];
                      MenuButton($$renderer5, {
                        class: "min-h-[16px] py-0",
                        onclick: () => {
                          formData.discussion_languages?.push(language.id);
                        },
                        children: ($$renderer6) => {
                          $$renderer6.push(`<!---->${escape_html(language.name)}`);
                        },
                        $$slots: { default: true }
                      });
                    }
                    $$renderer5.push(`<!--]-->`);
                  },
                  $$slots: { target: true, default: true }
                });
              }
              $$renderer4.push(`<!----> <!--[-->`);
              const each_array_1 = ensure_array_like(formData.discussion_languages ?? []);
              for (let index = 0, $$length = each_array_1.length; index < $$length; index++) {
                let languageId = each_array_1[index];
                const language = site.data.all_languages.find((l) => l.id == languageId);
                $$renderer4.push(`<button type="button" class="hover:brightness-150 transition-all">`);
                Badge($$renderer4, {
                  class: "cursor-pointer",
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(language?.name)}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----></button>`);
              }
              $$renderer4.push(`<!--]--></div>`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      Button($$renderer3, {
        color: "primary",
        size: "lg",
        loading: saving,
        disabled: saving,
        submit: true,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.save"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></form>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
