import { a as attr_class, e as escape_html, b as attr, f as bind_props, k as stringify, d as ensure_array_like, h as head, s as store_get, u as unsubscribe_stores } from "../../../../chunks/index3.js";
import { B as Button, M as Material, q as publishedToDate, o as Plus, p as profile, c as client, t as toast, e as errorMessage } from "../../../../chunks/client.svelte.js";
import { t } from "../../../../chunks/index.js";
import { P as Placeholder } from "../../../../chunks/Placeholder.js";
import { H as Header } from "../../../../chunks/Header.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { g as generateID } from "../../../../chunks/helper.js";
import { L as Label } from "../../../../chunks/Label.js";
import { T as TextInput } from "../../../../chunks/TextInput.js";
import { I as Icon } from "../../../../chunks/Icon.js";
import { C as Check } from "../../../../chunks/Check.js";
import { E as ExclamationTriangle } from "../../../../chunks/ExclamationTriangle.js";
import { X as XMark } from "../../../../chunks/XMark.js";
import { P as Popover } from "../../../../chunks/Popover.js";
import "../../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@dicebear/core";
import "@dicebear/initials";
import { R as RelativeDate } from "../../../../chunks/RelativeDate.js";
function FileInput($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      accept = "*",
      id = generateID(),
      files = void 0,
      multiple = false,
      preview = true,
      label = void 0,
      class: clazz = "",
      customLabel,
      button,
      choose
    } = $$props;
    let previewURLs = preview && files ? Array.from(files).map(URL.createObjectURL) : void 0;
    $$renderer2.push(`<div${attr_class(`flex flex-col gap-1 ${stringify(clazz)}`)}>`);
    if (customLabel || label) {
      $$renderer2.push("<!--[-->");
      Label($$renderer2, {
        for: id,
        text: label,
        children: ($$renderer3) => {
          customLabel?.($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <label class="w-max relative cursor-pointer space-x-2 flex flex-row items-center">`);
    if (button) {
      $$renderer2.push("<!--[-->");
      button($$renderer2);
      $$renderer2.push(`<!---->`);
    } else {
      $$renderer2.push("<!--[!-->");
      Button($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<!---->Browse`);
        },
        $$slots: { default: true }
      });
    }
    $$renderer2.push(`<!--]--> `);
    if (previewURLs) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="flex flex-row items-center -space-x-1 hover:space-x-1 z-20 h-8"><!--[-->`);
      const each_array = ensure_array_like(previewURLs);
      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
        let file = each_array[$$index];
        $$renderer2.push(`<img${attr("src", file)} alt="" class="w-8 h-8 object-cover rounded-full hover:w-16 hover:h-16 transition-all border border-slate-200 ring-1 ring-slate-50 dark:ring-zinc-950 bg-white dark:bg-zinc-950" onload="this.__e=event"/>`);
      }
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <span class="flex flex-row items-center text-slate-600 dark:text-zinc-400">`);
    if (choose) {
      $$renderer2.push("<!--[-->");
      choose($$renderer2);
      $$renderer2.push(`<!---->`);
    } else {
      $$renderer2.push("<!--[!-->");
      if ((files ?? []).length == 0) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`No file selected.`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`${escape_html((files ?? []).length)} files selected`);
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></span> <input type="file"${attr("accept", accept)}${attr("multiple", multiple, true)} class="w-full h-full inset-0 opacity-0 absolute cursor-pointer"/></label></div>`);
    bind_props($$props, { files });
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data = void 0 } = $$props;
    let blockInstance = { instance: "", loading: false }, allowInstance = { instance: "", loading: false }, saving = false;
    async function save() {
      try {
        if (!profile.current?.jwt || !data.instances.value?.blocked) return;
        saving = true;
        const blockedInstances = data.instances.value.blocked.map((i) => i.domain);
        const allowedInstances = data.instances.value.allowed?.map((i) => i.domain);
        await client().editSite({
          allowed_instances: allowedInstances,
          blocked_instances: blockedInstances
        });
        toast({
          content: store_get($$store_subs ??= {}, "$t", t)("toast.updatedSite"),
          type: "success"
        });
      } catch (err) {
        toast({ content: errorMessage(err), type: "error" });
      }
      saving = false;
    }
    let csv = void 0;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.title"))}</title>`);
        });
      });
      Header($$renderer3, {
        pageHeader: true,
        class: "font-bold text-2xl flex items-center justify-between",
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.title"))} `);
          Button($$renderer4, {
            color: "primary",
            onclick: save,
            loading: saving,
            disabled: saving,
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.save"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!---->`);
        }
      });
      $$renderer3.push(`<!----> `);
      if (data.site && data.instances.value?.blocked) {
        $$renderer3.push("<!--[-->");
        {
          let button = function($$renderer4) {
            Button($$renderer4, {
              class: "w-max",
              icon: Plus,
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.csv"))}`);
              },
              $$slots: { default: true }
            });
          }, choose = function($$renderer4) {
          };
          FileInput($$renderer3, {
            preview: false,
            get files() {
              return csv;
            },
            set files($$value) {
              csv = $$value;
              $$settled = false;
            },
            button,
            choose,
            $$slots: { button: true, choose: true }
          });
        }
        $$renderer3.push(`<!----> <div class="flex flex-col md:flex-row gap-4"><div class="flex-1 w-full max-h-168 h-full flex flex-col gap-2"><h2 class="font-bold text-lg">${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.blocked"))}</h2> <form class="flex flex-row gap-2">`);
        TextInput($$renderer3, {
          placeholder: store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.blockplaceholder"),
          class: "flex-1",
          get value() {
            return blockInstance.instance;
          },
          set value($$value) {
            blockInstance.instance = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----> `);
        Button($$renderer3, {
          submit: true,
          loading: blockInstance.loading,
          disabled: blockInstance.loading,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.block"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></form> `);
        Material($$renderer3, {
          class: "h-full overflow-auto",
          color: "uniform",
          rounding: "2xl",
          children: ($$renderer4) => {
            $$renderer4.push(`<ul${attr_class(`*:py-3 dark:divide-zinc-800! ${stringify(allowInstance.instance != "" ? "opacity-50" : "")}`)}>`);
            if (data.instances.value.blocked.length > 0) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<!--[-->`);
              const each_array = ensure_array_like(data.instances.value.blocked.toSorted((b, a) => b.domain.localeCompare(a.domain)));
              for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                let instance = each_array[$$index];
                $$renderer4.push(`<div class="flex justify-between items-center first:pt-0 last:pb-0"><div class="flex flex-col"><span class="font-medium">${escape_html(instance.domain)}</span> <span class="text-xs text-slate-600 dark:text-zinc-400 capitalize">${escape_html(instance.software ?? "Unknown")} • `);
                RelativeDate($$renderer4, { date: publishedToDate(instance.published) });
                $$renderer4.push(`<!----></span></div> `);
                Button($$renderer4, {
                  size: "square-md",
                  onclick: () => {
                    if (!data.instances.value?.blocked) return;
                    data.instances.value.blocked = data.instances.value?.blocked.filter((i) => i.id != instance.id);
                  },
                  icon: XMark
                });
                $$renderer4.push(`<!----></div>`);
              }
              $$renderer4.push(`<!--]-->`);
            } else {
              $$renderer4.push("<!--[!-->");
              Placeholder($$renderer4, {
                icon: Check,
                title: store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.emptyBlock.title"),
                description: store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.emptyBlock.description")
              });
            }
            $$renderer4.push(`<!--]--></ul>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></div> <div class="md:flex-1 w-full max-h-168 flex flex-col gap-2"><h2 class="font-bold text-lg flex items-center space-x-1"><span>${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.allowed"))}</span> `);
        if (allowInstance.instance || !(data.instances.value.allowed?.length == 0)) {
          $$renderer3.push("<!--[-->");
          {
            let target = function($$renderer4, attachment) {
              Icon($$renderer4, {
                src: ExclamationTriangle,
                solid: true,
                class: "text-yellow-500",
                size: "20"
              });
            };
            Popover($$renderer3, {
              openOnHover: true,
              placement: "bottom-end",
              target,
              children: ($$renderer4) => {
                $$renderer4.push(`<p class="font-normal">${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.emptyAllow.description"))}</p>`);
              },
              $$slots: { target: true, default: true }
            });
          }
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></h2> <form class="flex flex-row gap-2">`);
        TextInput($$renderer3, {
          placeholder: store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.allowplaceholder"),
          class: "flex-1",
          get value() {
            return allowInstance.instance;
          },
          set value($$value) {
            allowInstance.instance = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----> `);
        Button($$renderer3, {
          submit: true,
          loading: allowInstance.loading,
          disabled: allowInstance.loading,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.allow"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></form> `);
        Material($$renderer3, {
          class: "h-full overflow-auto",
          color: "uniform",
          rounding: "2xl",
          children: ($$renderer4) => {
            $$renderer4.push(`<ul class="*:py-3 dark:divide-zinc-800!">`);
            if (data.instances.value.allowed && (data?.instances?.value?.allowed?.length ?? 0) > 0) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<!--[-->`);
              const each_array_1 = ensure_array_like(data.instances.value.allowed.toSorted((b, a) => b.domain.localeCompare(a.domain)));
              for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
                let instance = each_array_1[$$index_1];
                $$renderer4.push(`<div class="flex justify-between items-center first:pt-0 last:pb-0"><div class="flex flex-col"><span class="font-medium">${escape_html(instance.domain)}</span> <span class="text-xs text-slate-600 dark:text-zinc-400 capitalize">${escape_html(instance.software ?? "Unknown")} • `);
                RelativeDate($$renderer4, { date: publishedToDate(instance.published) });
                $$renderer4.push(`<!----></span></div> `);
                Button($$renderer4, {
                  size: "square-md",
                  onclick: () => {
                    if (!data.instances.value?.allowed) return;
                    data.instances.value.allowed = data.instances.value?.allowed.filter((i) => i.id != instance.id);
                  },
                  icon: XMark
                });
                $$renderer4.push(`<!----></div>`);
              }
              $$renderer4.push(`<!--]-->`);
            } else {
              $$renderer4.push("<!--[!-->");
              $$renderer4.push(`<div class="my-auto h-max">`);
              Placeholder($$renderer4, {
                icon: Check,
                title: store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.emptyAllow.title"),
                description: store_get($$store_subs ??= {}, "$t", t)("routes.admin.federation.emptyAllow.description")
              });
              $$renderer4.push(`<!----></div>`);
            }
            $$renderer4.push(`<!--]--></ul>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { data });
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
