import { e as escape_html, s as store_get, u as unsubscribe_stores } from "../../../../chunks/index3.js";
import { B as Button, o as Plus, i as Markdown, p as profile, a as getClient, t as toast, e as errorMessage } from "../../../../chunks/client.svelte.js";
import { t } from "../../../../chunks/index.js";
import { M as MarkdownEditor } from "../../../../chunks/MarkdownEditor.js";
import { P as Placeholder } from "../../../../chunks/Placeholder.js";
import { H as Header } from "../../../../chunks/Header.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { C as CommonList } from "../../../../chunks/CommonList.js";
import { I as Icon } from "../../../../chunks/Icon.js";
import { T as Trash } from "../../../../chunks/Trash.js";
import "../../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@dicebear/core";
import "@dicebear/initials";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    let taglines = [...data.site?.taglines.map((t2) => t2.content) ?? []];
    let newTagline = "";
    let saving = false;
    async function save() {
      if (!profile.current?.jwt) return;
      saving = true;
      try {
        await getClient().editSite({ taglines });
        toast({
          content: store_get($$store_subs ??= {}, "$t", t)("toast.updatedSite"),
          type: "success"
        });
      } catch (err) {
        toast({ content: errorMessage(err), type: "error" });
      }
      saving = false;
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (taglines.length > 0) {
        $$renderer3.push("<!--[-->");
        Header($$renderer3, {
          pageHeader: true,
          class: "justify-between",
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.taglines.title"))}`);
            Button($$renderer4, {
              color: "primary",
              onclick: save,
              loading: saving,
              disabled: saving,
              size: "lg",
              class: "h-max",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.save"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          }
        });
        $$renderer3.push(`<!----> `);
        {
          let item = function($$renderer4, tagline) {
            $$renderer4.push(`<div class="flex">`);
            Markdown($$renderer4, { source: tagline, inline: true });
            $$renderer4.push(`<!----> <div class="flex gap-2 ml-auto">`);
            Button($$renderer4, {
              onclick: () => {
                taglines.splice(taglines.findIndex((i) => i == tagline), 1);
                taglines = taglines;
              },
              size: "square-md",
              children: ($$renderer5) => {
                Icon($$renderer5, { src: Trash, mini: true, size: "16" });
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></div></div>`);
          };
          CommonList($$renderer3, { items: taglines, item });
        }
        $$renderer3.push(`<!----> <form class="flex flex-col mt-auto gap-2 w-full">`);
        MarkdownEditor($$renderer3, {
          images: false,
          get value() {
            return newTagline;
          },
          set value($$value) {
            newTagline = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----> `);
        Button($$renderer3, {
          size: "lg",
          submit: true,
          icon: Plus,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.add"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></form>`);
      } else {
        $$renderer3.push("<!--[!-->");
        $$renderer3.push(`<div class="my-auto">`);
        Placeholder($$renderer3, {
          icon: Plus,
          title: store_get($$store_subs ??= {}, "$t", t)("routes.admin.taglines.empty.title"),
          description: store_get($$store_subs ??= {}, "$t", t)("routes.admin.taglines.empty.description"),
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="mt-4 max-w-xl w-full flex flex-col gap-2 text-slate-900 dark:text-zinc-50"><form class="flex flex-col gap-2 w-full">`);
            MarkdownEditor($$renderer4, {
              placeholder: store_get($$store_subs ??= {}, "$t", t)("routes.admin.taglines.add"),
              images: false,
              get value() {
                return newTagline;
              },
              set value($$value) {
                newTagline = $$value;
                $$settled = false;
              }
            });
            $$renderer4.push(`<!----> `);
            Button($$renderer4, {
              size: "lg",
              submit: true,
              icon: Plus,
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.add"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></form> `);
            Button($$renderer4, {
              onclick: save,
              color: "primary",
              size: "lg",
              class: "w-full",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.save"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></div>`);
          }
        });
        $$renderer3.push(`<!----></div>`);
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
