import { e as escape_html, s as store_get, u as unsubscribe_stores } from "../../../../chunks/index3.js";
import { B as Button, o as Plus, U as UserLink, t as toast, p as profile, c as client, e as errorMessage } from "../../../../chunks/client.svelte.js";
import { t } from "../../../../chunks/index.js";
import { U as UserAutocomplete } from "../../../../chunks/UserAutocomplete.js";
import { P as Placeholder } from "../../../../chunks/Placeholder.js";
import { H as Header } from "../../../../chunks/Header.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { C as CommonList } from "../../../../chunks/CommonList.js";
import { I as Icon } from "../../../../chunks/Icon.js";
import { Q as QuestionMarkCircle } from "../../../../chunks/QuestionMarkCircle.js";
import { T as Trash } from "../../../../chunks/Trash.js";
import "../../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@dicebear/core";
import "@dicebear/initials";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data: pageData } = $$props;
    let data = pageData;
    let adding = false;
    async function removeAdmin(id, confirm) {
      if (!confirm) return toast({
        content: store_get($$store_subs ??= {}, "$t", t)("toast.removeAdminWarning"),
        action: () => removeAdmin(id, true)
      });
      if (!profile.current?.jwt) return;
      try {
        const res = await client().addAdmin({ added: false, person_id: id });
        data.site.admins = res.admins;
        toast({
          content: store_get($$store_subs ??= {}, "$t", t)("toast.removeAdmin"),
          type: "success"
        });
      } catch (err) {
        toast({ content: errorMessage(err), type: "error" });
      }
    }
    Header($$renderer2, {
      pageHeader: true,
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.team.title"))}`);
      }
    });
    $$renderer2.push(`<!----> `);
    if (data.site) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<ul>`);
      if (data.site.admins.length <= 0) {
        $$renderer2.push("<!--[-->");
        Placeholder($$renderer2, {
          icon: QuestionMarkCircle,
          title: store_get($$store_subs ??= {}, "$t", t)("routes.admin.team.empty.title"),
          description: store_get($$store_subs ??= {}, "$t", t)("routes.admin.team.empty.description")
        });
      } else {
        $$renderer2.push("<!--[!-->");
        {
          let item = function($$renderer3, admin) {
            $$renderer3.push(`<div class="flex items-center justify-between">`);
            UserLink($$renderer3, { avatar: true, showInstance: false, user: admin.person });
            $$renderer3.push(`<!----> `);
            Button($$renderer3, {
              onclick: () => {
                removeAdmin(admin.person.id, false);
              },
              size: "square-md",
              children: ($$renderer4) => {
                Icon($$renderer4, { src: Trash, mini: true, size: "16" });
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----></div>`);
          };
          CommonList($$renderer2, {
            items: data.site?.admins ?? [],
            item
          });
        }
      }
      $$renderer2.push(`<!--]--></ul> <form class="flex flex-row gap-2 mt-auto w-full"><div class="w-full">`);
      UserAutocomplete($$renderer2, { listing_type: "All", onselect: (p) => p.id });
      $$renderer2.push(`<!----></div> `);
      Button($$renderer2, {
        loading: adding,
        disabled: adding,
        rounding: "xl",
        color: "primary",
        size: "sm",
        submit: true,
        icon: Plus,
        children: ($$renderer3) => {
          $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.add"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></form>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
