import { h as head, e as escape_html, b as attr, s as store_get, d as ensure_array_like, u as unsubscribe_stores } from "../../../../chunks/index3.js";
import { p as profile, B as Button, s as site, b as Badge, o as Plus } from "../../../../chunks/client.svelte.js";
import { o as onDestroy } from "../../../../chunks/index-server.js";
import { t } from "../../../../chunks/index.js";
import CommunityHeader from "../../../../chunks/CommunityHeader.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import { I as Icon } from "../../../../chunks/Icon.js";
import { A as ArrowRight } from "../../../../chunks/VirtualFeed.js";
import { N as Note } from "../../../../chunks/Note.js";
import "../../../../chunks/settings.svelte.js";
import { P as PostListShell } from "../../../../chunks/PostListShell.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    onDestroy(() => {
    });
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(data.community.community_view.community.title)}</title>`);
        });
        $$renderer4.push(`<meta name="og:title"${attr("content", data.community.community_view.community.title)}/> `);
        if (data.community.community_view.community.description) {
          $$renderer4.push("<!--[-->");
          $$renderer4.push(`<meta name="og:description"${attr("content", data.community.community_view.community.description)}/>`);
        } else {
          $$renderer4.push("<!--[!-->");
        }
        $$renderer4.push(`<!--]-->`);
      });
      {
        let extended = function($$renderer4) {
          CommunityHeader($$renderer4, {
            blocked: data.community.community_view.blocked,
            moderators: data.community.moderators,
            counts: data.community.community_view.counts,
            class: "w-full relative",
            compact: "lg",
            avatarCircle: false,
            get community() {
              return data.community.community_view.community;
            },
            set community($$value) {
              data.community.community_view.community = $$value;
              $$settled = false;
            },
            get subscribed() {
              return data.community.community_view.subscribed;
            },
            set subscribed($$value) {
              data.community.community_view.subscribed = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          if (data.community.community_view.blocked) {
            $$renderer4.push("<!--[-->");
            Note($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->You've blocked this community.`);
              }
            });
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--> `);
          if (profile.current.user) {
            $$renderer4.push("<!--[-->");
            if (!data.community.discussion_languages.every((l) => profile.current.user?.discussion_languages.includes(l)) && profile.current.user.discussion_languages.length > 0) {
              $$renderer4.push("<!--[-->");
              const missing = data.community.discussion_languages.filter((i) => !profile.current.user?.discussion_languages.includes(i));
              Note($$renderer4, {
                class: "p-1! pl-3! flex-col md:flex-row",
                children: ($$renderer5) => {
                  $$renderer5.push(`<div>${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.community.languageWarning"))}</div> `);
                  {
                    let suffix = function($$renderer6) {
                      Icon($$renderer6, { src: ArrowRight, size: "16", micro: true });
                    };
                    Button($$renderer5, {
                      class: "inline-block ml-auto",
                      href: "/profile/settings",
                      color: "tertiary",
                      rounding: "pill",
                      size: "md",
                      suffix,
                      children: ($$renderer6) => {
                        $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("profile.profile"))}`);
                      },
                      $$slots: { suffix: true, default: true }
                    });
                  }
                  $$renderer5.push(`<!---->`);
                }
              });
              $$renderer4.push(`<!----> <div class="flex flex-row gap-4 flex-wrap -mt-2">`);
              if (site.data?.all_languages) {
                $$renderer4.push("<!--[-->");
                const allLanguages = site.data.all_languages;
                $$renderer4.push(`<!--[-->`);
                const each_array = ensure_array_like(missing);
                for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                  let language = each_array[$$index];
                  $$renderer4.push(`<a href="/profile/settings#languages" class="inline-block w-max">`);
                  Badge($$renderer4, {
                    color: "blue-subtle",
                    children: ($$renderer5) => {
                      Icon($$renderer5, { src: Plus, size: "16", micro: true });
                      $$renderer5.push(`<!----> ${escape_html(allLanguages.find((i) => language == i.id)?.name)}`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer4.push(`<!----></a>`);
                }
                $$renderer4.push(`<!--]-->`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--></div>`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]-->`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]-->`);
        };
        PostListShell($$renderer3, {
          getParams: data.params,
          params: { sort: data.params.sort },
          get posts() {
            return data.posts;
          },
          set posts($$value) {
            data.posts = $$value;
            $$settled = false;
          },
          get cursor() {
            return data.next_page;
          },
          set cursor($$value) {
            data.next_page = $$value;
            $$settled = false;
          },
          get client() {
            return data.client;
          },
          set client($$value) {
            data.client = $$value;
            $$settled = false;
          },
          extended,
          $$slots: { extended: true }
        });
      }
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
