import { c as client } from "../../../../chunks/client.svelte.js";
import { s as settings } from "../../../../chunks/settings.svelte.js";
import { C as CommunityCard } from "../../../../chunks/CommunityCard.js";
import { f as feed } from "../../../../chunks/feed.svelte.js";
async function load({ params, fetch, url, route }) {
  const cursor = url.searchParams.get("cursor");
  const sort = url.searchParams.get("sort") || settings.defaultSort.sort;
  const feedData = await feed(route.id, async (p) => {
    const postPromise = client({ func: fetch }).getPosts(p);
    const communityPromise = client({ func: fetch }).getCommunity({
      name: p.community_name
    });
    return {
      community: await communityPromise,
      posts: (await postPromise).posts,
      next_page: (await postPromise).next_page,
      params: { ...p, page_cursor: (await postPromise).next_page },
      client: {}
    };
  }).load({
    community_name: params.name,
    sort,
    limit: 20,
    page_cursor: cursor
  });
  return {
    ...feedData,
    slots: {
      sidebar: {
        component: CommunityCard,
        props: {
          community_view: feedData?.community?.community_view,
          moderators: feedData?.community?.moderators
        }
      }
    }
  };
}
export {
  load
};
//# sourceMappingURL=_page.ts.js.map
