import { h as head, s as store_get, u as unsubscribe_stores, e as escape_html, b as attr } from "../../../../../chunks/index3.js";
import { t } from "../../../../../chunks/index.js";
import { f as fullCommunityName } from "../../../../../chunks/client.svelte.js";
import { T as Tabs } from "../../../../../chunks/Tabs.js";
import "@sveltejs/kit/internal";
import "../../../../../chunks/exports.js";
import "../../../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import "../../../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
import "@dicebear/core";
import "@dicebear/initials";
function _layout($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data, children } = $$props;
    let communityUrl = `/c/${fullCommunityName(data.community.value.community_view.community.name, data.community.value.community_view.community.actor_id)}`;
    head($$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>${escape_html(data.community.value.community_view.community.title)}</title>`);
      });
      $$renderer3.push(`<meta name="og:title"${attr("content", data.community.value.community_view.community.title)}/> `);
      if (data.community.value.community_view.community.description) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<meta name="og:description"${attr("content", data.community.value.community_view.community.description)}/>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    });
    $$renderer2.push(`<div class="flex flex-col gap-4 h-full">`);
    Tabs($$renderer2, {
      routes: [
        {
          href: `${communityUrl}/settings`,
          name: store_get($$store_subs ??= {}, "$t", t)("routes.community.settings.settings")
        },
        {
          href: `${communityUrl}/settings/team`,
          name: store_get($$store_subs ??= {}, "$t", t)("routes.community.settings.team")
        }
      ]
    });
    $$renderer2.push(`<!----> `);
    children?.($$renderer2);
    $$renderer2.push(`<!----></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _layout as default
};
//# sourceMappingURL=_layout.svelte.js.map
