import { c as client, R as ReactiveState } from "../../../../../chunks/client.svelte.js";
import { C as CommunityCard } from "../../../../../chunks/CommunityCard.js";
async function load({ fetch, params }) {
  const community = await client({ func: fetch }).getCommunity({
    name: params.name
  });
  return {
    community: new ReactiveState(community),
    slots: {
      sidebar: {
        component: CommunityCard,
        props: {
          community_view: community.community_view,
          moderators: community.moderators
        }
      }
    }
  };
}
export {
  load
};
//# sourceMappingURL=_layout.ts.js.map
