import "clsx";
import { C as CommunityForm } from "../../../../../chunks/CommunityForm.js";
import { e as escape_html } from "../../../../../chunks/index3.js";
import { h as Avatar } from "../../../../../chunks/client.svelte.js";
import { H as Header } from "../../../../../chunks/Header.js";
import "@sveltejs/kit/internal";
import "../../../../../chunks/exports.js";
import "../../../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import "../../../../../chunks/index.js";
import "../../../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
import "@dicebear/core";
import "@dicebear/initials";
function CommunityTitle($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { community } = $$props;
    $$renderer2.push(`<div class="flex flex-row gap-3 items-center">`);
    Avatar($$renderer2, { width: 48, url: community.icon, alt: community.name });
    $$renderer2.push(`<!----> <div class="flex flex-col gap-0"><h1 class="font-bold text-xl">${escape_html(community.title)}</h1> <span class="dark:text-zinc-400 text-slate-600 text-sm">!${escape_html(community.name)}@${escape_html(new URL(community.actor_id).hostname)}</span></div></div>`);
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { data } = $$props;
    $$renderer2.push(`<div class="flex flex-col gap-4">`);
    {
      let extended = function($$renderer3) {
        CommunityTitle($$renderer3, { community: data.community.value.community_view.community });
      };
      Header($$renderer2, {
        pageHeader: true,
        extended,
        children: ($$renderer3) => {
          $$renderer3.push(`<span>Settings</span>`);
        }
      });
    }
    $$renderer2.push(`<!----> `);
    {
      let formtitle = function($$renderer3) {
      };
      CommunityForm($$renderer2, {
        edit: data.community.value.community_view.community.id,
        formData: {
          name: data.community.value.community_view.community.name,
          displayName: data.community.value.community_view.community.title,
          nsfw: data.community.value.community_view.community.nsfw,
          postsLockedToModerators: data.community.value.community_view.community.posting_restricted_to_mods,
          sidebar: data.community.value.community_view.community.description ?? "",
          icon: data.community.value.community_view.community.icon,
          banner: data.community.value.community_view.community.banner,
          visibility: data.community.value.community_view.community.visibility,
          submitting: false,
          languages: data.community.value.discussion_languages
        },
        formtitle,
        $$slots: { formtitle: true }
      });
    }
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
