import { e as escape_html, s as store_get, u as unsubscribe_stores } from "../../../../../../chunks/index3.js";
import { B as Button, o as Plus, h as Avatar, p as profile, a as getClient, t as toast, e as errorMessage } from "../../../../../../chunks/client.svelte.js";
import { t } from "../../../../../../chunks/index.js";
import { U as UserAutocomplete } from "../../../../../../chunks/UserAutocomplete.js";
import { H as Header } from "../../../../../../chunks/Header.js";
import "@sveltejs/kit/internal";
import "../../../../../../chunks/exports.js";
import "../../../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { C as CommonList } from "../../../../../../chunks/CommonList.js";
import { I as Icon } from "../../../../../../chunks/Icon.js";
import { T as Trash } from "../../../../../../chunks/Trash.js";
import { m as modal, a as action } from "../../../../../../chunks/modal2.js";
import "../../../../../../chunks/settings.svelte.js";
import "openapi-fetch";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    let formData = { newModerator: -1, addingModerator: false };
    async function removeMod(id) {
      if (!profile.current?.jwt) return;
      try {
        const res = await getClient().addModToCommunity({
          added: false,
          community_id: data.community.value.community_view.community.id,
          person_id: id
        });
        data.community.value.moderators = res.moderators;
        toast({
          content: store_get($$store_subs ??= {}, "$t", t)("toast.updateMods"),
          type: "success"
        });
      } catch (err) {
        toast({ content: errorMessage(err), type: "error" });
      }
    }
    Header($$renderer2, {
      pageHeader: true,
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->Moderators`);
      }
    });
    $$renderer2.push(`<!----> `);
    {
      let item = function($$renderer3, moderator) {
        $$renderer3.push(`<div class="flex items-center gap-2 justify-between"><div class="flex gap-2 items-center">`);
        Avatar($$renderer3, {
          width: 28,
          url: moderator.moderator.avatar,
          alt: moderator.moderator.name
        });
        $$renderer3.push(`<!----> <div class="flex flex-col gap-0">${escape_html(moderator.moderator.display_name ?? moderator.moderator.name)} <span class="text-xs text-slate-600 dark:text-zinc-400">${escape_html(new URL(moderator.moderator.actor_id).hostname)}</span></div></div> `);
        Button($$renderer3, {
          size: "square-md",
          onclick: () => {
            modal({
              title: store_get($$store_subs ??= {}, "$t", t)("common.remove"),
              body: `Are you sure you want to remove ${moderator.moderator.name} as a moderator?`,
              actions: [
                action({
                  content: store_get($$store_subs ??= {}, "$t", t)("common.remove"),
                  action: () => removeMod(moderator.moderator.id),
                  type: "danger",
                  close: true
                }),
                action({
                  content: store_get($$store_subs ??= {}, "$t", t)("common.cancel"),
                  close: true
                })
              ]
            });
          },
          children: ($$renderer4) => {
            Icon($$renderer4, { src: Trash, mini: true, size: "16" });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></div>`);
      };
      CommonList($$renderer2, {
        items: data.community.value.moderators,
        item
      });
    }
    $$renderer2.push(`<!----> <form class="mt-auto flex gap-2 w-full mb-3 sm:mb-6"><div class="w-full">`);
    UserAutocomplete($$renderer2, {
      listing_type: "All",
      onselect: (p) => formData.newModerator = p.id
    });
    $$renderer2.push(`<!----></div> `);
    Button($$renderer2, {
      loading: formData.addingModerator,
      disabled: formData.addingModerator,
      rounding: "xl",
      color: "primary",
      submit: true,
      icon: Plus,
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.add"))}`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></form>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
