import { r as resolve } from "../../../../../chunks/server2.js";
import { p as profile, c as client } from "../../../../../chunks/client.svelte.js";
import { redirect } from "@sveltejs/kit";
async function load({ params, fetch }) {
  if (profile.current.instance != params.instance)
    redirect(302, resolve("/comment/[instance]/[id]/confirm", params));
  const comment = await client({
    instanceURL: profile.current.instance,
    func: fetch
  }).getComment({
    id: Number(params.id)
  });
  const split = comment.comment_view.comment.path.split(".");
  const threadPath = split.slice(-3).join(".");
  redirect(
    302,
    resolve(
      `/post/[instance]/[id]?thread=${threadPath}#${comment.comment_view.comment.id}`,
      {
        instance: encodeURIComponent(params.instance),
        id: comment.comment_view.post.id.toString()
      }
    )
  );
}
export {
  load
};
//# sourceMappingURL=_page.ts.js.map
