import { e as escape_html, s as store_get, d as ensure_array_like, k as stringify, u as unsubscribe_stores } from "../../../../../../chunks/index3.js";
import { p as profile, B as Button, M as Material, o as Plus, c as client, g as goto, t as toast, e as errorMessage } from "../../../../../../chunks/client.svelte.js";
import { r as resolve } from "../../../../../../chunks/server2.js";
import { p as page } from "../../../../../../chunks/index4.js";
import { t } from "../../../../../../chunks/index.js";
import { P as ProfileButton } from "../../../../../../chunks/ProfileButton.js";
import { H as Header } from "../../../../../../chunks/Header.js";
import "clsx";
import "../../../../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@dicebear/core";
import "@dicebear/initials";
import { S as SidebarButton } from "../../../../../../chunks/SidebarButton.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let loading = false;
    const fetched = profile.current.instance;
    async function fetchOnHome() {
      loading = true;
      try {
        const res = await client().resolveObject({
          q: `https://${page.params.instance}/comment/${page.params.id}`
        });
        if (res.comment) {
          goto(resolve(`/comment/[instance]/[id]`, {
            instance: profile.current.instance,
            id: res.comment.comment.id.toString()
          }));
        }
      } catch (err) {
        toast({ content: errorMessage(err), type: "error" });
      }
      loading = false;
    }
    $$renderer2.push(`<div class="w-full h-full flex flex-col justify-center mx-auto max-w-xl gap-6"><header class="space-y-1"><div class="font-mono bg-slate-100 dark:bg-zinc-950 rounded-xs p-0.5 px-1 w-max">${escape_html(page.params.instance)}/comment/${escape_html(page.params.id)}</div> `);
    Header($$renderer2, {
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.postRedirect.title"))}`);
      }
    });
    $$renderer2.push(`<!----> <p>${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.postRedirect.description", { homeInstance: fetched }))}</p></header> <div class="flex flex-row items-center gap-2 flex-wrap">`);
    if (profile.current.jwt) {
      $$renderer2.push("<!--[-->");
      Button($$renderer2, {
        loading,
        disabled: loading,
        size: "md",
        rounding: "pill",
        color: "primary",
        onclick: fetchOnHome,
        children: ($$renderer3) => {
          $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.postRedirect.actions.fetch", { homeInstance: fetched }))}`);
        },
        $$slots: { default: true }
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    Button($$renderer2, {
      size: "md",
      rounding: "pill",
      onclick: () => history.back(),
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.postRedirect.actions.back"))}`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div> `);
    if (profile.meta.profiles) {
      $$renderer2.push("<!--[-->");
      const filtered = profile.meta.profiles.filter((i) => i.instance == page.params.instance);
      $$renderer2.push(`<div class="space-y-1"><div class="font-medium text-sm">${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.postRedirect.actions.switch", { destInstance: page.params.instance }))}</div> `);
      Material($$renderer2, {
        color: "uniform",
        padding: "sm",
        rounding: "2xl",
        class: "dark:bg-zinc-950 max-h-96 overflow-auto",
        children: ($$renderer3) => {
          $$renderer3.push(`<!--[-->`);
          const each_array = ensure_array_like(filtered);
          for (let index = 0, $$length = each_array.length; index < $$length; index++) {
            let profile2 = each_array[index];
            ProfileButton($$renderer3, { prof: profile2, index });
          }
          $$renderer3.push(`<!--]--> `);
          SidebarButton($$renderer3, {
            href: `/accounts/login/guest?redirect=${stringify(page.url)}`,
            icon: Plus,
            class: "rounded-lg",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.addGuest"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
