import { s as store_get, e as escape_html, u as unsubscribe_stores } from "../../../chunks/index3.js";
import { s as site, p as profile } from "../../../chunks/client.svelte.js";
import { t } from "../../../chunks/index.js";
import { H as Header } from "../../../chunks/Header.js";
import { T as Tabs } from "../../../chunks/Tabs.js";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import "../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@dicebear/core";
import "@dicebear/initials";
function _layout($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { children } = $$props;
    if (!site || !(site.data?.site_view.local_site.community_creation_admin_only && !profile.isAdmin)) {
      $$renderer2.push("<!--[-->");
      Tabs($$renderer2, {
        margin: false,
        routes: [
          {
            href: "/create/post",
            name: store_get($$store_subs ??= {}, "$t", t)("nav.create.post")
          },
          {
            href: "/create/community",
            name: store_get($$store_subs ??= {}, "$t", t)("nav.create.community")
          }
        ]
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    Header($$renderer2, {
      pageHeader: true,
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.create.label"))}`);
      }
    });
    $$renderer2.push(`<!----> `);
    children?.($$renderer2);
    $$renderer2.push(`<!---->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _layout as default
};
//# sourceMappingURL=_layout.svelte.js.map
