import { h as head, e as escape_html, s as store_get, u as unsubscribe_stores, b as attr, d as ensure_array_like } from "../../../chunks/index3.js";
import { p as page } from "../../../chunks/index4.js";
import { c as client, L as LINKED_INSTANCE_URL, p as profile } from "../../../chunks/client.svelte.js";
import { t } from "../../../chunks/index.js";
import { L as Location } from "../../../chunks/Location.js";
import { S as Sort } from "../../../chunks/Sort.js";
import { H as Header } from "../../../chunks/Header.js";
import { T as Tabs } from "../../../chunks/Tabs.js";
import { S as SearchBar } from "../../../chunks/SearchBar.js";
import "../../../chunks/settings.svelte.js";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import { S as ServerStack } from "../../../chunks/ServerStack.js";
import { O as Option } from "../../../chunks/Select.js";
import "@dicebear/core";
import "@dicebear/initials";
import "openapi-fetch";
function _layout($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data, children } = $$props;
    let search = page.data.query || "";
    let form = void 0;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.explore.title"))}</title>`);
        });
      });
      if (client().getTopics && client().getFeeds) {
        $$renderer3.push("<!--[-->");
        Tabs($$renderer3, {
          routes: [
            {
              href: "/explore/communities",
              name: store_get($$store_subs ??= {}, "$t", t)("routes.communities.title")
            },
            {
              href: "/explore/feeds",
              name: store_get($$store_subs ??= {}, "$t", t)("routes.explore.feeds")
            },
            {
              href: "/explore/topics",
              name: store_get($$store_subs ??= {}, "$t", t)("routes.explore.topics")
            }
          ]
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      {
        let extended = function($$renderer4) {
          if (page.route.id == "/explore/communities") {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<form method="get"${attr("action", page.url.pathname)} class="contents">`);
            SearchBar($$renderer4, {
              get query() {
                return search;
              },
              set query($$value) {
                search = $$value;
                $$settled = false;
              }
            });
            $$renderer4.push(`<!----> <div class="flex flex-row flex-wrap gap-4 items-center">`);
            Location($$renderer4, {
              name: "type",
              selected: data.type,
              onchange: () => form?.requestSubmit(),
              children: ($$renderer5) => {
                if (!LINKED_INSTANCE_URL) {
                  $$renderer5.push("<!--[-->");
                  const instanceSet = new Set(profile.meta.profiles.map((i) => i.instance));
                  if (instanceSet.size > 1) {
                    $$renderer5.push("<!--[-->");
                    Option($$renderer5, {
                      disabled: true,
                      "data-label": "true",
                      children: ($$renderer6) => {
                        $$renderer6.push(`<!---->—`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer5.push(`<!----> <!--[-->`);
                    const each_array = ensure_array_like(instanceSet);
                    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                      let instance = each_array[$$index];
                      Option($$renderer5, {
                        icon: ServerStack,
                        value: encodeURIComponent(`instance-${instance}`),
                        children: ($$renderer6) => {
                          $$renderer6.push(`<!---->${escape_html(instance)}`);
                        },
                        $$slots: { default: true }
                      });
                    }
                    $$renderer5.push(`<!--]-->`);
                  } else {
                    $$renderer5.push("<!--[!-->");
                  }
                  $$renderer5.push(`<!--]-->`);
                } else {
                  $$renderer5.push("<!--[!-->");
                }
                $$renderer5.push(`<!--]-->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Sort($$renderer4, {
              name: "sort",
              selected: data.sort,
              onchange: () => form?.requestSubmit()
            });
            $$renderer4.push(`<!----></div></form>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]-->`);
        };
        Header($$renderer3, {
          pageHeader: true,
          extended,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.explore.title"))}`);
          }
        });
      }
      $$renderer3.push(`<!----> `);
      children?.($$renderer3);
      $$renderer3.push(`<!---->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _layout as default
};
//# sourceMappingURL=_layout.svelte.js.map
