import { a as attr_class, b as attr, c as clsx, s as store_get, e as escape_html, u as unsubscribe_stores, f as bind_props, d as ensure_array_like, j as attr_style, k as stringify } from "../../../../chunks/index3.js";
import { n as navigating, p as page } from "../../../../chunks/index4.js";
import { t } from "../../../../chunks/index.js";
import { C as CommunityItem } from "../../../../chunks/CommunityItem.js";
import { m as communityLink, Z as optimizeImageURL, _ as Blobs, h as Avatar, N as NoSymbol, B as Button, o as Plus, c as client, p as profile, M as Material } from "../../../../chunks/client.svelte.js";
import { I as Icon } from "../../../../chunks/Icon.js";
import { C as Check } from "../../../../chunks/Check.js";
import { E as ExclamationTriangle } from "../../../../chunks/ExclamationTriangle.js";
import { I as InformationCircle } from "../../../../chunks/InformationCircle.js";
import { M as MapPin } from "../../../../chunks/MapPin.js";
import { T as Trash } from "../../../../chunks/Trash.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import { m as modal } from "../../../../chunks/modal2.js";
import { S as Subscribe } from "../../../../chunks/Subscribe.js";
import "../../../../chunks/settings.svelte.js";
import "openapi-fetch";
import { a as addSubscription } from "../../../../chunks/index6.js";
import { C as CommunityCard } from "../../../../chunks/CommunityCard.js";
import { F as Fixate } from "../../../../chunks/Fixate.js";
import { S as Skeleton } from "../../../../chunks/Skeleton.js";
import { P as Placeholder } from "../../../../chunks/Placeholder.js";
import "clsx";
import { C as CommonList } from "../../../../chunks/CommonList.js";
import { Q as QuestionMarkCircle } from "../../../../chunks/QuestionMarkCircle.js";
import { P as Pageination } from "../../../../chunks/Pageination.js";
import "@sveltejs/kit";
import "lemmy-js-client";
import "@dicebear/core";
import "@dicebear/initials";
import { E as EndPlaceholder } from "../../../../chunks/EndPlaceholder.js";
function CommunityItemBig($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { community = void 0, resolveObject, children } = $$props;
    function communityInfo($$renderer3) {
      CommunityCard($$renderer3, { community_view: community });
    }
    $$renderer2.push(`<div${attr_class(clsx([
      "flex flex-col items-start gap-2 p-4 h-full cursor-pointer",
      "rounded-[inherit] overflow-hidden hover:bg-slate-50 hover:dark:bg-zinc-925 relative z-0 transition-colors"
    ]))}><a${attr("href", communityLink(community.community))}${attr("aria-label", store_get($$store_subs ??= {}, "$t", t)("aria.postDecor.openLink"))} class="absolute inset-0 z-10"></a> <div class="-m-4 mask-b-from-25% relative h-24" style="min-width: calc(100% + calc(var(--spacing) * 8));">`);
    if (community.community.banner) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<img${attr("src", optimizeImageURL(community.community.banner, 512))} alt="" class="object-cover min-h-full min-w-full"/>`);
    } else {
      $$renderer2.push("<!--[!-->");
      if (community.community.icon) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<img${attr("src", community.community.icon)} alt="" class="object-cover blur-3xl"/>`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<div class="scale-200 min-w-full mask-b-from-25%">`);
        Blobs($$renderer2, { seed: community.community.name });
        $$renderer2.push(`<!----></div>`);
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></div> <div class="flex flex-row justify-between w-full items-start"><header class="flex-1 flex flex-col group"><h3 class="font-medium overflow-hidden text-ellipsis leading-5 text-xl font-display">${escape_html(community.community.title)}</h3> <p class="text-sm text-slate-600 dark:text-zinc-400">${escape_html(new URL(community.community.actor_id).hostname)}</p></header> `);
    Avatar($$renderer2, {
      url: community.community.icon,
      alt: community.community.title,
      width: 48,
      circle: null,
      class: "rounded-xl"
    });
    $$renderer2.push(`<!----></div> `);
    if (community.community.deleted) {
      $$renderer2.push("<!--[-->");
      Icon($$renderer2, {
        src: Trash,
        class: "text-red-500 inline",
        micro: true,
        size: "14",
        title: store_get($$store_subs ??= {}, "$t", t)("post.badges.deleted")
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (community.community.nsfw) {
      $$renderer2.push("<!--[-->");
      Icon($$renderer2, {
        src: ExclamationTriangle,
        class: "text-red-500 inline",
        micro: true,
        size: "14",
        title: store_get($$store_subs ??= {}, "$t", t)("post.badges.nsfw")
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (community.banned_from_community) {
      $$renderer2.push("<!--[-->");
      Icon($$renderer2, {
        src: NoSymbol,
        class: "text-red-500 inline",
        micro: true,
        size: "14",
        title: store_get($$store_subs ??= {}, "$t", t)("comment.banned")
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (community.community.visibility == "LocalOnly") {
      $$renderer2.push("<!--[-->");
      Icon($$renderer2, {
        src: MapPin,
        class: "text-green-500 inline",
        micro: true,
        size: "14",
        title: store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.listingType.local")
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div class="flex gap-2 items-center justify-end w-full z-30 mt-auto">`);
    Button($$renderer2, {
      rounding: "xl",
      color: "ghost",
      onclick: () => modal({
        title: store_get($$store_subs ??= {}, "$t", t)("form.post.community"),
        snippet: communityInfo
      }),
      "aria-label": store_get($$store_subs ??= {}, "$t", t)("common.info"),
      size: "square-md",
      children: ($$renderer3) => {
        Icon($$renderer3, { src: InformationCircle, size: "16", mini: true });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    {
      let children2 = function($$renderer3, { subscribe, subscribing }) {
        const subscribed = community.subscribed == "Subscribed" || community.subscribed == "Pending";
        Button($$renderer3, {
          disabled: subscribing || !profile.current?.jwt,
          loading: subscribing,
          onclick: async () => {
            const object = resolveObject && await client().resolveObject({ q: community.community.actor_id });
            const res = object ? await subscribe(object.community?.community.id) : await subscribe();
            if (res) {
              const newSubscribed = res.community_view.subscribed != "NotSubscribed" ? "Subscribed" : "NotSubscribed";
              community.subscribed = newSubscribed;
              addSubscription(community.community, newSubscribed == "Subscribed");
            }
          },
          title: subscribed ? store_get($$store_subs ??= {}, "$t", t)("cards.community.subscribed") : store_get($$store_subs ??= {}, "$t", t)("cards.community.subscribe"),
          color: subscribed ? "secondary" : "primary",
          class: [subscribed && "text-slate-600 dark:text-zinc-400"],
          icon: subscribed ? Check : Plus,
          children: ($$renderer4) => {
            $$renderer4.push(`<span${attr_class(clsx(["@md:block"]))}>`);
            if (subscribed) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.community.subscribed"))}`);
            } else {
              $$renderer4.push("<!--[!-->");
              $$renderer4.push(`${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.community.subscribe"))}`);
            }
            $$renderer4.push(`<!--]--></span>`);
          },
          $$slots: { default: true }
        });
      };
      Subscribe($$renderer2, { community, children: children2 });
    }
    $$renderer2.push(`<!----></div> `);
    if (children) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="flex flex-row gap-2 items-center">`);
      children?.($$renderer2);
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { community });
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    let showTop = (data.query ?? false) && data.communities.length > 0 && data.page == 1;
    if (navigating.to?.route.id == "/communities") {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="flex flex-col gap-3"><!--[-->`);
      const each_array = ensure_array_like(new Array(5));
      for (let index = 0, $$length = each_array.length; index < $$length; index++) {
        let _ = each_array[index];
        $$renderer2.push(`<!---->${escape_html(_)} <div${attr_style(`width: ${stringify(1 / ((index + 1) % 3) * 100)}%`)}>`);
        Skeleton($$renderer2);
        $$renderer2.push(`<!----></div>`);
      }
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<ul class="flex flex-col h-full">`);
      if (data.communities.length == 0) {
        $$renderer2.push("<!--[-->");
        Placeholder($$renderer2, {
          icon: QuestionMarkCircle,
          title: store_get($$store_subs ??= {}, "$t", t)("routes.search.noResults.title"),
          description: store_get($$store_subs ??= {}, "$t", t)("routes.search.noResults.description")
        });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (showTop) {
        $$renderer2.push("<!--[-->");
        EndPlaceholder($$renderer2, {
          size: "lg",
          margin: "md",
          children: ($$renderer3) => {
            $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.search.top"))}`);
          }
        });
        $$renderer2.push(`<!----> <div class="grid md:grid-cols-2 xl:grid-cols-3 gap-4 items-center border-0!"><!--[-->`);
        const each_array_1 = ensure_array_like(data.communities.slice(0, 3));
        for (let index = 0, $$length = each_array_1.length; index < $$length; index++) {
          let community = each_array_1[index];
          $$renderer2.push(`<div class="h-full">`);
          Material($$renderer2, {
            padding: "none",
            rounding: "3xl",
            class: "h-full",
            children: ($$renderer3) => {
              CommunityItemBig($$renderer3, { community });
            },
            $$slots: { default: true }
          });
          $$renderer2.push(`<!----></div>`);
        }
        $$renderer2.push(`<!--]--></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (data.communities.slice(showTop ? 3 : 0).length > 0) {
        $$renderer2.push("<!--[-->");
        EndPlaceholder($$renderer2, {
          size: "lg",
          margin: "md",
          children: ($$renderer3) => {
            $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.search.other"))}`);
          }
        });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (data.communities) {
        $$renderer2.push("<!--[-->");
        const sliced = data.communities.slice(showTop ? 3 : 0);
        {
          let item = function($$renderer3, community) {
            CommunityItem($$renderer3, {
              community,
              resolveObject: data.type.startsWith("instance-"),
              showCounts: false
            });
          };
          CommonList($$renderer2, { items: sliced, item });
        }
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></ul>`);
    }
    $$renderer2.push(`<!--]--> `);
    Fixate($$renderer2, {
      placement: "bottom",
      children: ($$renderer3) => {
        Pageination($$renderer3, {
          page: Number(page.url.searchParams.get("page")) || 1,
          href: (c) => `?page=${c}`,
          hasMore: data.communities.length >= 40
        });
      }
    });
    $$renderer2.push(`<!---->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
