import { c as client } from "../../../../chunks/client.svelte.js";
import { f as feed } from "../../../../chunks/feed.svelte.js";
async function load({ fetch, parent }) {
  const { page, query, sort, type, typeInstance } = await parent();
  const feedData = await feed(
    "/explore/communities",
    async (params) => params.query != "" ? await client({ func: fetch, instanceURL: typeInstance }).search({
      limit: 40,
      page: params.page,
      sort: params.sort,
      type_: "Communities",
      listing_type: params.type,
      q: params.query
    }) : await client({
      func: fetch,
      instanceURL: typeInstance
    }).listCommunities({
      limit: 40,
      page: params.page,
      sort: params.sort,
      type_: params.type,
      show_nsfw: true
    })
  ).load({
    page,
    query,
    sort,
    type
  });
  return {
    communities: feedData.communities,
    type,
    sort,
    query,
    page
  };
}
export {
  load
};
//# sourceMappingURL=_page.ts.js.map
