import "clsx";
import { t } from "../../../../chunks/index.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import { h as Avatar, B as Button, i as Markdown } from "../../../../chunks/client.svelte.js";
import { C as CommonList } from "../../../../chunks/CommonList.js";
import "../../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
import "@dicebear/core";
import "@dicebear/initials";
import { e as escape_html, k as stringify, s as store_get, u as unsubscribe_stores } from "../../../../chunks/index3.js";
import { L as LabelStat } from "../../../../chunks/LabelStat.js";
import { C as CommonItem } from "../../../../chunks/CommonItem.js";
import { I as InformationCircle } from "../../../../chunks/InformationCircle.js";
import { m as modal } from "../../../../chunks/modal2.js";
function Entity($$renderer, $$props) {
  let { name, label = void 0, icon = void 0, customIcon } = $$props;
  $$renderer.push(`<div class="flex flex-row gap-2 items-center">`);
  if (customIcon) {
    $$renderer.push("<!--[-->");
    customIcon($$renderer);
    $$renderer.push(`<!---->`);
  } else {
    $$renderer.push("<!--[!-->");
    Avatar($$renderer, { url: icon, width: 32, alt: name, circle: false });
  }
  $$renderer.push(`<!--]--> <div class="flex flex-col"><span class="font-semibold text-base">${escape_html(name)}</span> <span class="text-sm">${escape_html(label)}</span></div></div>`);
}
function FeedItem($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { feed } = $$props;
    function feedModal($$renderer3) {
      Entity($$renderer3, { icon: feed.icon, name: feed.title, label: feed.name });
      $$renderer3.push(`<!----> `);
      Markdown($$renderer3, { source: feed.description });
      $$renderer3.push(`<!----> `);
      LabelStat($$renderer3, {
        label: store_get($$store_subs ??= {}, "$t", t)("cards.community.members"),
        content: feed.subscriptions_count
      });
      $$renderer3.push(`<!---->`);
    }
    CommonItem($$renderer2, {
      icon: feed.icon,
      title: feed.title,
      detail: `${stringify(feed.name)} • ${stringify(feed.subscriptions_count)}`,
      href: `/f/${stringify(feed.id)}`,
      children: ($$renderer3) => {
        Button($$renderer3, {
          onclick: () => modal({
            title: store_get($$store_subs ??= {}, "$t", t)("common.info"),
            snippet: feedModal
          }),
          color: "ghost",
          size: "custom",
          rounding: "xl",
          class: "h-8.5 aspect-square",
          icon: InformationCircle,
          "aria-label": store_get($$store_subs ??= {}, "$t", t)("common.info")
        });
      }
    });
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { data } = $$props;
    {
      let item = function($$renderer3, feed) {
        FeedItem($$renderer3, { feed });
      };
      CommonList($$renderer2, { items: data.feeds.value, item });
    }
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
