import { h as head, f as bind_props, e as escape_html, g as await_block, s as store_get, u as unsubscribe_stores } from "../../../../chunks/index3.js";
import { t } from "../../../../chunks/index.js";
import { E as Expandable, S as SvelteURL, m as communityLink, y as Spinner } from "../../../../chunks/client.svelte.js";
import { E as EntityHeader } from "../../../../chunks/EntityHeader.js";
import { I as ItemList } from "../../../../chunks/ItemList.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import "../../../../chunks/settings.svelte.js";
import { P as PostListShell } from "../../../../chunks/PostListShell.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data = void 0 } = $$props;
    let title = "Loading...";
    data.feed.then((i) => title = i?.title ?? "");
    head($$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>
    ${escape_html(title)}
  </title>`);
      });
    });
    {
      let extended = function($$renderer3) {
        $$renderer3.push(`<div class="min-h-56 grid place-items-center">`);
        await_block(
          $$renderer3,
          data.feed,
          () => {
            Spinner($$renderer3, { width: 32 });
          },
          (feed) => {
            if (feed) {
              $$renderer3.push("<!--[-->");
              {
                let nameDetail = function($$renderer4) {
                  $$renderer4.push(`<p class="text-lg">${escape_html(feed.name)}</p>`);
                };
                EntityHeader($$renderer3, {
                  class: "w-full relative flex flex-col",
                  compact: "always",
                  avatarCircle: false,
                  name: feed.title,
                  avatar: feed.icon,
                  nameDetail,
                  children: ($$renderer4) => {
                    if (feed.communities) {
                      $$renderer4.push("<!--[-->");
                      {
                        let title2 = function($$renderer5) {
                          $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.communities"))}`);
                        };
                        Expandable($$renderer4, {
                          title: title2,
                          children: ($$renderer5) => {
                            ItemList($$renderer5, {
                              items: feed.communities.map((i) => ({
                                id: i.id,
                                name: i.title,
                                url: communityLink(i),
                                avatar: i.icon,
                                instance: new SvelteURL(i.actor_id).hostname
                              }))
                            });
                          },
                          $$slots: { title: true, default: true }
                        });
                      }
                    } else {
                      $$renderer4.push("<!--[!-->");
                    }
                    $$renderer4.push(`<!--]-->`);
                  },
                  $$slots: { nameDetail: true, default: true }
                });
              }
            } else {
              $$renderer3.push("<!--[!-->");
            }
            $$renderer3.push(`<!--]-->`);
          }
        );
        $$renderer3.push(`<!--]--></div>`);
      };
      PostListShell($$renderer2, {
        posts: data.posts,
        cursor: data.next_page,
        client: data.client,
        getParams: data.params,
        params: { sort: data.params.sort },
        extended,
        $$slots: { extended: true }
      });
    }
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { data });
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
